/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.ITileDefinition;
import appeng.block.AEBaseTileBlock;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntity;

public final class TileDefinition
extends BlockDefinition
implements ITileDefinition {
    private static final TileEntityTransformer TILEENTITY_TRANSFORMER = new TileEntityTransformer();
    private final Optional<AEBaseTileBlock> block;

    public TileDefinition(AEBaseTileBlock block, ActivityState state) {
        super(block, state);
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkNotNull(block.getTileEntityClass());
        this.block = state == ActivityState.Enabled ? Optional.of((Object)block) : Optional.absent();
    }

    @Override
    public Optional<? extends Class<? extends TileEntity>> maybeEntity() {
        return this.block.transform((Function)TILEENTITY_TRANSFORMER);
    }

    private static class TileEntityTransformer
    implements Function<AEBaseTileBlock, Class<? extends TileEntity>> {
        private TileEntityTransformer() {
        }

        public Class<? extends TileEntity> apply(AEBaseTileBlock input) {
            Class<? extends TileEntity> entity = input.getTileEntityClass();
            return entity;
        }
    }
}

