/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.integration.IntegrationType;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.LinkedList;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.InterfaceList(value={@Integration.Interface(iface="ic2.api.energy.tile.IEnergySink", iname=IntegrationType.IC2), @Integration.Interface(iface="ic2.api.energy.tile.IEnergySource", iname=IntegrationType.IC2)})
public class PartP2PIC2Power
extends PartP2PTunnel<PartP2PIC2Power>
implements IEnergySink,
IEnergySource {
    private double OutputEnergyA;
    private double OutputEnergyB;
    private double OutputVoltageA;
    private double OutputVoltageB;

    public PartP2PIC2Power(ItemStack is) {
        super(is);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150484_ah.func_149733_h(0);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.OutputEnergyA = tag.func_74769_h("OutputPacket");
        this.OutputEnergyB = tag.func_74769_h("OutputPacket2");
        this.OutputVoltageA = tag.func_74769_h("OutputVoltageA");
        this.OutputVoltageB = tag.func_74769_h("OutputVoltageB");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("OutputPacket", this.OutputEnergyA);
        tag.func_74780_a("OutputPacket2", this.OutputEnergyB);
        tag.func_74780_a("OutputVoltageA", this.OutputVoltageA);
        tag.func_74780_a("OutputVoltageB", this.OutputVoltageB);
    }

    @Override
    public void onTunnelConfigChange() {
        this.getHost().partChanged();
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (!this.isOutput()) {
            return direction == this.getSide();
        }
        return false;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.isOutput()) {
            return direction == this.getSide();
        }
        return false;
    }

    public double getDemandedEnergy() {
        if (this.isOutput()) {
            return 0.0;
        }
        try {
            for (PartP2PIC2Power t : this.getOutputs()) {
                if (!(t.OutputEnergyA <= 1.0E-4) && !(t.OutputEnergyB <= 1.0E-4)) continue;
                return 2048.0;
            }
        }
        catch (GridAccessException e) {
            return 0.0;
        }
        return 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        TunnelCollection outs;
        try {
            outs = this.getOutputs();
        }
        catch (GridAccessException e) {
            return amount;
        }
        if (outs.isEmpty()) {
            return amount;
        }
        LinkedList<PartP2PIC2Power> options = new LinkedList<PartP2PIC2Power>();
        for (PartP2PIC2Power o : outs) {
            if (!(o.OutputEnergyA <= 0.01)) continue;
            options.add(o);
        }
        if (options.isEmpty()) {
            for (PartP2PIC2Power o : outs) {
                if (!(o.OutputEnergyB <= 0.01)) continue;
                options.add(o);
            }
        }
        if (options.isEmpty()) {
            for (PartP2PIC2Power o : outs) {
                options.add(o);
            }
        }
        if (options.isEmpty()) {
            return amount;
        }
        PartP2PIC2Power x = (PartP2PIC2Power)Platform.pickRandom(options);
        if (x != null && x.OutputEnergyA <= 0.001) {
            this.queueTunnelDrain(PowerUnits.EU, amount);
            x.OutputEnergyA = amount;
            x.OutputVoltageA = voltage;
            return 0.0;
        }
        if (x != null && x.OutputEnergyB <= 0.001) {
            this.queueTunnelDrain(PowerUnits.EU, amount);
            x.OutputEnergyB = amount;
            x.OutputVoltageB = voltage;
            return 0.0;
        }
        return amount;
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    public double getOfferedEnergy() {
        if (this.isOutput()) {
            return this.OutputEnergyA;
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
        this.OutputEnergyA -= amount;
        if (this.OutputEnergyA < 0.001) {
            this.OutputEnergyA = this.OutputEnergyB;
            this.OutputEnergyB = 0.0;
            this.OutputVoltageA = this.OutputVoltageB;
            this.OutputVoltageB = 0.0;
        }
    }

    public int getSourceTier() {
        if (this.isOutput()) {
            return this.calculateTierFromVoltage(this.OutputVoltageA);
        }
        return 4;
    }

    private int calculateTierFromVoltage(double voltage) {
        return EnergyNet.instance.getTierFromPower(voltage);
    }
}

