/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.ActionKey;
import appeng.client.EffectType;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.TESRWrapper;
import appeng.client.render.WorldRender;
import appeng.client.render.effects.AssemblerFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.VibrantFX;
import appeng.client.texture.CableBusTextures;
import appeng.client.texture.ExtraBlockTextures;
import appeng.client.texture.ExtraItemTextures;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.entity.EntityFloatingItem;
import appeng.entity.EntityTinyTNTPrimed;
import appeng.entity.RenderFloatingItem;
import appeng.entity.RenderTinyTNTPrimed;
import appeng.helpers.HighlighterHandler;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.TickHandler;
import appeng.server.ServerHelper;
import appeng.transformer.MissingCoreMod;
import appeng.util.Platform;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientHelper
extends ServerHelper {
    private static final String KEY_CATEGORY = "key.appliedenergistics2.category";
    private final EnumMap<ActionKey, KeyBinding> bindings = new EnumMap(ActionKey.class);
    private static final RenderItem ITEM_RENDERER = new RenderItem();
    private static final RenderBlocks BLOCK_RENDERER = new RenderBlocks();

    @SubscribeEvent
    public void postPlayerRender(RenderLivingEvent.Pre p) {
        TickHandler.PlayerColor player = TickHandler.INSTANCE.getPlayerColors().get(p.entity.func_145782_y());
        if (player != null) {
            AEColor col = player.myColor;
            float r = 0xFF & col.mediumVariant >> 16;
            float g = 0xFF & col.mediumVariant >> 8;
            float b = 0xFF & col.mediumVariant;
            GL11.glColor3f((float)(r / 255.0f), (float)(g / 255.0f), (float)(b / 255.0f));
        }
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (ActionKey key : ActionKey.values()) {
            KeyBinding binding = new KeyBinding(key.getTranslationKey(), key.getDefaultKey(), KEY_CATEGORY);
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            this.bindings.put(key, binding);
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        HighlighterHandler.tick(event);
    }

    @Override
    public World getWorld() {
        if (Platform.isClient()) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return super.getWorld();
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class tile, AEBaseBlock blk) {
        BaseBlockRender bbr = blk.getRendererInstance().getRendererInstance();
        if (bbr.hasTESR() && tile != null) {
            ClientRegistry.bindTileEntitySpecialRenderer((Class)tile, (TileEntitySpecialRenderer)new TESRWrapper(bbr));
        }
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        if (Platform.isClient()) {
            ArrayList<EntityPlayer> o = new ArrayList<EntityPlayer>();
            o.add((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return o;
        }
        return super.getPlayers();
    }

    @Override
    public void spawnEffect(EffectType effect, World worldObj, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance.enableEffects) {
            switch (effect) {
                case Assembler: {
                    this.spawnAssembler(worldObj, posX, posY, posZ, o);
                    return;
                }
                case Vibrant: {
                    this.spawnVibrant(worldObj, posX, posY, posZ);
                    return;
                }
                case Crafting: {
                    this.spawnCrafting(worldObj, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(worldObj, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(worldObj, posX, posY, posZ);
                    return;
                }
                case LightningArc: {
                    this.spawnLightningArc(worldObj, posX, posY, posZ, (Vec3)o);
                    return;
                }
            }
        }
    }

    private void spawnAssembler(World worldObj, double posX, double posY, double posZ, Object o) {
        PacketAssemblerAnimation paa = (PacketAssemblerAnimation)o;
        AssemblerFX fx = new AssemblerFX((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, 0.0, 0.0, 0.0, paa.rate, paa.is);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void spawnVibrant(World w, double x, double y, double z) {
        if (CommonHelper.proxy.shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            VibrantFX fx = new VibrantFX(w, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void spawnCrafting(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        CraftingFx fx = new CraftingFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.field_70159_w = (double)(-x) * 0.2;
        fx.field_70181_x = (double)(-y) * 0.2;
        fx.field_70179_y = (double)(-z) * 0.2;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void spawnEnergy(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        EnergyFx fx = new EnergyFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.field_70159_w = (double)(-x) * 0.1;
        fx.field_70181_x = (double)(-y) * 0.1;
        fx.field_70179_y = (double)(-z) * 0.1;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void spawnLightning(World worldObj, double posX, double posY, double posZ) {
        LightningFX fx = new LightningFX(worldObj, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void spawnLightningArc(World worldObj, double posX, double posY, double posZ, Vec3 second) {
        LightningArcFX fx = new LightningArcFX(worldObj, posX, posY, posZ, second.field_72450_a, second.field_72448_b, second.field_72449_c, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        int setting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (setting == 2) {
            return false;
        }
        if (setting == 0) {
            return true;
        }
        return r.nextInt(2 * (setting + 1)) == 0;
    }

    @Override
    public MovingObjectPosition getMOP() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @Override
    public void doRenderItem(ItemStack itemstack, World w) {
        if (itemstack != null) {
            EntityItem entityitem = new EntityItem(w, 0.0, 0.0, 0.0, itemstack);
            entityitem.func_92059_d().field_77994_a = 1;
            entityitem.field_70290_d = 0.0f;
            entityitem.field_70292_b = 0;
            entityitem.field_70177_z = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (itemstack.func_77948_v() || itemstack.func_77973_b().func_77623_v()) {
                IItemRenderer customRenderer;
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)-0.25f);
                GL11.glScalef((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)0.005f);
                Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                if (itemstack.func_94608_d() == 0 && block != null && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
                    GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if ((customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY)) != null && !(itemstack.func_77973_b() instanceof ItemBlock)) {
                    if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D)) {
                        GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                        GL11.glRotatef((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                } else if (itemstack.func_77973_b() instanceof ItemBlock) {
                    GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                    GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.14f, (float)0.0f);
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                }
                RenderItem.field_82407_g = true;
                RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                RenderItem.field_82407_g = false;
            } else {
                GL11.glScalef((float)0.023809524f, (float)0.023809524f, (float)0.023809524f);
                GL11.glTranslated((double)-8.0, (double)-10.2, (double)-10.4);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)0.005f);
                RenderItem.field_82407_g = false;
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)BLOCK_RENDERER, (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)itemstack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                    ITEM_RENDERER.renderItemIntoGUI(fr, Minecraft.func_71410_x().field_71446_o, itemstack, 0, 0, false);
                }
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void postInit() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)WorldRender.INSTANCE);
        RenderManager.field_78727_a.field_78729_o.put(EntityTinyTNTPrimed.class, new RenderTinyTNTPrimed());
        RenderManager.field_78727_a.field_78729_o.put(EntityFloatingItem.class, new RenderFloatingItem());
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (Platform.isServer()) {
            return super.getRenderMode();
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        return this.renderModeForPlayer((EntityPlayer)player);
    }

    @Override
    public void triggerUpdates() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        int range = 256;
        mc.field_71441_e.func_147458_c(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public void missingCoreMod() {
        throw new MissingCoreMod();
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.isCanceled() || me.dwheel == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        ItemStack is = player.func_70694_bm();
        if (is != null && is.func_77973_b() instanceof IMouseWheelItem && player.func_70093_af()) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Item", me.dwheel > 0 ? "WheelUp" : "WheelDown"));
                me.setCanceled(true);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @SubscribeEvent
    public void updateTextureSheet(TextureStitchEvent.Pre ev) {
        if (ev.map.func_130086_a() == 1) {
            for (Enum enum_ : ExtraItemTextures.values()) {
                ((ExtraItemTextures)enum_).registerIcon(ev.map);
            }
        }
        if (ev.map.func_130086_a() == 0) {
            for (Enum enum_ : ExtraBlockTextures.values()) {
                ((ExtraBlockTextures)enum_).registerIcon(ev.map);
            }
            for (Enum enum_ : CableBusTextures.values()) {
                ((CableBusTextures)enum_).registerIcon(ev.map);
            }
        }
    }

    @Override
    public boolean isKeyPressed(ActionKey key) {
        return this.bindings.get((Object)key).func_151468_f();
    }

    @Override
    public boolean isActionKey(ActionKey key, int pressedKeyCode) {
        return this.isActiveAndMatches(this.bindings.get((Object)key), pressedKeyCode);
    }

    private boolean isActiveAndMatches(KeyBinding keyBinding, int keyCode) {
        return keyCode != 0 && keyCode == keyBinding.func_151463_i();
    }
}

