/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import appeng.api.util.WorldCoord;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DimensionalCoord
extends WorldCoord {
    private static final WeakReference<World> NULL_WORLD = new WeakReference<Object>(null);
    private final WeakReference<World> w;
    private final int dimId;

    public DimensionalCoord(DimensionalCoord s) {
        super(s.x, s.y, s.z);
        this.w = s.w;
        this.dimId = s.dimId;
    }

    public DimensionalCoord(TileEntity s) {
        super(s);
        this.w = new WeakReference<World>(s.func_145831_w());
        this.dimId = s.func_145831_w().field_73011_w.field_76574_g;
    }

    public DimensionalCoord(World _w, int _x, int _y, int _z) {
        super(_x, _y, _z);
        this.w = new WeakReference<World>(_w);
        this.dimId = _w.field_73011_w.field_76574_g;
    }

    public DimensionalCoord(int _x, int _y, int _z, int _dim) {
        super(_x, _y, _z);
        this.w = NULL_WORLD;
        this.dimId = _dim;
    }

    @Override
    public DimensionalCoord copy() {
        return new DimensionalCoord(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.dimId;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DimensionalCoord && this.isEqual((DimensionalCoord)obj);
    }

    public boolean isEqual(DimensionalCoord c) {
        return this.x == c.x && this.y == c.y && this.z == c.z && c.dimId == this.dimId;
    }

    private static void writeToNBT(NBTTagCompound data, int x, int y, int z, int dimId) {
        data.func_74768_a("dim", dimId);
        data.func_74768_a("x", x);
        data.func_74768_a("y", y);
        data.func_74768_a("z", z);
    }

    public void writeToNBT(NBTTagCompound data) {
        DimensionalCoord.writeToNBT(data, this.x, this.y, this.z, this.dimId);
    }

    public static void writeListToNBT(NBTTagCompound tag, List<DimensionalCoord> list) {
        int i = 0;
        for (DimensionalCoord d : list) {
            NBTTagCompound data = new NBTTagCompound();
            DimensionalCoord.writeToNBT(data, d.x, d.y, d.z, d.dimId);
            tag.func_74782_a("pos#" + i, (NBTBase)data);
            ++i;
        }
    }

    public static DimensionalCoord readFromNBT(NBTTagCompound data) {
        return new DimensionalCoord(data.func_74762_e("x"), data.func_74762_e("y"), data.func_74762_e("z"), data.func_74762_e("dim"));
    }

    public static List<DimensionalCoord> readAsListFromNBT(NBTTagCompound tag) {
        ArrayList<DimensionalCoord> list = new ArrayList<DimensionalCoord>();
        int i = 0;
        while (tag.func_74764_b("pos#" + i)) {
            NBTTagCompound data = tag.func_74775_l("pos#" + i);
            list.add(DimensionalCoord.readFromNBT(data));
            ++i;
        }
        return list;
    }

    @Override
    public String toString() {
        return "dimension=" + this.dimId + ", " + super.toString();
    }

    public boolean isInWorld(World world) {
        return this.w.get() == world;
    }

    public World getWorld() {
        return (World)this.w.get();
    }

    public int getDimension() {
        return this.dimId;
    }
}

