/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.texture;

import appeng.client.texture.TextureUtils;
import javax.annotation.Nonnull;
import net.minecraft.util.IIcon;

public class FlippableIcon
implements IIcon {
    private IIcon original;
    private boolean flip_u;
    private boolean flip_v;

    public FlippableIcon(IIcon o) {
        o = TextureUtils.checkTexture(o);
        if (o == null) {
            throw new IllegalArgumentException("Cannot create a wrapper icon with a null icon.");
        }
        this.setOriginal(o);
        this.setFlipU(false);
        this.setFlipV(false);
    }

    public int func_94211_a() {
        return this.getOriginal().func_94211_a();
    }

    public int func_94216_b() {
        return this.getOriginal().func_94216_b();
    }

    public float func_94209_e() {
        if (this.isFlipU()) {
            return this.getOriginal().func_94212_f();
        }
        return this.getOriginal().func_94209_e();
    }

    public float func_94212_f() {
        if (this.isFlipU()) {
            return this.getOriginal().func_94209_e();
        }
        return this.getOriginal().func_94212_f();
    }

    public float func_94214_a(double px) {
        if (this.isFlipU()) {
            return this.getOriginal().func_94214_a(16.0 - px);
        }
        return this.getOriginal().func_94214_a(px);
    }

    public float func_94206_g() {
        if (this.isFlipV()) {
            return this.getOriginal().func_94210_h();
        }
        return this.getOriginal().func_94206_g();
    }

    public float func_94210_h() {
        if (this.isFlipV()) {
            return this.getOriginal().func_94206_g();
        }
        return this.getOriginal().func_94210_h();
    }

    public float func_94207_b(double px) {
        if (this.isFlipV()) {
            return this.getOriginal().func_94207_b(16.0 - px);
        }
        return this.getOriginal().func_94207_b(px);
    }

    public String func_94215_i() {
        return this.getOriginal().func_94215_i();
    }

    public IIcon getOriginal() {
        return this.original;
    }

    public void setFlip(boolean u, boolean v) {
        this.setFlipU(u);
        this.setFlipV(v);
    }

    public int setFlip(int orientation) {
        this.setFlipU((orientation & 8) == 8);
        this.setFlipV((orientation & 0x10) == 16);
        return orientation & 7;
    }

    boolean isFlipU() {
        return this.flip_u;
    }

    void setFlipU(boolean flipU) {
        this.flip_u = flipU;
    }

    boolean isFlipV() {
        return this.flip_v;
    }

    void setFlipV(boolean flipV) {
        this.flip_v = flipV;
    }

    public void setOriginal(@Nonnull IIcon original) {
        this.original = original;
    }
}

