/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.ores;

import appeng.core.AELog;
import appeng.recipes.game.IRecipeBakeable;
import appeng.recipes.ores.IOreListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    public static final OreDictionaryHandler INSTANCE = new OreDictionaryHandler();
    private final List<IOreListener> oreListeners = new ArrayList<IOreListener>();
    private boolean enableRebaking = false;

    @SubscribeEvent
    public void onOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        if (event.Name == null || event.Ore == null) {
            return;
        }
        if (this.shouldCare(event.Name)) {
            for (IOreListener v : this.oreListeners) {
                v.oreRegistered(event.Name, event.Ore);
            }
        }
        if (this.enableRebaking) {
            this.bakeRecipes();
        }
    }

    private boolean shouldCare(String name) {
        return true;
    }

    public void bakeRecipes() {
        this.enableRebaking = true;
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(o instanceof IRecipeBakeable)) continue;
            try {
                ((IRecipeBakeable)o).bake();
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    public void observe(IOreListener n) {
        this.oreListeners.add(n);
        for (String name : OreDictionary.getOreNames()) {
            if (name == null || !this.shouldCare(name)) continue;
            for (ItemStack item : OreDictionary.getOres((String)name)) {
                if (item == null) continue;
                n.oreRegistered(name, item);
            }
        }
    }
}

