/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGridHost;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerPatternItemRenamer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternItemRenamer
extends AppEngPacket {
    private final GuiBridge originGui;
    private String name = "";
    private final int valueIndex;

    public PacketPatternItemRenamer(ByteBuf stream) {
        this.originGui = GuiBridge.values()[stream.readInt()];
        this.valueIndex = stream.readInt();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stream.array(), stream.readerIndex(), stream.readableBytes()));
        try {
            this.name = dis.readUTF();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PacketPatternItemRenamer(int originalGui, String newName, int newValueIndex) {
        this.originGui = GuiBridge.values()[originalGui];
        this.name = newName;
        this.valueIndex = newValueIndex;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(originalGui);
        data.writeInt(this.valueIndex);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeUTF(this.name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerOpenContext context;
        ContainerPatternItemRenamer cpv;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerPatternItemRenamer && (target = (cpv = (ContainerPatternItemRenamer)container).getTarget()) instanceof IGridHost && (context = cpv.getOpenContext()) != null) {
            Slot slot;
            TileEntity te = context.getTile();
            Platform.openGUI(player, te, cpv.getOpenContext().getSide(), this.originGui);
            if (player.field_71070_bA instanceof IContainerCraftingPacket && (slot = player.field_71070_bA.func_75139_a(this.valueIndex)) != null && slot.func_75216_d()) {
                ItemStack nextStack = slot.func_75211_c().func_77946_l();
                nextStack.func_82841_c(2);
                nextStack.func_151001_c(this.name);
                slot.func_75215_d(nextStack);
            }
        }
    }
}

