/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGridHost;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.container.implementations.ContainerPatternValueAmount;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternValueSet
extends AppEngPacket {
    private final GuiBridge originGui;
    private final int amount;
    private final int valueIndex;

    public PacketPatternValueSet(ByteBuf stream) {
        this.originGui = GuiBridge.values()[stream.readInt()];
        this.amount = stream.readInt();
        this.valueIndex = stream.readInt();
    }

    public PacketPatternValueSet(int originalGui, int amount, int valueIndex) {
        this.originGui = GuiBridge.values()[originalGui];
        this.amount = amount;
        this.valueIndex = valueIndex;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(originalGui);
        data.writeInt(this.amount);
        data.writeInt(this.valueIndex);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerOpenContext context;
        ContainerPatternValueAmount cpv;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerPatternValueAmount && (target = (cpv = (ContainerPatternValueAmount)container).getTarget()) instanceof IGridHost && (context = cpv.getOpenContext()) != null) {
            Slot slot;
            TileEntity te = context.getTile();
            Platform.openGUI(player, te, cpv.getOpenContext().getSide(), this.originGui);
            if ((player.field_71070_bA instanceof ContainerPatternTerm || player.field_71070_bA instanceof ContainerPatternTermEx) && (slot = player.field_71070_bA.func_75139_a(this.valueIndex)) != null && slot.func_75216_d()) {
                ItemStack nextStack = slot.func_75211_c().func_77946_l();
                nextStack.field_77994_a = this.amount;
                slot.func_75215_d(nextStack);
            }
        }
    }
}

