/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.AEApi;
import appeng.api.storage.ICellHandler;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderMEChest;
import appeng.core.features.AEFeature;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.tile.storage.TileChest;
import appeng.util.Platform;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.util.GTUtility;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChest
extends AEBaseTileBlock {
    public BlockChest() {
        super(Material.field_151573_f);
        this.setTileEntity(TileChest.class);
        this.setFeature(EnumSet.of(AEFeature.StorageCells, AEFeature.MEChest));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderMEChest getRenderer() {
        return new RenderMEChest();
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        TileChest tg = (TileChest)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null && !p.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            if (Loader.isModLoaded((String)"dreamcraft") && IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.GT) && GTUtility.isStackInList((ItemStack)p.func_70694_bm(), (Collection)GregTechAPI.sWireCutterList)) {
                if (tg.toggleItemStorageCellLocking()) {
                    p.func_145747_a(PlayerMessages.ChestLockingToggled.toChat());
                }
                return true;
            }
            if (side != tg.getUp().ordinal()) {
                Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_CHEST);
            } else {
                ItemStack cell = tg.func_70301_a(1);
                if (cell != null) {
                    ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
                    tg.openGui(p, ch, cell, side);
                } else {
                    p.func_145747_a(PlayerMessages.ChestCannotReadStorageCell.toChat());
                }
            }
            return true;
        }
        return false;
    }
}

