/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AELog {
    private static final String LOGGER_PREFIX = "AE2:";
    private static final String SERVER_SUFFIX = "S";
    private static final String CLIENT_SUFFIX = "C";
    private static final String BLOCK_UPDATE = "Block Update of %s @ ( %d, %d, %d )";
    private static final String DEFAULT_EXCEPTION_MESSAGE = "Exception: ";

    private AELog() {
    }

    private static Logger getLogger() {
        String loggerName = LOGGER_PREFIX + (Platform.isServer() ? SERVER_SUFFIX : CLIENT_SUFFIX);
        Logger logger = LogManager.getLogger((String)loggerName);
        return logger;
    }

    public static boolean isLogEnabled() {
        return AEConfig.instance == null || AEConfig.instance.isFeatureEnabled(AEFeature.Logging);
    }

    public static void logSimple(@Nonnull Level level, @Nonnull String message) {
        if (AELog.isLogEnabled()) {
            Logger logger = AELog.getLogger();
            logger.log(level, message);
        }
    }

    public static void log(@Nonnull Level level, @Nonnull String message, Object ... params) {
        if (AELog.isLogEnabled()) {
            String formattedMessage = String.format(message, params);
            Logger logger = AELog.getLogger();
            logger.log(level, formattedMessage);
        }
    }

    public static void log(@Nonnull Level level, @Nonnull Throwable exception, @Nonnull String message, Object ... params) {
        if (AELog.isLogEnabled()) {
            String formattedMessage = String.format(message, params);
            Logger logger = AELog.getLogger();
            logger.log(level, formattedMessage, exception);
        }
    }

    public static void info(@Nonnull String format, Object ... params) {
        AELog.log(Level.INFO, format, params);
    }

    public static void info(@Nonnull Throwable exception) {
        AELog.log(Level.INFO, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void info(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.INFO, exception, message, new Object[0]);
    }

    public static void warn(@Nonnull String format, Object ... params) {
        AELog.log(Level.WARN, format, params);
    }

    public static void warn(@Nonnull Throwable exception) {
        AELog.log(Level.WARN, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void warn(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.WARN, exception, message, new Object[0]);
    }

    public static void error(@Nonnull String format, Object ... params) {
        AELog.log(Level.ERROR, format, params);
    }

    public static void error(@Nonnull Throwable exception) {
        AELog.log(Level.ERROR, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
    }

    public static void error(@Nonnull Throwable exception, @Nonnull String message) {
        AELog.log(Level.ERROR, exception, message, new Object[0]);
    }

    public static void debug(@Nonnull String format, Object ... data) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, format, data);
        }
    }

    public static void debug(@Nonnull Throwable exception) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, exception, DEFAULT_EXCEPTION_MESSAGE, new Object[0]);
        }
    }

    public static void debug(@Nonnull Throwable exception, @Nonnull String message) {
        if (AELog.isDebugLogEnabled()) {
            AELog.log(Level.DEBUG, exception, message, new Object[0]);
        }
    }

    public static boolean isDebugLogEnabled() {
        return AEConfig.instance.isFeatureEnabled(AEFeature.DebugLogging);
    }

    public static void grinder(@Nonnull String message) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.GrinderLogging)) {
            AELog.log(Level.DEBUG, "grinder: " + message, new Object[0]);
        }
    }

    public static void integration(@Nonnull Throwable exception) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.IntegrationLogging)) {
            AELog.debug(exception);
        }
    }

    public static void blockUpdate(int xCoord, int yCoord, int zCoord, @Nonnull AEBaseTile aeBaseTile) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.UpdateLogging)) {
            AELog.info(BLOCK_UPDATE, aeBaseTile.getClass().getName(), xCoord, yCoord, zCoord);
        }
    }

    public static boolean isCraftingLogEnabled() {
        return AEConfig.instance.isFeatureEnabled(AEFeature.CraftingLog);
    }

    public static void crafting(@Nonnull String message, Object ... params) {
        if (AELog.isCraftingLogEnabled()) {
            AELog.log(Level.INFO, message, params);
        }
    }

    public static boolean isCraftingDebugLogEnabled() {
        return AEConfig.instance.isFeatureEnabled(AEFeature.CraftingLog) && AEConfig.instance.isFeatureEnabled(AEFeature.DebugLogging);
    }

    public static void craftingDebug(@Nonnull String message, Object ... params) {
        if (AELog.isCraftingDebugLogEnabled()) {
            AELog.log(Level.DEBUG, message, params);
        }
    }

    public static void printStackTrace(Level level) {
        AELog.log(level, "Stack trace:", new Object[0]);
        for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
            AELog.log(level, "\t " + traceElement.toString(), new Object[0]);
        }
    }
}

