/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.highlighter;

import appeng.api.util.DimensionalCoord;
import appeng.api.util.ItemSearchDTO;
import appeng.api.util.WorldCoord;
import appeng.client.render.highlighter.BlockPosHighlighter;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class StoragePosHighlighter
extends BlockPosHighlighter {
    static final StoragePosHighlighter INSTANCE = new StoragePosHighlighter();
    private final List<ItemSearchDTO> highlightedCells = new ArrayList<ItemSearchDTO>();

    StoragePosHighlighter() {
    }

    public static void highlightStorage(EntityPlayer player, List<ItemSearchDTO> interfaces, String foundMsg, String wrongDimMsg) {
        INSTANCE.clear();
        Objects.requireNonNull(INSTANCE);
        int highlightDuration = 3000;
        for (ItemSearchDTO storage : interfaces) {
            if (storage.cellSlot >= 0) {
                StoragePosHighlighter.INSTANCE.highlightedCells.add(storage);
            }
            StoragePosHighlighter.INSTANCE.highlightedBlocks.add(storage.coord);
            int n = 500 * WorldCoord.getTaxicabDistance((WorldCoord)storage.coord, player);
            Objects.requireNonNull(INSTANCE);
            Objects.requireNonNull(INSTANCE);
            highlightDuration = Math.max(highlightDuration, MathHelper.func_76125_a((int)n, (int)3000, (int)30000));
            if (player.field_70170_p.field_73011_w.field_76574_g == storage.coord.getDimension()) {
                if (foundMsg == null) continue;
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(foundMsg, new Object[]{storage.blockName, storage.itemCount, storage.itemName, storage.coord.x, storage.coord.y, storage.coord.z}));
                continue;
            }
            if (wrongDimMsg == null) continue;
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(wrongDimMsg, new Object[]{storage.blockName, storage.itemCount, storage.itemName, storage.coord.getDimension()}));
        }
        StoragePosHighlighter.INSTANCE.expireHighlightTime = System.currentTimeMillis() + (long)highlightDuration;
    }

    @Override
    public void clear() {
        super.clear();
        this.highlightedCells.clear();
    }

    @Override
    public void renderHighlightedBlocks(RenderWorldLastEvent event) {
        super.renderHighlightedBlocks(event);
        for (ItemSearchDTO storage : this.highlightedCells) {
            DimensionalCoord c = storage.coord;
            if (this.dimension != c.getDimension()) continue;
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glLineWidth((float)3.0f);
            GL11.glTranslated((double)(-this.doubleX), (double)(-this.doubleY), (double)(-this.doubleZ));
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            this.renderHighlightedCellSlotOverlay(c.x, c.y, c.z, storage.cellSlot, storage.forward, storage.up);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    private void renderHighlightedCellSlotOverlay(double x, double y, double z, int index, ForgeDirection forward, ForgeDirection up) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78369_a(1.0f, 1.0f, 0.0f, 0.4f);
        int spin = 0;
        block0 : switch (forward.offsetX + forward.offsetY * 2 + forward.offsetZ * 3) {
            case 1: {
                switch (up) {
                    case UP: {
                        spin = 3;
                        break block0;
                    }
                    case DOWN: {
                        spin = 1;
                        break block0;
                    }
                    case NORTH: {
                        spin = 0;
                        break block0;
                    }
                    case SOUTH: {
                        spin = 2;
                        break block0;
                    }
                }
                break;
            }
            case -1: {
                switch (up) {
                    case UP: {
                        spin = 1;
                        break block0;
                    }
                    case DOWN: {
                        spin = 3;
                        break block0;
                    }
                    case NORTH: {
                        spin = 0;
                        break block0;
                    }
                    case SOUTH: {
                        spin = 2;
                        break block0;
                    }
                }
                break;
            }
            case -2: {
                switch (up) {
                    case EAST: {
                        spin = 1;
                        break block0;
                    }
                    case WEST: {
                        spin = 3;
                        break block0;
                    }
                    case NORTH: {
                        spin = 2;
                        break block0;
                    }
                    case SOUTH: {
                        spin = 0;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (up) {
                    case EAST: {
                        spin = 1;
                        break block0;
                    }
                    case WEST: {
                        spin = 3;
                        break block0;
                    }
                    case NORTH: {
                        spin = 0;
                        break block0;
                    }
                    case SOUTH: {
                        spin = 0;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (up) {
                    case UP: {
                        spin = 2;
                        break block0;
                    }
                    case DOWN: {
                        spin = 0;
                        break block0;
                    }
                    case EAST: {
                        spin = 3;
                        break block0;
                    }
                    case WEST: {
                        spin = 1;
                        break block0;
                    }
                }
                break;
            }
            case -3: {
                switch (up) {
                    case UP: {
                        spin = 2;
                        break block0;
                    }
                    case DOWN: {
                        spin = 0;
                        break block0;
                    }
                    case EAST: {
                        spin = 1;
                        break block0;
                    }
                    case WEST: {
                        spin = 3;
                        break block0;
                    }
                }
            }
        }
        int origCol = 1 - index % 2;
        int origRow = index / 2;
        ForgeDirection west = Platform.crossProduct(forward, up);
        RenderBlocks renderer = new RenderBlocks();
        this.selectFace(renderer, west, up, forward, 2 + origCol * 7, 7 + origCol * 7, 1 + origRow * 3, 3 + origRow * 3);
        double u1 = this.getInterpolatedU(spin % 4 < 2 ? 1 : 6);
        double u2 = this.getInterpolatedU((spin + 1) % 4 < 2 ? 1 : 6);
        double u3 = this.getInterpolatedU((spin + 2) % 4 < 2 ? 1 : 6);
        double u4 = this.getInterpolatedU((spin + 3) % 4 < 2 ? 1 : 6);
        double v1 = this.getInterpolatedU((spin + 1) % 4 < 2 ? 1 : 3);
        double v2 = this.getInterpolatedU((spin + 2) % 4 < 2 ? 1 : 3);
        double v3 = this.getInterpolatedU((spin + 3) % 4 < 2 ? 1 : 3);
        double v4 = this.getInterpolatedU(spin % 4 < 2 ? 1 : 3);
        switch (forward.offsetX + forward.offsetY * 2 + forward.offsetZ * 3) {
            case 1: {
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147851_l, u1, v1);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147851_l, u4, v4);
                break;
            }
            case -1: {
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147851_l, u1, v1);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147851_l, u4, v4);
                break;
            }
            case -2: {
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147851_l, u1, v1);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147851_l, u4, v4);
                break;
            }
            case 2: {
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147851_l, u1, v1);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147851_l, u4, v4);
                break;
            }
            case 3: {
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147853_m, u1, v1);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147855_j, z + renderer.field_147853_m, u4, v4);
                break;
            }
            case -3: {
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147855_j, z + renderer.field_147853_m, u1, v1);
                tess.func_78374_a(x + renderer.field_147859_h, y + renderer.field_147857_k, z + renderer.field_147853_m, u2, v2);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147857_k, z + renderer.field_147853_m, u3, v3);
                tess.func_78374_a(x + renderer.field_147861_i, y + renderer.field_147855_j, z + renderer.field_147853_m, u4, v4);
            }
        }
        tess.func_78381_a();
    }

    private void selectFace(RenderBlocks renderer, ForgeDirection west, ForgeDirection up, ForgeDirection forward, int u1, int u2, int v1, int v2) {
        v1 = 16 - v1;
        v2 = 16 - v2;
        double minX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u1) + this.mapFaceUV(up.offsetX, v1);
        double minY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u1) + this.mapFaceUV(up.offsetY, v1);
        double minZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u1) + this.mapFaceUV(up.offsetZ, v1);
        double maxX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u2) + this.mapFaceUV(up.offsetX, v2);
        double maxY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u2) + this.mapFaceUV(up.offsetY, v2);
        double maxZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u2) + this.mapFaceUV(up.offsetZ, v2);
        renderer.field_147859_h = Math.max(0.0, Math.min(minX, maxX) - (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.field_147861_i = Math.min(1.0, Math.max(minX, maxX) + (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.field_147855_j = Math.max(0.0, Math.min(minY, maxY) - (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.field_147857_k = Math.min(1.0, Math.max(minY, maxY) + (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.field_147851_l = Math.max(0.0, Math.min(minZ, maxZ) - (forward.offsetZ != 0 ? 0.0 : 0.001));
        renderer.field_147853_m = Math.min(1.0, Math.max(minZ, maxZ) + (forward.offsetZ != 0 ? 0.0 : 0.001));
    }

    private double mapFaceUV(int offset, int uv) {
        if (offset == 0) {
            return 0.0;
        }
        if (offset > 0) {
            return (double)uv / 16.0;
        }
        return (16.0 - (double)uv) / 16.0;
    }

    private float getInterpolatedU(int texCoord) {
        return (float)texCoord / 16.0f;
    }
}

