/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.item.ItemBackpackBase;
import de.eydamos.backpack.item.ItemsBackpack;
import de.eydamos.backpack.misc.ConfigurationBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import de.eydamos.backpack.util.BackpackUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerBackpack {
    @SubscribeEvent
    public void serverTick(TickEvent.PlayerTickEvent event) {
        if (ConfigurationBackpack.MAX_BACKPACK_AMOUNT > 0 && event.side == Side.SERVER) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int counter = 0;
            if (new PlayerSave((EntityPlayer)player).hasPersonalBackpack()) {
                ++counter;
            }
            ItemStack[] inventory = player.field_71071_by.field_70462_a;
            for (int i = 0; i < inventory.length; ++i) {
                if (inventory[i] == null || !(inventory[i].func_77973_b() instanceof ItemBackpackBase) || ++counter <= ConfigurationBackpack.MAX_BACKPACK_AMOUNT) continue;
                player.func_70099_a(inventory[i].func_77946_l(), 0.0f);
                inventory[i] = null;
            }
            if ((counter -= ConfigurationBackpack.MAX_BACKPACK_AMOUNT) > 0) {
                ChatComponentText message = new ChatComponentText("[Backpacks] ");
                message.func_150257_a((IChatComponent)new ChatComponentTranslation("text.backpack.allowed_backpacks", new Object[]{ConfigurationBackpack.MAX_BACKPACK_AMOUNT}));
                player.func_145747_a((IChatComponent)message);
                message = new ChatComponentText("[Backpacks] ").func_150257_a((IChatComponent)new ChatComponentTranslation("text.backpack.dropped_backpacks", new Object[]{counter}));
                player.func_145747_a((IChatComponent)message);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("Backpack")) {
            ConfigurationBackpack.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void playerPickup(EntityItemPickupEvent event) {
        BackpackUtil.pickupItem(event.entityPlayer, event.item.func_92059_d());
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        Backpack.saveFileHandler.init();
    }

    @SubscribeEvent
    public void playerDies(PlayerDropsEvent event) {
        EntityPlayer entityPlayer = event.entityPlayer;
        PlayerSave playerSave = new PlayerSave(entityPlayer);
        ItemStack backpack = playerSave.getPersonalBackpack();
        if (backpack != null) {
            event.drops.add(new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, backpack));
            playerSave.setPersonalBackpack(null);
        }
    }

    @SubscribeEvent
    public void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack craftedItem = event.crafting;
        if (craftedItem != null && craftedItem.func_77973_b() == ItemsBackpack.workbenchBackpack && NBTItemStackUtil.hasTag(craftedItem, "intelligent")) {
            BackpackSave backpackSave = new BackpackSave(craftedItem);
            backpackSave.setIntelligent();
            NBTItemStackUtil.removeTag(craftedItem, "intelligent");
        }
    }
}

