/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.items.LabParts;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.common.net.RendererPacket;
import com.github.bartimaeusnek.bartworks.common.tileentities.tiered.GT_MetaTileEntity_RadioHatch;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_BioVat
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_BioVat> {
    public static final HashMap<Coords, Integer> staticColorMap = new HashMap();
    private static final byte TIMERDIVIDER = 20;
    private final HashSet<EntityPlayerMP> playerMPHashSet = new HashSet();
    private final ArrayList<GT_MetaTileEntity_RadioHatch> mRadHatches = new ArrayList();
    private int height = 1;
    private GT_Recipe mLastRecipe;
    private Fluid mFluid = FluidRegistry.LAVA;
    private BioCulture mCulture;
    private ItemStack mStack;
    private boolean needsVisualUpdate = true;
    private byte mGlassTier;
    private int mSievert;
    private int mNeededSievert;
    private int mCasing = 0;
    private int mExpectedMultiplier = 0;
    private int mTimes = 0;
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_BioVat> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"cc~cc", "ccccc", "ccccc", "ccccc", "ccccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_TileEntity_BioVat::addRadiationInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)49, (int)1), StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement('a', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)FluidLoader.bioFluidBlock)})).addElement('g', BW_Util.ofGlassTiered((byte)1, (byte)127, (byte)0, (te, v) -> {
        te.mGlassTier = v;
    }, te -> te.mGlassTier, 1)).build();

    public GT_TileEntity_BioVat(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_BioVat(String aName) {
        super(aName);
    }

    public IStructureDefinition<GT_TileEntity_BioVat> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Bacterial Vat").addInfo("Controller block for the Bacterial Vat").addInfo("For maximum efficiency boost keep the Output Hatch always half filled!").addSeparator().beginStructureBlock(5, 4, 5, false).addController("Front bottom center").addCasingInfo("Clean Stainless Steel Casings", 19).addOtherStructurePart("Glass", "Hollow two middle layers", new int[]{2}).addStructureInfo("The glass can be any glass, i.e. Tinkers Construct Clear Glass").addStructureInfo("Some Recipes need more advanced Glass Types").addMaintenanceHatch("Any casing", new int[]{1}).addOtherStructurePart("Radio Hatch", "Any casing", new int[]{1}).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addInputHatch("Any casing", new int[]{1}).addOutputHatch("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public static int[] specialValueUnpack(int aSpecialValue) {
        int[] ret = new int[]{aSpecialValue & 0xF, aSpecialValue >>> 4 & 3, aSpecialValue >>> 6 & 1, aSpecialValue >>> 7 & Integer.MAX_VALUE};
        return ret;
    }

    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    public boolean isLiquidOutput(byte aSide) {
        return false;
    }

    private int getInputCapacity() {
        return this.mInputHatches.stream().mapToInt(GT_MetaTileEntity_Hatch_Input::getCapacity).sum();
    }

    private int getOutputCapacity() {
        return this.mOutputHatches.stream().mapToInt(GT_MetaTileEntity_Hatch_Output::getCapacity).sum();
    }

    public int getCapacity() {
        int ret = 0;
        return ret += this.getInputCapacity();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return super.fill(resource, doFill);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return BWRecipes.instance.getMappingsFor((byte)1);
    }

    private int getExpectedMultiplier(@Nullable FluidStack recipeFluidOutput, boolean needEqual) {
        FluidStack storedFluidOutputs = this.getStoredFluidOutputs();
        if (storedFluidOutputs == null) {
            return 1;
        }
        if (!needEqual || storedFluidOutputs.isFluidEqual(recipeFluidOutput)) {
            return this.calcMod(storedFluidOutputs.amount) + 1;
        }
        return 1;
    }

    private int calcMod(double x) {
        double y = (double)this.getOutputCapacity() / 2.0;
        double z = ConfigHandler.bioVatMaxParallelBonus;
        int ret = MathUtils.ceilInt((-1.0 / y * Math.pow(x - y, 2.0) + y) / y * z);
        return MathUtils.clamp(1, ret, ConfigHandler.bioVatMaxParallelBonus);
    }

    private List<ItemStack> getItemInputs() {
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        return tInputList;
    }

    private List<FluidStack> getFluidInputs() {
        ArrayList tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                if (((FluidStack)tFluidList.get((int)i)).amount >= ((FluidStack)tFluidList.get((int)j)).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        return tFluidList;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        GT_Recipe.GT_Recipe_Map gtRecipeMap = this.getRecipeMap();
        if (gtRecipeMap == null) {
            return false;
        }
        ItemStack[] tInputs = this.getItemInputs().toArray(new ItemStack[0]);
        FluidStack[] tFluids = this.getFluidInputs().toArray(new FluidStack[0]);
        if (tFluids.length <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = GT_Values.V[tTier];
        GT_Recipe gtRecipe = gtRecipeMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, tEnergy, tFluids, itemStack, tInputs);
        if (gtRecipe == null) {
            return false;
        }
        assert (gtRecipe.mFluidInputs.length == 1);
        assert (gtRecipe.mFluidOutputs.length == 1);
        if (!BW_Util.areStacksEqualOrNull((ItemStack)gtRecipe.mSpecialItems, itemStack)) {
            return false;
        }
        int[] conditions = GT_TileEntity_BioVat.specialValueUnpack(gtRecipe.mSpecialValue);
        this.mNeededSievert = conditions[3];
        if (conditions[2] == 0 ? this.mSievert < this.mNeededSievert || this.mGlassTier < conditions[0] : this.mSievert != conditions[3] || this.mGlassTier < conditions[0]) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (!gtRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
            return false;
        }
        FluidStack recipeFluidOutput = gtRecipe.getFluidOutput(0);
        FluidStack recipeFluidInput = gtRecipe.mFluidInputs[0];
        this.mExpectedMultiplier = this.getExpectedMultiplier(recipeFluidOutput, true);
        this.mTimes = 1;
        for (int i = 1; i < this.mExpectedMultiplier; ++i) {
            if (!this.depleteInput(recipeFluidInput)) continue;
            ++this.mTimes;
        }
        this.mOutputFluids = new FluidStack[]{new FluidStack(recipeFluidOutput, recipeFluidOutput.amount * this.mTimes)};
        BW_Util.calculateOverclockedNessMulti(gtRecipe.mEUt, gtRecipe.mDuration, 1, tEnergy, (GT_MetaTileEntity_MultiBlockBase)this);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mProgresstime = 0;
        if (gtRecipe.mCanBeBuffered) {
            this.mLastRecipe = gtRecipe;
        }
        this.updateSlots();
        return true;
    }

    public FluidStack getStoredFluidOutputs() {
        assert (this.mOutputHatches.size() == 1);
        return ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(0)).getFluid();
    }

    private boolean addRadiationInputToMachineList(IGregTechTileEntity aTileEntity, int CasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_RadioHatch) {
            ((GT_MetaTileEntity_RadioHatch)aMetaTileEntity).updateTexture(CasingIndex);
            return this.mRadHatches.add((GT_MetaTileEntity_RadioHatch)aMetaTileEntity);
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mRadHatches.clear();
        this.mGlassTier = 0;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        return this.mCasing >= 19 && this.mRadHatches.size() <= 1 && this.mOutputHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() > 0 && this.mEnergyHatches.size() > 0;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    private void sendAllRequiredRendererPackets() {
        int height = this.reCalculateHeight();
        if (this.mFluid != null && height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        this.sendPackagesOrRenewRenderer(x, y, z, this.mCulture);
                    }
                }
            }
        }
    }

    private void sendPackagesOrRenewRenderer(int x, int y, int z, BioCulture lCulture) {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g));
        staticColorMap.put(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB());
        if (SideReference.Side.Server) {
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), false), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        }
        this.needsVisualUpdate = true;
    }

    private void check_Chunk() {
        World aWorld = this.getBaseMetaTileEntity().getWorld();
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                if (tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) {
                    if (this.playerMPHashSet.contains(tPlayer)) continue;
                    this.playerMPHashSet.add(tPlayer);
                    this.sendAllRequiredRendererPackets();
                    continue;
                }
                this.playerMPHashSet.remove(tPlayer);
            }
        }
    }

    private void placeFluid() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        this.height = this.reCalculateHeight();
        if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        if (!this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(Blocks.field_150350_a)) continue;
                        this.getBaseMetaTileEntity().getWorld().func_147449_b(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), FluidLoader.bioFluidBlock);
                    }
                }
            }
        }
    }

    private int reCalculateFluidAmmount() {
        return this.getStoredFluids().stream().mapToInt(fluidStack -> fluidStack.amount).sum();
    }

    private int reCalculateHeight() {
        return this.reCalculateFluidAmmount() > this.getCapacity() / 4 - 1 ? (this.reCalculateFluidAmmount() >= this.getCapacity() / 2 ? 3 : 2) : 1;
    }

    public void doAllVisualThings() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMachine) {
                int z;
                int y;
                int x;
                ItemStack aStack = this.mInventory[1];
                BioCulture lCulture = null;
                int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
                int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
                if (this.getBaseMetaTileEntity().getTimer() % 200L == 0L) {
                    this.check_Chunk();
                }
                if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 0L) {
                    for (x = -1; x < 2; ++x) {
                        for (y = 1; y < 3; ++y) {
                            for (z = -1; z < 2; ++z) {
                                this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                            }
                        }
                    }
                }
                this.height = this.reCalculateHeight();
                if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
                    if (!BW_Util.areStacksEqualOrNull(aStack, this.mStack) || this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        for (x = -1; x < 2; ++x) {
                            for (y = 1; y < this.height; ++y) {
                                for (z = -1; z < 2; ++z) {
                                    if (aStack != null && (!(aStack.func_77973_b() instanceof LabParts) || aStack.func_77960_j() != 0) || this.mCulture != null && aStack != null && aStack.func_77978_p() != null && this.mCulture.getID() == aStack.func_77978_p().func_74762_e("ID")) continue;
                                    lCulture = aStack == null || aStack.func_77978_p() == null ? null : BioCulture.getBioCulture(aStack.func_77978_p().func_74779_i("Name"));
                                    this.sendPackagesOrRenewRenderer(x, y, z, lCulture);
                                }
                            }
                        }
                        this.mStack = aStack;
                        this.mCulture = lCulture;
                    }
                    if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        if (this.getBaseMetaTileEntity().isClientSide()) {
                            new Throwable().printStackTrace();
                        }
                        this.placeFluid();
                        this.needsVisualUpdate = false;
                    }
                }
            } else {
                this.onRemoval();
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.height != this.reCalculateHeight()) {
            this.needsVisualUpdate = true;
        }
        this.doAllVisualThings();
        if (this.getBaseMetaTileEntity().isServerSide() && this.mRadHatches.size() == 1) {
            this.mSievert = this.mRadHatches.get(0).getSievert();
            if (this.getBaseMetaTileEntity().isActive() && this.mNeededSievert > this.mSievert) {
                this.mOutputFluids = null;
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && this.mMaxProgresstime <= 0) {
            this.mTimes = 0;
            this.mMaxProgresstime = 0;
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFluidHeight", this.height);
        if (this.mCulture != null && !this.mCulture.getName().isEmpty()) {
            aNBT.func_74778_a("mCulture", this.mCulture.getName());
        } else if ((this.mCulture == null || this.mCulture.getName().isEmpty()) && !aNBT.func_74779_i("mCulture").isEmpty()) {
            aNBT.func_82580_o("mCulture");
        }
        if (this.mFluid != null) {
            aNBT.func_74778_a("mFluid", this.mFluid.getName());
        }
        aNBT.func_74768_a("mSievert", this.mSievert);
        aNBT.func_74768_a("mNeededSievert", this.mNeededSievert);
        super.saveNBTData(aNBT);
    }

    public void onRemoval() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ * 2;
        for (int x = -1; x < 2; ++x) {
            for (int y = 1; y < 3; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(FluidLoader.bioFluidBlock)) {
                        this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                    }
                    staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
                    if (!SideReference.Side.Server) continue;
                    MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), this.mCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : this.mCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                }
            }
        }
        super.onRemoval();
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.height = aNBT.func_74762_e("mFluidHeight");
        this.mCulture = BioCulture.getBioCulture(aNBT.func_74779_i("mCulture"));
        if (!aNBT.func_74779_i("mFluid").isEmpty()) {
            this.mFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mFluid"));
        }
        this.mSievert = aNBT.func_74762_e("mSievert");
        this.mNeededSievert = aNBT.func_74762_e("mNeededSievert");
        super.loadNBTData(aNBT);
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_BioVat(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 3, 0);
    }

    public String[] getInfoData() {
        String[] baseInfoData = super.getInfoData();
        String[] infoData = new String[baseInfoData.length + 2];
        System.arraycopy(baseInfoData, 0, infoData, 0, baseInfoData.length);
        infoData[infoData.length - 2] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.expectedProduction") + ": " + EnumChatFormatting.GREEN + (this.mMachine ? (this.mMaxProgresstime <= 0 ? this.getExpectedMultiplier(null, false) : this.mExpectedMultiplier) * 100 : -1) + EnumChatFormatting.RESET + " %";
        infoData[infoData.length - 1] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.production") + ": " + EnumChatFormatting.GREEN + (this.mMaxProgresstime <= 0 ? 0 : this.mTimes) * 100 + EnumChatFormatting.RESET + " %";
        return infoData;
    }
}

