/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MoltenCellLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            return;
        }
        if (!werkstoff.hasItemType(OrePrefixes.ingot)) {
            if (!werkstoff.hasItemType(OrePrefixes.dust)) {
                return;
            }
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dust), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().getMass(), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dustSmall), null, werkstoff.getMolten(36), 0, (int)((double)werkstoff.getStats().getMass() / 4.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.dustTiny), null, werkstoff.getMolten(16), 0, (int)((double)werkstoff.getStats().getMass() / 9.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
        } else {
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.ingot), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().getMass(), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.nugget), null, werkstoff.getMolten(16), 0, (int)((double)werkstoff.getStats().getMass() / 9.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ingot.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.ingot), (int)werkstoff.getStats().getMass(), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Nugget.get(0L, new Object[0]), werkstoff.getMolten(16), werkstoff.get(OrePrefixes.nugget), (int)((double)werkstoff.getStats().getMass() / 9.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Block.get(0L, new Object[0]), werkstoff.getMolten(1296), werkstoff.get(OrePrefixes.block), (int)werkstoff.getStats().getMass() * 9, werkstoff.getStats().getMass() > 128L ? 64 : 30);
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.stickLong), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().getMass(), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.plate), null, werkstoff.getMolten(144), 0, (int)werkstoff.getStats().getMass(), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidExtractionRecipe(werkstoff.get(OrePrefixes.stick), null, werkstoff.getMolten(72), 0, (int)((double)werkstoff.getStats().getMass() / 2.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
        }
        if (werkstoff.getGenerationFeatures().hasMetalCraftingSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.stickLong), (int)Math.max(werkstoff.getStats().getMass(), 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rod.get(0L, new Object[0]), werkstoff.getMolten(72), werkstoff.get(OrePrefixes.stick), (int)Math.max(werkstoff.getStats().getMass() / 2L, 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Plate.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.plate), (int)Math.max(werkstoff.getStats().getMass(), 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
        }
        if (werkstoff.getGenerationFeatures().hasMetaSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.screw)) {
                return;
            }
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Screw.get(0L, new Object[0]), werkstoff.getMolten(18), werkstoff.get(OrePrefixes.screw), (int)Math.max(werkstoff.getStats().getMass() / 8L, 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Gear.get(0L, new Object[0]), werkstoff.getMolten(576), werkstoff.get(OrePrefixes.gearGt), (int)Math.max(werkstoff.getStats().getMass() / 4L, 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Gear_Small.get(0L, new Object[0]), werkstoff.getMolten(144), werkstoff.get(OrePrefixes.gearGtSmall), (int)Math.max(werkstoff.getStats().getMass(), 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Bolt.get(0L, new Object[0]), werkstoff.getMolten(18), werkstoff.get(OrePrefixes.bolt), (int)Math.max(werkstoff.getStats().getMass() / 8L, 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ring.get(0L, new Object[0]), werkstoff.getMolten(36), werkstoff.get(OrePrefixes.ring), (int)Math.max(werkstoff.getStats().getMass() / 4L, 1L), werkstoff.getStats().getMass() > 128L ? 64 : 30);
            if (WerkstoffLoader.rotorMold == null) {
                return;
            }
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Rotor.get(0L, new Object[0]), werkstoff.getMolten(612), werkstoff.get(OrePrefixes.rotor), (int)Math.max((double)werkstoff.getStats().getMass() * 4.25, 1.0), werkstoff.getStats().getMass() > 128L ? 64 : 30);
        }
        if (werkstoff.getGenerationFeatures().hasMultipleMetalSolidifierRecipes() && !werkstoff.hasItemType(OrePrefixes.plateDouble)) {
            return;
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.cellMolten), (ItemStack)Materials.Empty.getCells(1));
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)data);
        GT_Values.RA.addFluidCannerRecipe(Materials.Empty.getCells(1), werkstoff.get(OrePrefixes.cellMolten), new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144), GT_Values.NF);
        GT_Values.RA.addFluidCannerRecipe(werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1), GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144));
        if (!LoaderReference.Forestry) {
            return;
        }
        FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.capsuleMolten), GT_ModHandler.getModItem((String)"Forestry", (String)"refractoryEmpty", (long)1L));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.capsuleMolten), (ItemStack)GT_ModHandler.getModItem((String)"Forestry", (String)"refractoryEmpty", (long)1L));
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
        GT_Values.RA.addFluidCannerRecipe(werkstoff.get(OrePrefixes.capsuleMolten), GT_Values.NI, GT_Values.NF, new FluidStack((Fluid)Objects.requireNonNull(WerkstoffLoader.molten.get((Object)werkstoff)), 144));
    }
}

