/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.util.MurmurHash3;
import net.minecraftforge.common.util.ForgeDirection;

public class Coords {
    public int x;
    public int z;
    public int wID;
    public short y;

    public Coords(int x, int y, int z, int wID) {
        this(x, y, z);
        this.wID = wID;
    }

    public Coords(int x, int y, int z) {
        this.x = x;
        this.y = (short)y;
        this.z = z;
        this.wID = 0;
    }

    public Coords getCoordsFromSide(ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return new Coords(this.x, this.y + 1, this.z, this.wID);
            }
            case DOWN: {
                return new Coords(this.x, this.y - 1, this.z, this.wID);
            }
            case WEST: {
                return new Coords(this.x - 1, this.y, this.z, this.wID);
            }
            case EAST: {
                return new Coords(this.x + 1, this.y, this.z, this.wID);
            }
            case NORTH: {
                return new Coords(this.x, this.y, this.z - 1, this.wID);
            }
            case SOUTH: {
                return new Coords(this.x, this.y, this.z + 1, this.wID);
            }
        }
        throw new UnsupportedOperationException("This is impossible.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coords coords = (Coords)o;
        return this.x == coords.x && this.y == coords.y && this.z == coords.z && this.wID == coords.wID;
    }

    public int hashCode() {
        byte[] data = new byte[]{(byte)(this.x & 0xFF), (byte)(this.x >> 4 & 0xFF), (byte)(this.x >> 8 & 0xFF), (byte)(this.x >> 12 & 0xFF), (byte)(this.y & 0xFF), (byte)(this.y >> 4 & 0xFF), (byte)(this.z & 0xFF), (byte)(this.z >> 4 & 0xFF), (byte)(this.z >> 8 & 0xFF), (byte)(this.z >> 12 & 0xFF), (byte)(this.wID & 0xFF), (byte)(this.wID >> 4 & 0xFF), (byte)(this.wID >> 8 & 0xFF), (byte)(this.wID >> 12 & 0xFF)};
        return MurmurHash3.murmurhash3_x86_32(data, 0, 14, 31);
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z + "," + this.wID;
    }
}

