/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.objects.GT_Fluid;
import gregtech.api.util.GT_Utility;
import java.awt.Color;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class BioObjectAdder {
    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, EnumRarity rarity, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, rarity, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioCulture createAndRegisterBioCulture(Color color, String name, BioPlasmid plasmid, BioDNA dna, boolean breedable) {
        if (BioCulture.BIO_CULTURE_ARRAY_LIST.size() > 1) {
            return BioCulture.createAndRegisterBioCulture(color, name, plasmid, dna, breedable);
        }
        new Exception("Too Early to register a BioCulture! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioData createAndRegisterBioData(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioData.createAndRegisterBioData(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioDNA createAndRegisterBioDNA(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioDNA.createAndRegisterBioDNA(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static BioPlasmid createAndRegisterBioPlasmid(String aName, EnumRarity rarity, int chance, int tier) {
        if (BioData.BIO_DATA_ARRAY_LIST.size() > 1) {
            return BioPlasmid.createAndRegisterBioPlasmid(aName, rarity, chance, tier);
        }
        new Exception("Too Early to register a BioData! You MUST run this either after:bartworks OR in the init Phase!").printStackTrace();
        return null;
    }

    public static int getBacteriaTierFromVoltageTier(int voltageTier) {
        return Math.max(voltageTier - 6, 0);
    }

    public static void regenerateBioFluids() {
        FluidStack dnaFluid = LoaderReference.gendustry ? FluidRegistry.getFluidStack((String)"liquiddna", (int)100) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.getFluidNotSet()) continue;
            B.setFluid((Fluid)new GT_Fluid(B.getName().replaceAll(" ", "").toLowerCase() + "fluid", "molten.autogenerated", new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}));
            if (!FluidRegistry.registerFluid((Fluid)B.getFluid())) {
                new Exception("FAILED TO REGISTER FLUID FOR: " + B.getName()).printStackTrace();
            }
            GT_Values.RA.addCentrifugeRecipe(GT_Utility.getIntegratedCircuit((int)10), GT_Values.NI, new FluidStack(B.getFluid(), 1000), dnaFluid, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, GT_Values.NI, null, 500, 120);
        }
    }
}

