/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DistillationTower;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_CrackingDistillTower
extends GT_MetaTileEntity_DistillationTower {
    public GT_TileEntity_CrackingDistillTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_CrackingDistillTower(String aName) {
        super(aName);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (!GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)GT_Utility.getIntegratedCircuit((int)0), (boolean)true)) {
            return false;
        }
        FluidStack[] array = new FluidStack[]{};
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input hatch : this.mInputHatches) {
            if (hatch == null) continue;
            fluidInputs.add(hatch.getFluid());
        }
        array = fluidInputs.toArray(array);
        GT_Recipe.GT_Recipe_Map rMapCracking = GT_Recipe.GT_Recipe_Map.sCrakingRecipes;
        GT_Recipe.GT_Recipe_Map rMapDistillTower = GT_Recipe.GT_Recipe_Map.sDistillationRecipes;
        GT_Recipe recipeCracking = rMapCracking.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, this.getMaxInputVoltage(), array, new ItemStack[]{itemStack});
        if (recipeCracking == null) {
            return false;
        }
        GT_Recipe recipeDistill = rMapDistillTower.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, this.getMaxInputVoltage(), recipeCracking.mFluidOutputs, new ItemStack[0]);
        if (recipeDistill == null) {
            return false;
        }
        float ratio = (float)recipeCracking.mFluidOutputs[0].amount / (float)recipeDistill.mFluidInputs[0].amount;
        FluidStack[] nuoutputs = new FluidStack[recipeDistill.mFluidOutputs.length];
        for (int i = 0; i < nuoutputs.length; ++i) {
            nuoutputs[i] = recipeDistill.mFluidOutputs[i];
            nuoutputs[i].amount = MathUtils.floorInt((float)recipeDistill.mFluidOutputs[i].amount * ratio);
        }
        BWRecipes.DynamicGTRecipe combined = new BWRecipes.DynamicGTRecipe(true, null, recipeDistill.mOutputs, null, recipeDistill.mChances, recipeCracking.mFluidInputs, nuoutputs, MathUtils.floorInt((float)recipeDistill.mDuration * ratio) + recipeCracking.mDuration, Math.max(MathUtils.floorInt((float)recipeDistill.mEUt * ratio), recipeCracking.mEUt), 0);
        if (combined.isRecipeInputEqual(true, array, new ItemStack[0])) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            BW_Util.calculateOverclockedNessMulti(combined.mEUt, combined.mDuration, 1, this.getMaxInputVoltage(), (GT_MetaTileEntity_MultiBlockBase)this);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputFluids = (FluidStack[])combined.mFluidOutputs.clone();
            this.mOutputItems = (ItemStack[])combined.mOutputs.clone();
            this.updateSlots();
            return true;
        }
        return false;
    }
}

