/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GT_TileEntity_ManualTrafo
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_ManualTrafo> {
    private byte mode;
    private int mTiers;
    private boolean upstep = true;
    private static final int CASING_INDEX = 2;
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "layer";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_TAP_LAYER = "taplayer";
    private static final IStructureDefinition<GT_TileEntity_ManualTrafo> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape("layer", StructureUtility.transpose((String[][])new String[][]{{"ttt", "tft", "ttt"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ooo", "ooo", "ooo"}})).addShape("taplayer", StructureUtility.transpose((String[][])new String[][]{{" TTT ", "TtttT", "TtftT", "TtttT", " TTT "}})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)2, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)2, (int)1), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)2)})).addElement('o', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiBlockBase::addDynamoToMachineList, (int)2, (int)2, (Block)GregTech_API.sBlockCasings1, (int)2)).addElement('t', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('f', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('T', (IStructureElement)new IStructureElementNoPlacement<GT_TileEntity_ManualTrafo>(){

        public boolean check(GT_TileEntity_ManualTrafo te, World world, int x, int y, int z) {
            if (world.func_147437_c(x, y, z)) {
                return true;
            }
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                return true;
            }
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return true;
            }
            IMetaTileEntity mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (mte instanceof GT_MetaTileEntity_Hatch_Dynamo || mte instanceof GT_MetaTileEntity_Hatch_Energy) {
                byte intier = ((GT_MetaTileEntity_Hatch_Energy)te.mEnergyHatches.get((int)0)).mTier;
                if (((GT_MetaTileEntity_TieredMachineBlock)mte).mTier == intier + (te.upstep ? te.mTiers : -te.mTiers)) {
                    te.addToMachineList((IGregTechTileEntity)tileEntity, 2);
                    return true;
                }
                return false;
            }
            return true;
        }

        public boolean spawnHint(GT_TileEntity_ManualTrafo te, World world, int x, int y, int z, ItemStack itemStack) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)2);
            return true;
        }
    }).build();

    public GT_TileEntity_ManualTrafo(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ManualTrafo(String aName) {
        super(aName);
    }

    public IStructureDefinition<GT_TileEntity_ManualTrafo> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Transformer").addInfo("Controller block for the Manual Trafo").addInfo("Operates in 4 diffrent modes:").addInfo("Mode 1: Circuit 0 in controller: Direct-Upstep").addInfo("Mode 2: Circuit 1 in controller: Direct-Downstep").addInfo("Mode 3: Circuit 2 in controller: Tapped-Upstep (currently disabled)").addInfo("Mode 4: Circuit 2 in controller: Tapped-Downstep (currently disabled)").addSeparator().beginVariableStructureBlock(3, 3, 3, 10, 3, 3, false).addController("Front bottom center").addCasingInfo("MV Machine Casing", 0).addOtherStructurePart("Transformer-Winding Blocks", "1 Layer for each tier transformed").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Middle of Transformer-Winding Blocks").addMaintenanceHatch("Any bottom layer casing", new int[]{1}).addEnergyHatch("Any bottom layer casing", new int[]{1}).addDynamoHatch("Any top layer casing", new int[]{2}).addStructureInfo("---------TAPPED MODE---------").addEnergyHatch("Touching Transformer-Winding Blocks", new int[]{3}).addDynamoHatch("Touching Transformer-Winding Blocks", new int[]{3}).addStructureInfo("Hatches touching Transformer-Winding Blocks must be tiered from bottom to top").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
            return false;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        if (this.getBaseMetaTileEntity().getTimer() % 40L == 0L) {
            this.mEfficiency = this.mEfficiency < this.getMaxEfficiency(null) ? (this.mEfficiency += 100) : this.getMaxEfficiency(null);
        }
        if (this.mode > 1) {
            return false;
        }
        return this.drainEnergyInput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size()) && this.addEnergyOutput(this.getInputTier() * 2L * (long)this.mEnergyHatches.size() * (long)this.mEfficiency / (long)this.getMaxEfficiency(null));
    }

    public boolean onRunningTickTabbedMode() {
        boolean ret = false;
        for (GT_MetaTileEntity_Hatch_Dynamo E : this.mDynamoHatches) {
            for (GT_MetaTileEntity_Hatch_Energy I : this.mEnergyHatches) {
                long vtt;
                long l = vtt = I.getEUVar() >= GT_Values.V[E.mTier] / 2L && E.getEUVar() < E.maxEUStore() ? I.getEUVar() : 0L;
                if (vtt == 0L) continue;
                long vtp = E.getEUVar() + vtt;
                long avt = Math.min(vtp, E.maxEUStore());
                E.setEUVar(avt);
                I.setEUVar(I.getEUVar() - vtt);
                ret = true;
            }
        }
        return ret;
    }

    public long getInputTier() {
        if (this.mEnergyHatches.size() > 0) {
            return GT_Utility.getTier((long)((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage());
        }
        return 0L;
    }

    public long getOutputTier() {
        if (this.mDynamoHatches.size() > 0) {
            return GT_Utility.getTier((long)((GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get(0)).getBaseMetaTileEntity().getOutputVoltage());
        }
        return 0L;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (!this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.stopMachine();
            return false;
        }
        this.mode = itemStack == null || !itemStack.func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, itemStack.func_77960_j());
        this.upstep = this.mode % 2 == 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = Math.max(this.mEfficiency, 100);
        return this.upstep ? this.getOutputTier() - this.getInputTier() == (long)this.mTiers : this.getInputTier() - this.getOutputTier() == (long)this.mTiers;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int mHeight;
        boolean tapmode;
        this.mode = itemStack == null || !itemStack.func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, itemStack.func_77960_j());
        this.upstep = this.mode % 2 == 0;
        boolean bl = tapmode = this.mode > 1;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            return false;
        }
        if (this.mEnergyHatches.size() == 0) {
            return false;
        }
        byte intier = ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get((int)0)).mTier;
        for (GT_MetaTileEntity_Hatch_Energy in : this.mEnergyHatches) {
            if (in.mTier == intier) continue;
            return false;
        }
        for (mHeight = 1; mHeight <= 8; ++mHeight) {
            if (tapmode) {
                this.mTiers = mHeight;
                if (this.checkPiece(STRUCTURE_PIECE_TAP_LAYER, 2, mHeight, 1)) continue;
                break;
            }
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 1, mHeight, 0)) break;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_TOP, 1, mHeight, 0)) {
            return false;
        }
        this.mTiers = mHeight - 1;
        if (this.mDynamoHatches.size() == 0 || this.mMaintenanceHatches.size() != 1 || this.mTiers == 0) {
            return false;
        }
        byte outtier = ((GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get((int)0)).mTier;
        for (GT_MetaTileEntity_Hatch_Dynamo out : this.mDynamoHatches) {
            if (out.mTier == outtier) continue;
            return false;
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ManualTrafo(this.mName);
    }

    public void saveNBTData(NBTTagCompound ntag) {
        super.saveNBTData(ntag);
        ntag.func_74768_a("mTiers", this.mTiers);
        ntag.func_74774_a("mMode", this.mode);
        ntag.func_74757_a("upstep", this.upstep);
    }

    public void loadNBTData(NBTTagCompound ntag) {
        super.loadNBTData(ntag);
        this.mTiers = ntag.func_74762_e("mTiers");
        this.mode = ntag.func_74771_c("mMode");
        this.upstep = ntag.func_74767_n("upstep");
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)2), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)2), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)2)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.mode = this.mInventory[1] == null || !this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") ? (byte)0 : (byte)Math.min(3, this.mInventory[1].func_77960_j());
        int mHeight = Math.min(itemStack.field_77994_a, 8);
        boolean tapmode = this.mode > 1;
        this.buildPiece(STRUCTURE_PIECE_BASE, itemStack, b, 1, 0, 0);
        for (int i = 0; i < mHeight; ++i) {
            if (tapmode) {
                this.buildPiece(STRUCTURE_PIECE_TAP_LAYER, itemStack, b, 2, i + 1, 1);
                continue;
            }
            this.buildPiece(STRUCTURE_PIECE_LAYER, itemStack, b, 1, i + 1, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, itemStack, b, 1, mHeight + 1, 0);
    }
}

