/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.tiered.LowPowerLaser;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import cpw.mods.fml.common.Optional;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public abstract class GT_TileEntity_MegaMultiBlockBase<T extends GT_TileEntity_MegaMultiBlockBase<T>>
extends GT_MetaTileEntity_EnhancedMultiBlockBase<T>
implements TecTechEnabledMulti {
    long lEUt = 0L;
    private int energyTier = -1;
    public ArrayList<Object> TTTunnels = new ArrayList();
    public ArrayList<Object> TTMultiAmp = new ArrayList();

    protected GT_TileEntity_MegaMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaMultiBlockBase(String aName) {
        super(aName);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.lEUt = aNBT.func_74763_f("lEUt");
    }

    public void clearHatches() {
        super.clearHatches();
        this.energyTier = -1;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("lEUt", this.lEUt);
    }

    @Optional.Method(modid="tectech")
    boolean areLazorsLowPowa() {
        List collection = this.getTecTechEnergyTunnels();
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (tecTechEnergyMulti instanceof LowPowerLaser) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="tectech")
    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyTunnels() {
        return this.TTTunnels;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyMultis() {
        return this.TTMultiAmp;
    }

    public boolean drainEnergyInput(long aEU) {
        if (LoaderReference.tectech) {
            return TecTechUtils.drainEnergyMEBFTecTech(this, aEU);
        }
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }

    public long getMaxInputVoltage() {
        if (LoaderReference.tectech) {
            return TecTechUtils.getMaxInputVoltage(this);
        }
        return super.getMaxInputVoltage();
    }

    @Deprecated
    protected void calculateOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, maxInputVoltage, false);
    }

    @Deprecated
    protected void calculatePerfectOverclockedNessMulti(int aEUt, int aDuration, int mAmperage, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, maxInputVoltage, true);
    }

    public String[] getInfoData() {
        return LoaderReference.tectech ? this.getInfoDataArray((GT_MetaTileEntity_MultiBlockBase)this) : super.getInfoData();
    }

    @Override
    public String[] getInfoDataArray(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long[] ttHatches = this.getCurrentInfoData();
        long storedEnergy = ttHatches[0];
        long maxEnergy = ttHatches[1];
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        String tName = BW_Util.getTierNameFromVoltage(nominalV);
        if (tName.equals("MAX+")) {
            tName = EnumChatFormatting.OBFUSCATED + "MAX+";
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)(-this.lEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*" + GT_Utility.formatNumbers((long)TecTechUtils.getMaxInputAmperage(this)) + "A) = " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)nominalV) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + tName + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %", BW_Tooltip_Reference.BW};
    }

    @Deprecated
    protected byte calculateOverclockedNessMultiInternal(long aEUt, int aDuration, long maxInputVoltage, boolean perfectOC) {
        byte mTier = (byte)Math.max(0, BW_Util.getTier(maxInputVoltage));
        byte overclockCount = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.lEUt = 0x7FFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.lEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= BW_Util.getTierVoltage(mTier - 1)) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= perfectOC ? 2 : 1;
                xEUt = this.mMaxProgresstime <= 0 ? xEUt >> 1 : xEUt << 2;
                overclockCount = (byte)(overclockCount + 1);
            }
            while (xEUt > maxInputVoltage && xEUt >= aEUt) {
                xEUt >>= 2;
                this.mMaxProgresstime <<= perfectOC ? 2 : 1;
                overclockCount = (byte)(overclockCount - 1);
            }
            if (xEUt < aEUt) {
                xEUt <<= 2;
                this.mMaxProgresstime >>= perfectOC ? 2 : 1;
                overclockCount = (byte)(overclockCount + 1);
            }
            this.lEUt = xEUt;
            if (this.lEUt == 0L) {
                this.lEUt = 1L;
            }
            if (this.mMaxProgresstime <= 0) {
                this.mMaxProgresstime = 1;
            }
        }
        return overclockCount;
    }

    protected void calculateOverclockedNessMulti(long aEUt, int aDuration, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, maxInputVoltage, false);
    }

    @Deprecated
    protected void calculatePerfectOverclockedNessMulti(long aEUt, int aDuration, long maxInputVoltage) {
        this.calculateOverclockedNessMultiInternal(aEUt, aDuration, maxInputVoltage, true);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (LoaderReference.tectech) {
            int tier = TecTechUtils.addEnergyInputToMachineList(this, aTileEntity, aBaseCasingIndex, this.energyTier);
            if (this.energyTier == -1) {
                this.energyTier = tier;
            }
            return tier != -1;
        }
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            if (this.energyTier == -1) {
                this.energyTier = ((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity).mTier;
            }
            if (((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity).mTier != this.energyTier) {
                return false;
            }
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        return false;
    }

    public void stopMachine() {
        this.lEUt = 0L;
        super.stopMachine();
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            this.addEnergyOutput(this.lEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.lEUt < 0L && !this.drainEnergyInput(-this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    protected static class StructureElementAirNoHint<T>
    implements IStructureElement<T> {
        private static final StructureElementAirNoHint<?> INSTANCE = new StructureElementAirNoHint();

        public static <T> IStructureElement<T> getInstance() {
            return INSTANCE;
        }

        private StructureElementAirNoHint() {
        }

        public boolean check(T o, World world, int x, int y, int z) {
            return world.func_147437_c(x, y, z);
        }

        public boolean spawnHint(T o, World world, int x, int y, int z, ItemStack trigger) {
            if (world.func_72899_e(x, y, z) && !world.func_147437_c(x, y, z)) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)13);
            }
            return true;
        }

        public boolean placeBlock(T o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147468_f(x, y, z);
            return true;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.createEmpty();
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(T o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return IStructureElement.PlaceResult.ACCEPT;
        }
    }

    protected static enum TTEnabledEnergyHatchElement implements IHatchElement<GT_TileEntity_MegaMultiBlockBase<?>>
    {
        INSTANCE;

        private static final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return mteClasses;
        }

        public IGT_HatchAdder<? super GT_TileEntity_MegaMultiBlockBase<?>> adder() {
            return GT_TileEntity_MegaMultiBlockBase::addEnergyInputToMachineList;
        }

        public long count(GT_TileEntity_MegaMultiBlockBase<?> t) {
            return t.mEnergyHatches.size() + t.TTTunnels.size() + t.TTMultiAmp.size();
        }

        static {
            ImmutableList.Builder builder = ImmutableList.builder().addAll((Iterable)GT_HatchElement.Energy.mteClasses());
            if (LoaderReference.tectech) {
                builder.add(GT_MetaTileEntity_Hatch_EnergyMulti.class);
            }
            mteClasses = builder.build();
        }
    }
}

