/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.configs;

import com.github.bartimaeusnek.bartworks.API.API_ConfigValues;
import com.github.bartimaeusnek.bartworks.ASM.BWCoreTransformer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private static final int IDU = 85;
    public static Configuration c;
    public static int IDOffset;
    public static int megaMachinesMax;
    public static int mbWaterperSec;
    public static int ross128BID;
    public static int ross128BAID;
    public static int ross128btier;
    public static int ross128batier;
    public static int landerType;
    public static int ross128bRuinChance;
    public static int creativeScannerID;
    public static int bioVatMaxParallelBonus;
    public static int cutoffTier;
    public static int[][][] metasForTiers;
    public static long energyPerCell;
    public static boolean newStuff;
    public static boolean BioLab;
    public static boolean Ross128Enabled;
    public static boolean disableExtraGassesForEBF;
    public static boolean disableMagicalForest;
    public static boolean DEHPDirectSteam;
    public static boolean teslastaff;
    public static boolean classicMode;
    public static boolean GTppLogDisabler;
    public static boolean tooltips;
    public static boolean sharedItemStackTooltip;
    public static boolean[] enabledPatches;
    public static byte maxTierRoss;
    public static boolean disableBoltedBlocksCasing;
    public static boolean disableReboltedBlocksCasing;
    public static int pollutionHeatedWaterPumpSecond;
    public static int basePollutionMBFSecond;
    public static Set<String> voidMinerBlacklist;
    public static boolean disablePistonInEIC;
    private static final int[][] METAFORTIERS_ENERGY;
    private static final int[][] METAFORTIERS_BUFFER;
    private static final int[][] METAFORTIERS_CABLE;
    private static final int[][] METAFORTIERS_MACHINE;
    private static int[][][] defaultMetasForTiers;
    private static final String[] VOLTAGE_NAMES;
    private static final String[] names;

    public ConfigHandler(Configuration C) {
        int i;
        c = C;
        classicMode = c.get("System", "Enable Classic Mode", false, "Enables the classic Mode (all recipes in normal machines are doable in MV").getBoolean(false);
        creativeScannerID = c.get("System", "Creative Debug Scanner", 0, "ID for the Creative Debug Scanner Block").getInt(0);
        tooltips = c.get("System", "BartWorksToolTips", true, "If you wish to enable extra tooltips").getBoolean(true);
        sharedItemStackTooltip = c.get("System", "BartWorksSharedItemStackToolTips", true, "If you wish to enable \"Shared Item Stack\" tooltips").getBoolean(true);
        IDOffset = c.get("System", "ID Offset", 12600, "ID Offset for this mod. This Mod uses 85 IDs. DO NOT CHANGE IF YOU DONT KNOW WHAT THIS IS").getInt(12600);
        teslastaff = c.get("System", "Enable Teslastaff", false, "Enables the Teslastaff, an Item used to destroy Electric Armors").getBoolean(false);
        BioLab = !c.get("System", "Disable BioLab", false, "This switch disables the BioLab, BioVat etc. If you use GT5.08 or equivalent, this needs to be turned off!").getBoolean(false);
        cutoffTier = c.get("System", "Tier to nerf circuits", 5, "This switch sets the lowest unnerfed Circuit Recipe Tier. -1 to disable it completely.", -1, VOLTAGE_NAMES.length).getInt(5);
        cutoffTier = cutoffTier == -1 ? VOLTAGE_NAMES.length : cutoffTier;
        disableExtraGassesForEBF = c.get("System", "Disable Extra Gases for EBF", false, "This switch disables extra gas recipes for the EBF, i.e. Xenon instead of Nitrogen").getBoolean(false);
        disableBoltedBlocksCasing = c.get("System", "Disable Bolted Casings", false, "This switch disable the generation of bolted casings").getBoolean(false);
        disableReboltedBlocksCasing = c.get("System", "Disable Rebolted Casings", false, "This switch disable the generation of rebolted casings").getBoolean(false);
        mbWaterperSec = c.get("Singleblocks", "mL Water per Sec for the StirlingPump", 150).getInt(150);
        energyPerCell = c.get("Multiblocks", "energyPerLESUCell", 1000000, "This will set Up the Energy per LESU Cell", 1000000, Integer.MAX_VALUE).getInt(1000000);
        DEHPDirectSteam = c.get("Multiblocks", "DEHP Direct Steam Mode", false, "This switch enables the Direct Steam Mode of the DEHP. If enabled it will take in Waterand output steam. If disabled it will Input IC2Coolant and output hot coolant").getBoolean(false);
        megaMachinesMax = c.get("Multiblocks", "Mega Machines Maximum Recipes per Operation", 256, "This changes the Maximum Recipes per Operation to the specified Valure").getInt(256);
        bioVatMaxParallelBonus = c.get("Multiblocks", "BioVat Maximum Bonus on Recipes", 1000, "This are the maximum parallel Operations the BioVat can do, when the output is half full.").getInt(1000);
        voidMinerBlacklist = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(c.get("Multiblocks", "Void Miner Blacklist", new String[0], "This is a blacklist for the Void Miner, blacklisted ores will not enter the drop prize pool. Please fill in the Unique Identifier of Ore and connect Damage with a colon, For example: gregtech:gt.blockores:32").getStringList())));
        disablePistonInEIC = c.get("Multiblocks", "Disable Electric Implosion Compressor piston", false, "This switch completely disables piston animation in Electric Implosion Compressor multiblock").getBoolean(false);
        pollutionHeatedWaterPumpSecond = c.get("Pollution", "Pollution produced per second by the water pump", pollutionHeatedWaterPumpSecond, "How much should the Simple Stirling Water Pump produce pollution per second").getInt(pollutionHeatedWaterPumpSecond);
        basePollutionMBFSecond = c.get("Pollution", "Pollution produced per tick by the MBF per ingot", basePollutionMBFSecond, "How much should the MBF produce pollution per tick per ingot. Then it'll be multiplied by the amount of ingots done in parallel").getInt(basePollutionMBFSecond);
        if (IDOffset == 0) {
            IDOffset = 12600;
            c.get("System", "ID Offset", 12600, "ID Offset for this mod. This Mod uses 85 IDs. DO NOT CHANGE IF YOU DONT KNOW WHAT THIS IS").set(12600);
        }
        GTppLogDisabler = c.get("System", "Disable GT++ Logging", false, "Enables or Disables GT++ Logging.").getBoolean(false);
        API_ConfigValues.debugLog = c.get("System", "Enable Debug Log", false, "Enables or Disables the debug log.").getBoolean(false);
        for (i = 0; i < BWCoreTransformer.CLASSESBEEINGTRANSFORMED.length; ++i) {
            BWCoreTransformer.shouldTransform[i] = c.get("ASM fixes", BWCoreTransformer.DESCRIPTIONFORCONFIG[i] + " in class: " + BWCoreTransformer.CLASSESBEEINGTRANSFORMED[i], true).getBoolean(true);
        }
        enabledPatches = new boolean[BWCoreTransformer.shouldTransform.length];
        enabledPatches = Arrays.copyOf(BWCoreTransformer.shouldTransform, BWCoreTransformer.shouldTransform.length);
        ross128BID = c.get("CrossMod Interactions", "DimID - Ross128b", -64, "The Dim ID for Ross128b").getInt(-64);
        ross128BAID = c.get("CrossMod Interactions", "DimID - Ross128ba", -63, "The Dim ID for Ross128ba (Ross128b's Moon)").getInt(-63);
        ross128btier = c.get("CrossMod Interactions", "Rocket Tier - Ross128b", 3, "The Rocket Tier for Ross128b").getInt(3);
        ross128batier = c.get("CrossMod Interactions", "Rocket Tier - Ross128ba", 3, "The Rocket Tier for Ross128a").getInt(3);
        ross128bRuinChance = c.get("CrossMod Interactions", "Ruin Chance - Ross128b", 512, "Higher Values mean lesser Ruins.").getInt(512);
        Ross128Enabled = c.get("CrossMod Interactions", "Galacticraft - Activate Ross128 System", true, "If the Ross128 System should be activated, DO NOT CHANGE AFTER WORLD GENERATION").getBoolean(true);
        landerType = c.get("CrossMod Interactions", "LanderType", 3, "1 = Moon Lander, 2 = Landing Balloons, 3 = Asteroid Lander").getInt(3);
        disableMagicalForest = c.get("CrossMod Interactions", "Disable Magical Forest - Ross128b", false, "True disables the magical Forest Biome on Ross for more performance during World generation.").getBoolean(false);
        maxTierRoss = (byte)c.get("Ross Ruin Metas", "A_Ruin Machine Tiers", 6, "", 0, VOLTAGE_NAMES.length).getInt(6);
        metasForTiers = new int[4][maxTierRoss][];
        for (i = 0; i < 4; ++i) {
            if (maxTierRoss > defaultMetasForTiers[i].length) {
                ConfigHandler.defaultMetasForTiers[i] = new int[maxTierRoss][0];
            }
            for (int j = 0; j < maxTierRoss; ++j) {
                ConfigHandler.metasForTiers[i][j] = c.get("Ross Ruin Metas", j + "_Ruin " + names[i] + " Tier " + VOLTAGE_NAMES[j], defaultMetasForTiers[i][j]).getIntList();
            }
        }
        ConfigHandler.setUpComments();
        if (c.hasChanged()) {
            c.save();
        }
    }

    private static void setUpComments() {
        c.addCustomCategoryComment("ASM fixes", "Disable ASM fixes here.");
        c.addCustomCategoryComment("Singleblocks", "Singleblock Options can be set here.");
        c.addCustomCategoryComment("Multiblocks", "Multiblock Options can be set here.");
        c.addCustomCategoryComment("System", "Different System Settings can be set here.");
        c.addCustomCategoryComment("CrossMod Interactions", "CrossMod Interaction Settings can be set here. For Underground Fluid settings change the Gregtech.cfg!");
        c.addCustomCategoryComment("Ross Ruin Metas", "Ruin Metas and Tiers can be set here.");
    }

    static {
        IDOffset = 12600;
        megaMachinesMax = 256;
        mbWaterperSec = 150;
        ross128BID = -64;
        ross128BAID = -63;
        ross128btier = 3;
        ross128batier = 3;
        landerType = 3;
        ross128bRuinChance = 512;
        bioVatMaxParallelBonus = 1000;
        cutoffTier = 5;
        energyPerCell = 1000000L;
        newStuff = true;
        BioLab = true;
        Ross128Enabled = true;
        tooltips = true;
        sharedItemStackTooltip = true;
        disableBoltedBlocksCasing = false;
        disableReboltedBlocksCasing = false;
        pollutionHeatedWaterPumpSecond = 5;
        basePollutionMBFSecond = 400;
        voidMinerBlacklist = Collections.unmodifiableSet(new HashSet());
        disablePistonInEIC = false;
        METAFORTIERS_ENERGY = new int[][]{{100, 101, 102, 105}, {1110, 1115, 1120, 1127}, {1111, 12726, 1116, 1121, 1128}, {1112, 12727, 1117, 1122, 1129}, {12728, 1190, 1130, 12685}, {1191, 1174, 695, 12686}};
        METAFORTIERS_BUFFER = new int[][]{{5133, 5123}, {161, 171, 181, 191}, {162, 172, 182, 192}, {163, 173, 183, 193}, {164, 174, 184, 194}, {165, 175, 185, 195}};
        METAFORTIERS_CABLE = new int[][]{{5133, 5123}, {1210, 1230, 1250, 1270, 1290}, {1310, 1330, 1350, 1370, 1390}, {1410, 1430, 1450, 1470, 1490}, {1510, 1530, 1550, 1570, 1590}, {1650, 1670, 1690}};
        METAFORTIERS_MACHINE = new int[][]{{103, 104, 106, 107, 109, 110, 112, 113, 115, 116, 118, 119}, {201, 211, 221, 231, 241, 251, 261, 271, 281, 291, 301, 311, 321, 331, 341, 351, 361, 371, 381, 391, 401, 411, 421, 431, 441, 451, 461, 471, 481, 491, 501, 511, 521, 531, 541, 551, 561, 571, 581, 591, 601, 611, 621, 631, 641, 651, 661, 671}, {202, 212, 222, 232, 242, 252, 262, 272, 282, 292, 302, 312, 322, 332, 342, 352, 362, 372, 382, 392, 402, 412, 422, 432, 442, 452, 462, 472, 482, 492, 502, 512, 522, 532, 542, 552, 562, 572, 582, 592, 602, 612, 622, 632, 642, 652, 662, 672}, {203, 213, 223, 233, 243, 253, 263, 273, 283, 293, 303, 313, 323, 333, 343, 353, 363, 373, 383, 393, 403, 413, 423, 433, 443, 453, 463, 473, 483, 493, 503, 513, 523, 533, 543, 553, 563, 573, 583, 593, 603, 613, 623, 633, 643, 653, 663, 673}, {204, 214, 224, 234, 244, 254, 264, 274, 284, 294, 304, 314, 324, 334, 344, 354, 364, 374, 384, 394, 404, 414, 424, 434, 444, 454, 464, 474, 484, 494, 504, 514, 524, 534, 544, 554, 564, 574, 584, 594, 604, 614, 624, 634, 644, 654, 664, 674}, {205, 215, 225, 235, 245, 255, 265, 275, 285, 295, 305, 315, 325, 335, 345, 355, 365, 375, 385, 395, 405, 415, 425, 435, 445, 455, 465, 475, 485, 495, 505, 515, 525, 535, 545, 555, 565, 575, 585, 595, 605, 615, 625, 635, 645, 655, 665, 675}};
        defaultMetasForTiers = new int[][][]{METAFORTIERS_ENERGY, METAFORTIERS_BUFFER, METAFORTIERS_CABLE, METAFORTIERS_MACHINE};
        VOLTAGE_NAMES = new String[]{"High Pressure Steam", "Low Voltage", "Medium Voltage", "High Voltage", "Extreme Voltage", "Insane Voltage", "Ludicrous Voltage", "ZPM Voltage", "Ultimate Voltage", "Ultimate High Voltage", "Ultimate Extreme Voltage", "Ultimate Insane Voltage", "Ultimate Mega Voltage", "Ultimate Extended Mega Voltage", "Overpowered Voltage", "Maximum Voltage"};
        names = new String[]{"Generators", "Buffers", "Cables", "Machines"};
    }
}

