/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GT_TileEntity_DEHP
extends GT_MetaTileEntity_DrillerBase {
    private static float nulearHeatMod = 2.0f;
    private byte mMode;
    private byte mTier;

    public GT_TileEntity_DEHP(int aID, int tier, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.mTier = (byte)tier;
    }

    public GT_TileEntity_DEHP(String aName, byte mTier) {
        super(aName);
        this.mTier = mTier;
    }

    public void onConfigLoad(GT_Config aConfig) {
        try {
            Class<TileEntityNuclearReactorElectric> c = TileEntityNuclearReactorElectric.class;
            Field f = c.getDeclaredField("huOutputModifier");
            f.setAccessible(true);
            nulearHeatMod = f.getFloat(f);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException e) {
            e.printStackTrace();
        }
        super.onConfigLoad(aConfig);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mTier", this.mTier);
        aNBT.func_74774_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mTier = aNBT.func_74771_c("mTier");
        this.mMode = aNBT.func_74771_c("mMode");
        super.loadNBTData(aNBT);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_DEHP(this.mName, this.mTier);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        tt.addMachineType("Geothermal Heat Pump").addInfo("Consumes " + GT_Values.V[this.mTier + 2] + "EU/t").addInfo("Has 4 Modes, use the Screwdriver to change them:");
        if (ConfigHandler.DEHPDirectSteam) {
            tt.addInfo("0 Idle, 1 Steam, 2 Superheated Steam (requires Distilled Water), 3 Retract").addInfo("Explodes when it runs out of Water/Distilled Water").addInfo("Converts " + (long)(this.mTier * 1200 * 20) + "L/s Water(minus 10% per Maintenance Problem) to Steam").addInfo("Converts " + (long)(this.mTier * 600 * 20) + "L/s Distilled Water(minus 10% per Maintenance Problem) to SuperheatedSteam");
        } else {
            tt.addInfo("0 Idle, 1 & 2 Coolant Heating Mode (no Difference between them), 3 Retract").addInfo("Explodes when it runs out of Coolant").addInfo("Heats up " + (long)((double)(this.mTier * 24) * (double)nulearHeatMod) * 20L + "L/s Coolant(minus 10% per Maintenance Problem)");
        }
        tt.addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch(GT_Values.VN[this.getMinTier()] + "+, Any base casing").addMaintenanceHatch("Any base casing").addInputBus("Mining Pipes, optional, any base casing").addInputHatch("Any base casing").addOutputHatch("Any base casing").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    protected ItemList getCasingBlockItem() {
        return ItemList.Casing_HeatProof;
    }

    protected Materials getFrameMaterial() {
        return Materials.Tungsten;
    }

    protected int getCasingTextureIndex() {
        return 11;
    }

    protected int getMinTier() {
        return 2 + this.mTier;
    }

    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mInputHatches.isEmpty();
    }

    private long getFluidFromHatches(Fluid f) {
        long ret = 0L;
        for (GT_MetaTileEntity_Hatch_Input ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(f)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    private long getWaterFromHatches(boolean onlyDistilled) {
        Fluid toConsume1 = FluidRegistry.WATER;
        Fluid toConsume2 = GT_ModHandler.getDistilledWater((long)1L).getFluid();
        if (onlyDistilled) {
            toConsume1 = toConsume2;
        }
        long ret = 0L;
        for (GT_MetaTileEntity_Hatch_Input ih : this.mInputHatches) {
            if (!ih.getFluid().getFluid().equals(toConsume1) && !ih.getFluid().getFluid().equals(toConsume2)) continue;
            ret += (long)ih.getFluidAmount();
        }
        return ret;
    }

    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.mMode != 3) {
            this.isPickingPipes = false;
            try {
                Field workState = ((Object)((Object)this)).getClass().getField("workState");
                workState.setInt((Object)this, 0);
            }
            catch (IllegalAccessException | NoSuchFieldError | NoSuchFieldException throwable) {
                // empty catch block
            }
            return true;
        }
        return super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        this.mMode = (byte)(this.mMode + 1);
        if (this.mMode >= 4) {
            this.mMode = 0;
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Mode: " + this.mMode));
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.mMode == 3) {
            this.isPickingPipes = true;
            try {
                Field workState = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("workState");
                workState.setInt((Object)this, 2);
                return true;
            }
            catch (IllegalAccessException | NoSuchFieldError | NoSuchFieldException workState) {
                // empty catch block
            }
            return true;
        }
        if (this.tryLowerPipeState(false) == 0) return true;
        if (this.waitForPipes()) {
            return false;
        }
        if (this.mMode == 0) {
            this.mMode = 1;
        }
        if (ConfigHandler.DEHPDirectSteam) {
            if (this.mMode == 1) {
                long steamProduced = (long)(this.mTier * 600) * 2L * (long)this.mEfficiency / 10000L;
                long waterConsume = (steamProduced + 160L) / 160L;
                if (this.getWaterFromHatches(false) - waterConsume > 0L) {
                    this.consumeFluid(FluidRegistry.WATER, waterConsume);
                    this.addOutput(GT_ModHandler.getSteam((long)steamProduced));
                    return true;
                }
                this.explodeMultiblock();
                return false;
            }
            if (this.mMode != 2) return true;
            long steamProduced = (long)(this.mTier * 300) * 2L * (long)this.mEfficiency / 10000L;
            long waterConsume = (steamProduced + 160L) / 160L;
            if (this.getWaterFromHatches(true) - waterConsume > 0L) {
                this.consumeFluid(GT_ModHandler.getDistilledWater((long)1L).getFluid(), waterConsume);
                this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)((int)steamProduced)));
                return true;
            }
            this.explodeMultiblock();
            return false;
        }
        if (this.mMode != 1) {
            if (this.mMode != 2) return true;
        }
        long coolantConverted = (long)((double)(this.mTier * 24) * (double)nulearHeatMod * (double)this.mEfficiency / 10000.0);
        if (this.getFluidFromHatches(FluidRegistry.getFluid((String)"ic2coolant")) - coolantConverted > 0L) {
            this.consumeFluid(FluidRegistry.getFluid((String)"ic2coolant"), coolantConverted);
            this.addOutput(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)((int)coolantConverted)));
            return true;
        }
        this.explodeMultiblock();
        return false;
    }

    private boolean consumeFluid(Fluid fluid, long ammount) {
        if (ammount > Integer.MAX_VALUE) {
            int[] tmp = new int[(int)(ammount / Integer.MAX_VALUE)];
            Arrays.fill(tmp, (int)(ammount / Integer.MAX_VALUE));
            block0: for (int i = 0; i < tmp.length; ++i) {
                for (GT_MetaTileEntity_Hatch_Input ih : this.mInputHatches) {
                    if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GT_ModHandler.getDistilledWater((long)1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                        int n = i;
                        tmp[n] = tmp[n] - ih.drain((int)((int)ammount), (boolean)true).amount;
                    }
                    if (tmp[i] > 0) continue;
                    continue block0;
                }
            }
            return tmp[tmp.length - 1] <= 0;
        }
        long tmp = ammount;
        for (GT_MetaTileEntity_Hatch_Input ih : this.mInputHatches) {
            if (fluid.equals(FluidRegistry.WATER) ? ih.getFluid().getFluid().equals(fluid) || ih.getFluid().getFluid().equals(GT_ModHandler.getDistilledWater((long)1L).getFluid()) : ih.getFluid().getFluid().equals(fluid)) {
                tmp -= (long)ih.drain((int)((int)ammount), (boolean)true).amount;
            }
            if (tmp > 0L) continue;
            return true;
        }
        return false;
    }

    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? 60 : Math.toIntExact(GT_Values.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mProgresstime = 0;
        this.mMaxProgresstime = 1;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
    }
}

