/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement;

import com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement.BWGTMetaItems;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GTMetaItemEnhancer {
    static List<Materials> NoMetaValue;

    private GTMetaItemEnhancer() {
    }

    public static void init() {
        Materials m2;
        int i;
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        NoMetaValue = Materials.getMaterialsMap().values().stream().filter(m -> m.mMetaItemSubID == -1).collect(Collectors.toList());
        BWGTMetaItems moltenCapsuls = new BWGTMetaItems(OrePrefixes.capsuleMolten, null);
        BWGTMetaItems capsuls = new BWGTMetaItems(OrePrefixes.capsule, NoMetaValue);
        Materials[] values = Materials.values();
        int valuesLength = values.length;
        for (i = 0; i < valuesLength; ++i) {
            m2 = values[i];
            if (m2.mStandardMoltenFluid != null && GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cellMolten, (Object)m2, (long)1L) != null) {
                FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(m2.getMolten(144L), new ItemStack((Item)moltenCapsuls, 1, i), GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"refractoryEmpty", (long)1L));
                FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
                GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
                GT_Values.RA.addFluidCannerRecipe(GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"refractoryEmpty", (long)1L), new ItemStack((Item)moltenCapsuls, 1, i), m2.getMolten(144L), GT_Values.NF);
                GT_Values.RA.addFluidCannerRecipe(new ItemStack((Item)moltenCapsuls, 1, i), GT_Values.NI, GT_Values.NF, m2.getMolten(144L));
            }
            if (m2.getFluid(1L) == null && m2.getGas(1L) == null || OreDictionary.doesOreNameExist((String)("capsule" + m2.mName))) continue;
            GTMetaItemEnhancer.addFluidData(m2, GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"waxCapsule", (long)1L), (Item)capsuls, 1000, i, true);
        }
        valuesLength = NoMetaValue.size();
        for (i = 0; i < valuesLength; ++i) {
            m2 = NoMetaValue.get(i);
            if (m2.getFluid(1L) == null && m2.getGas(1L) == null || OreDictionary.doesOreNameExist((String)("capsule" + m2.mName))) continue;
            GTMetaItemEnhancer.addFluidData(m2, GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"waxCapsule", (long)1L), (Item)capsuls, 1000, i + 1001, true);
        }
    }

    private static void addFluidData(Materials m, ItemStack container, Item filled, int amount, int it, boolean empty) {
        Fluid f = m.getFluid(1L) != null ? m.getFluid(1L).getFluid() : m.getGas(1L).getFluid();
        FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(f, amount), new ItemStack(filled, 1, it), container);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)emptyData);
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
        GT_Values.RA.addFluidCannerRecipe(container, new ItemStack(filled, 1, it), new FluidStack(f, amount), GT_Values.NF);
        GT_Values.RA.addFluidCannerRecipe(new ItemStack(filled, 1, it), empty ? GT_Values.NI : container, GT_Values.NF, new FluidStack(f, amount));
    }

    public static void addAdditionalOreDictToForestry() {
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        OreDictionary.registerOre((String)"capsuleWater", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleWater"));
        OreDictionary.registerOre((String)"capsuleIce", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleIce"));
        OreDictionary.registerOre((String)"capsuleHoney", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleHoney"));
        OreDictionary.registerOre((String)"capsuleJuice", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleJuice"));
        OreDictionary.registerOre((String)"capsuleSeedOil", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleSeedOil"));
        OreDictionary.registerOre((String)"capsuleEthanol", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleEthanol"));
        OreDictionary.registerOre((String)"capsuleBiomass", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleBiomass"));
        OreDictionary.registerOre((String)"capsuleShortMead", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleShortMead"));
        OreDictionary.registerOre((String)"capsuleMead", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleMead"));
        OreDictionary.registerOre((String)"capsuleFuel", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleFuel"));
        OreDictionary.registerOre((String)"capsuleOil", (ItemStack)GTMetaItemEnhancer.getForestryItem("waxCapsuleOil"));
        OreDictionary.registerOre((String)"capsuleLava", (ItemStack)GTMetaItemEnhancer.getForestryItem("refractoryLava"));
    }

    private static ItemStack getForestryItem(String itemName) {
        return GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)itemName, (long)1L);
    }
}

