/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.client.renderer.RendererGlasBlock;
import com.github.bartimaeusnek.bartworks.client.renderer.RendererSwitchingColorFluid;
import com.github.bartimaeusnek.bartworks.common.blocks.BioFluidBlock;
import com.github.bartimaeusnek.bartworks.common.tileentities.classic.BWTileEntityDimIDBridge;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.fluid.GT_FluidFactory;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Item_98;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidLoader {
    public static IIcon autogenIIcon;
    public static Fluid ff;
    public static int renderID;
    public static Block bioFluidBlock;
    public static Fluid[] BioLabFluidMaterials;
    public static ItemStack[] BioLabFluidCells;
    public static Fluid fulvicAcid;
    public static Fluid heatedfulvicAcid;
    public static Fluid Kerogen;

    public static void run() {
        renderID = RenderingRegistry.getNextAvailableRenderId();
        ff = new Fluid("BWfakeFluid");
        GregTech_API.sGTBlockIconload.add(() -> ff.setIcons(GregTech_API.sBlockIcons.func_94245_a(Mods.GregTech.getResourcePath(new String[]{"fluids", "fluid.molten.autogenerated"}))));
        fulvicAcid = FluidLoader.createAndRegisterFluid("Fulvic Acid", new Color(20, 20, 20));
        heatedfulvicAcid = FluidLoader.createAndRegisterFluid("Heated Fulvic Acid", new Color(40, 20, 20), 720);
        Kerogen = FluidLoader.createAndRegisterFluid("Kerogen", new Color(85, 85, 85));
        BioLabFluidMaterials = new Fluid[]{FluidLoader.createAndRegisterFluid("FluorecentdDNA", new Color(125, 50, 170)), FluidLoader.createAndRegisterFluid("EnzymesSollution", new Color(240, 200, 125)), FluidLoader.createAndRegisterFluid("Penicillin", new Color(255, 255, 255)), FluidLoader.createAndRegisterFluid("Polymerase", new Color(110, 180, 110))};
        BioLabFluidCells = new ItemStack[BioLabFluidMaterials.length];
        GT_MetaGenerated_Item_98.FluidCell[] fluidCells = new GT_MetaGenerated_Item_98.FluidCell[]{GT_MetaGenerated_Item_98.FluidCell.FLUORESCENT_DNA, GT_MetaGenerated_Item_98.FluidCell.ENZYME_SOLUTION, GT_MetaGenerated_Item_98.FluidCell.PENICILLIN, GT_MetaGenerated_Item_98.FluidCell.POLYMERASE};
        for (int i = 0; i < fluidCells.length; ++i) {
            FluidLoader.BioLabFluidCells[i] = fluidCells[i].get();
        }
        FluidStack dnaFluid = Mods.Gendustry.isModLoaded() ? FluidRegistry.getFluidStack((String)"liquiddna", (int)100) : Materials.Biomass.getFluid(100L);
        for (BioCulture B : BioCulture.BIO_CULTURE_ARRAY_LIST) {
            if (!B.isBreedable()) continue;
            B.setFluid(GT_FluidFactory.builder((String)(B.getName().replace(" ", "").toLowerCase() + "fluid")).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)B.getColor().getRed(), (short)B.getColor().getBlue(), (short)B.getColor().getGreen()}).withLocalizedName(B.getLocalisedName() + " Fluid").withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid());
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)10)}).fluidInputs(new FluidStack[]{new FluidStack(B.getFluid(), 1000)}).fluidOutputs(new FluidStack[]{dnaFluid}).duration(500).eut(TierEU.RECIPE_MV).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
        }
        bioFluidBlock = new BioFluidBlock();
        GameRegistry.registerBlock((Block)bioFluidBlock, (String)"coloredFluidBlock");
        GameRegistry.registerTileEntity(BWTileEntityDimIDBridge.class, (String)"bwTEDimIDBridge");
        if (SideReference.Side.Client) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)RendererSwitchingColorFluid.instance);
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)RendererGlasBlock.instance);
        }
    }

    public static Fluid createAndRegisterFluid(String Name, Color color) {
        return GT_FluidFactory.builder((String)Name).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()}).withStateAndTemperature(FluidState.LIQUID, 300).buildAndRegister().asFluid();
    }

    public static Fluid createAndRegisterFluid(String Name, Color color, int temperature) {
        return GT_FluidFactory.builder((String)Name).withTextureName("molten.autogenerated").withColorRGBA(new short[]{(short)color.getRed(), (short)color.getGreen(), (short)color.getBlue(), (short)color.getAlpha()}).withStateAndTemperature(FluidState.LIQUID, temperature).buildAndRegister().asFluid();
    }
}

