/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.API.modularUI.BW_UITextures;
import com.github.bartimaeusnek.bartworks.API.recipe.BartWorksRecipeMaps;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_TileEntity_CircuitAssemblyLine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_CircuitAssemblyLine>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_NEXT = "next";
    private static final String STRUCTURE_PIECE_NEXT_HINT = "next_hint";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final int MINIMUM_CIRCUIT_ASSEMBLER_LENGTH = 5;
    protected static final String IMPRINT_KEY = "Type";
    protected static final String LENGTH_KEY = "Length";
    protected static final String RUNNING_MODE_KEY = "RunningMode";
    private int length;
    private int mode;
    private String imprintedItemName;
    private ItemStack imprintedStack;
    private static final IStructureDefinition<GT_TileEntity_CircuitAssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{"~", "G", "G"}, {"g", "l", "g"}, {"b", "i", "b"}})).addShape("next", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "I", "b"}})).addShape("next_hint", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "i", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "o", "b"}})).addElement('G', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_CircuitAssemblyLine.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy}).casingIndex(16).dot(1).buildAndChain(GregTech_API.sBlockCasings3, 10)).addElement('g', BW_Util.ofGlassTieredMixed((byte)4, (byte)127, 5)).addElement('l', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)5)).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_CircuitAssemblyLine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.Maintenance}).casingIndex(16).dot(2).disallowOnly(new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST}).buildAndChain(GregTech_API.sBlockCasings2, 0)).addElement('i', GT_HatchElement.InputBus.newAny(16, 3, new ForgeDirection[]{ForgeDirection.DOWN})).addElement('I', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_CircuitAssemblyLine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).casingIndex(16).dot(2).disallowOnly(new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST}).buildAndChain(GregTech_API.sBlockCasings2, 0)).addElement('o', GT_HatchElement.OutputBus.newAny(16, 2, new ForgeDirection[]{ForgeDirection.DOWN})).build();
    private NBTTagCompound type = new NBTTagCompound();
    private String[] infoDataBuffer;

    public IStructureDefinition<GT_TileEntity_CircuitAssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Circuit Assembler/Circuit Assembly Line").addInfo("Controller block for the Circuit Assembly Line").addInfo("Change Mode with Screwdriver").addInfo("Does not lose efficiency when overclocked").addInfo("---------" + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"chat.cal.mode.0") + EnumChatFormatting.GRAY + "--------").addInfo("Imprint this machine with a Circuit Imprint,").addInfo("by putting the imprint in the controller").addInfo("Every Circuit Assembly Line can only be imprinted ONCE").addInfo("---------" + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"chat.cal.mode.1") + EnumChatFormatting.GRAY + "--------").addInfo("Does Circuit Assembler recipes, Minimum Length: " + EnumChatFormatting.RED + 5 + EnumChatFormatting.GRAY).addInfo("This mode supports Crafting Input Buffer/Bus and allows bus separation").addInfo("").addInfo(BW_Tooltip_Reference.TT_BLUEPRINT).addSeparator().beginVariableStructureBlock(2, 7, 3, 3, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input bus (Last Output bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - EV+ Tier Glass, Assembling Line Casing, EV+ Tier Glass").addStructureInfo("Layer 3 - Grate Machine Casing").addStructureInfo("Up to 7 repeating slices, last is Output Bus").addController("Layer 3 first slice front").addOtherStructurePart("1x " + StatCollector.func_74838_a((String)"GT5U.MBTT.EnergyHatch"), "Any layer 3 casing", new int[]{1}).addInputHatch("Any layer 1 casing", new int[]{2}).addInputBus("As specified on layer 1", new int[]{3, 4}).addOutputBus("As specified in final slice on layer 1", new int[]{4}).addOtherStructurePart("EV+ Tier Glass", "As specified on layer 2", new int[]{5}).addMaintenanceHatch("Any layer 1 casing", new int[]{2}).toolTipFinisher(BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get());
        return tt;
    }

    public String getTypeForDisplay() {
        if (this.type.equals((Object)new NBTTagCompound())) {
            return "";
        }
        return GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(this.type)));
    }

    public GT_TileEntity_CircuitAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_CircuitAssemblyLine(String aName) {
        super(aName);
    }

    private boolean imprintMachine(ItemStack itemStack) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            return true;
        }
        if (!GT_Utility.isStackValid((ItemStack)itemStack)) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof BW_Meta_Items.BW_GT_MetaGenCircuits && itemStack.func_77960_j() == 0 && itemStack.func_77978_p() != null && this.type.equals((Object)new NBTTagCompound())) {
            this.type = itemStack.func_77978_p();
            this.mInventory[1] = null;
            this.getBaseMetaTileEntity().issueBlockUpdate();
            return true;
        }
        return false;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient((SoundResource)SoundResource.IC2_MACHINES_MAGNETIZER_LOOP, (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.type = aNBT.func_74775_l(IMPRINT_KEY);
        this.imprintedItemName = GT_LanguageManager.getTranslateableItemStackName((ItemStack)ItemStack.func_77949_a((NBTTagCompound)this.type));
        this.mode = aNBT.func_74762_e(RUNNING_MODE_KEY);
        this.length = aNBT.func_74762_e(LENGTH_KEY);
        super.loadNBTData(aNBT);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a(IMPRINT_KEY, (NBTBase)this.type);
        }
        aNBT.func_74768_a(RUNNING_MODE_KEY, this.mode);
        aNBT.func_74768_a(LENGTH_KEY, this.length);
        super.saveNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a(IMPRINT_KEY, (NBTBase)this.type);
        }
        aNBT.func_74768_a(RUNNING_MODE_KEY, this.mode);
        aNBT.func_74768_a(LENGTH_KEY, this.length);
        super.saveNBTData(aNBT);
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mode = (this.mode + 1) % 2;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("chat.cal.mode." + this.mode)));
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    public RecipeMap<?> getRecipeMap() {
        if (this.mode == 0) {
            return BartWorksRecipeMaps.circuitAssemblyLineRecipes;
        }
        return RecipeMaps.circuitAssemblerRecipes;
    }

    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(BartWorksRecipeMaps.circuitAssemblyLineRecipes, RecipeMaps.circuitAssemblerRecipes);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().enablePerfectOverclock();
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.mode == 0) {
            if (this.type.equals((Object)new NBTTagCompound()) && !this.imprintMachine(this.getControllerSlot())) {
                return SimpleCheckRecipeResult.ofFailure((String)"no_imprint");
            }
            if (this.imprintedItemName == null || this.imprintedStack == null) {
                this.imprintedStack = new ItemStack((Item)BW_Meta_Items.getNEWCIRCUITS(), 1, 0);
                this.imprintedStack.func_77982_d(this.type);
                this.imprintedItemName = GT_LanguageManager.getTranslateableItemStackName((ItemStack)this.imprintedStack);
            }
        } else if (this.length < 5) {
            return SimpleCheckRecipeResult.ofFailure((String)"not_enough_length");
        }
        return super.checkProcessing();
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpecialSlotItem(this.imprintedStack);
    }

    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_MAGNETIZER_LOOP;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        if (this.mode == 0) {
            ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
            block0: for (GT_MetaTileEntity_Hatch_InputBus tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mInputBusses)) {
                tHatch.mRecipeMap = this.getRecipeMap();
                for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                    if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
                    continue block0;
                }
            }
            return rList;
        }
        return super.getStoredInputs();
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null || !(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input)) {
            return false;
        }
        ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_CircuitAssemblyLine(this.mName);
    }

    public String[] getInfoData() {
        if (this.infoDataBuffer != null) {
            return this.infoDataBuffer;
        }
        String[] oldInfo = super.getInfoData();
        this.infoDataBuffer = new String[oldInfo.length + 1];
        System.arraycopy(oldInfo, 0, this.infoDataBuffer, 0, oldInfo.length);
        this.infoDataBuffer[oldInfo.length] = StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + this.getTypeForDisplay();
        return this.infoDataBuffer;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 0, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 7; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_NEXT, leftToRight ? -i : i, 0, 0)) {
                return false;
            }
            this.length = i + 1;
            if (this.mOutputBusses.isEmpty()) continue;
            return this.mEnergyHatches.size() == 1 && this.mMaintenanceHatches.size() == 1;
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 0, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 7);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_NEXT, stackSize, hintsOnly, -i, 0, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tLength = Math.min(stackSize.field_77994_a + 1, 7);
        for (int i = 1; i < tLength - 1; ++i) {
            built = this.survivialBuildPiece(STRUCTURE_PIECE_NEXT_HINT, stackSize, -i, 0, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_LAST, stackSize, -(tLength - 1), 0, 0, elementBudget, env, false, true);
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(IMPRINT_KEY)) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l(IMPRINT_KEY)))));
        }
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.imprintedItemName, val -> {
            this.imprintedItemName = val;
        }));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mode == 1, val -> {
            this.mode = val != false ? 1 : 0;
        }).setTextureGetter(state -> state == 1 ? BW_UITextures.OVERLAY_BUTTON_ASSEMBLER_MODE : BW_UITextures.OVERLAY_BUTTON_LINE_MODE).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(80, 91).setSize(16, 16).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)("chat.cal.mode." + this.mode)))).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5));
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            if (this.mode == 0) {
                return false;
            }
            this.inputSeparation = !this.inputSeparation;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation));
            return true;
        }
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    public boolean supportsInputSeparation() {
        return this.mode != 0;
    }

    public boolean isInputSeparationEnabled() {
        return this.mode == 1 && super.isInputSeparationEnabled();
    }

    public boolean isRecipeLockingEnabled() {
        return this.imprintedItemName != null && !"".equals(this.imprintedItemName);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)("chat.cal.mode." + tag.func_74762_e(RUNNING_MODE_KEY))));
        if (tag.func_74764_b("ImprintedWith") && tag.func_74762_e(RUNNING_MODE_KEY) == 0) {
            currenttip.add(StatCollector.func_74838_a((String)"tooltip.cal.imprintedWith") + " " + EnumChatFormatting.YELLOW + tag.func_74779_i("ImprintedWith"));
        }
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        String imprintedWith = this.getTypeForDisplay();
        if (!imprintedWith.isEmpty()) {
            tag.func_74778_a("ImprintedWith", imprintedWith);
        }
        tag.func_74768_a(RUNNING_MODE_KEY, this.mode);
    }

    protected boolean supportsCraftingMEBuffer() {
        return this.mode != 0;
    }
}

