/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.common.loaders.BioCultureLoader;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BioRecipeLoader {
    public static void run() {
        BioRecipeLoader.registerWaterBasedBioLabIncubations();
        BioRecipeLoader.registerBacterialVatRecipes();
    }

    public static void registerWaterBasedBioLabIncubations() {
        FluidStack[] easyFluids;
        for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
            BWRecipes.instance.addBioLabRecipeIncubation(new ItemStack(Items.field_151078_bh), BioCultureLoader.rottenFleshBacteria, new int[]{3300}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(new ItemStack(Items.field_151071_bq), BioCultureLoader.eColi, new int[]{4500}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(ItemList.Food_Dough.get(1L, new Object[0]), BioCultureLoader.CommonYeast, new int[]{7500}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(ItemList.Food_Dough_Sugar.get(1L, new Object[0]), BioCultureLoader.WhineYeast, new int[]{2500}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(ItemList.Bottle_Wine.get(1L, new Object[0]), BioCultureLoader.WhineYeast, new int[]{3300}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(ItemList.Bottle_Beer.get(1L, new Object[0]), BioCultureLoader.BeerYeast, new int[]{2500}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(ItemList.Bottle_Dark_Beer.get(1L, new Object[0]), BioCultureLoader.BeerYeast, new int[]{3300}, new FluidStack[]{fluidStack}, 500, (int)TierEU.RECIPE_HV, 0);
            BWRecipes.instance.addBioLabRecipeIncubation(new ItemStack(Blocks.field_150346_d), BioCultureLoader.anaerobicOil, new int[]{100}, new FluidStack[]{fluidStack}, 1500, (int)TierEU.RECIPE_EV, 0);
        }
    }

    public static void registerWaterBasedBacterialVatRecipes() {
        FluidStack[] easyFluids;
        for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
            if (Mods.CropsPlusPlus.isModLoaded()) {
                BWRecipes.instance.addBacterialVatRecipe(new ItemStack[]{new ItemStack(Items.field_151102_aT, 64)}, new FluidStack[]{new FluidStack(fluidStack, 100)}, BioCultureLoader.CommonYeast, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.ghp", (int)1)}, 350, (int)TierEU.RECIPE_EV);
            }
            BWRecipes.instance.addBacterialVatRecipe(new ItemStack[]{ItemList.Crop_Drop_Grapes.get(16L, new Object[0])}, new FluidStack[]{new FluidStack(fluidStack, 100)}, BioCultureLoader.WhineYeast, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.wine", (int)12)}, 200, (int)TierEU.RECIPE_MV);
            BWRecipes.instance.addBacterialVatRecipe(new ItemStack[]{new ItemStack(Items.field_151102_aT, 4), ItemList.IC2_Hops.get(16L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Wheat, (long)8L)}, new FluidStack[]{new FluidStack(fluidStack, 100)}, BioCultureLoader.BeerYeast, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.beer", (int)5)}, 600, (int)TierEU.RECIPE_LV);
            BWRecipes.instance.addBacterialVatRecipe(new ItemStack[]{ItemList.IC2_Hops.get(32L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Wheat, (long)16L)}, new FluidStack[]{new FluidStack(fluidStack, 100)}, BioCultureLoader.BeerYeast, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.darkbeer", (int)10)}, 600, (int)TierEU.RECIPE_LV);
        }
    }

    public static void registerBacterialVatRecipes() {
        BioRecipeLoader.registerWaterBasedBacterialVatRecipes();
        BWRecipes.instance.addBacterialVatRecipe(null, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.grapejuice", (int)100)}, BioCultureLoader.WhineYeast, new FluidStack[]{FluidRegistry.getFluidStack((String)"potion.wine", (int)12)}, 400, (int)TierEU.RECIPE_LV);
        BWRecipes.instance.addBacterialVatRecipe(null, new FluidStack[]{Materials.FermentedBiomass.getFluid(10000L)}, BioCultureLoader.anaerobicOil, new FluidStack[]{new FluidStack(FluidLoader.fulvicAcid, 1000)}, 2748, (int)TierEU.RECIPE_HV);
    }

    public static void runOnServerStarted() {
        RecipeMaps.fermentingRecipes.getAllRecipes().forEach(recipe -> BWRecipes.instance.addBacterialVatRecipe(new ItemStack[]{null}, BioCultureLoader.generalPurposeFermentingBacteria, recipe.mFluidInputs, recipe.mFluidOutputs, recipe.mDuration, recipe.mEUt, GT_Utility.getTier((long)recipe.mEUt)));
    }
}

