/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.API.recipe.BartWorksRecipeMaps;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.client.renderer.BW_EICPistonVisualizer;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.common.net.EICPacket;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.blocks.LudicrousBlocks;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.net.GT_Packet;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class GT_TileEntity_ElectricImplosionCompressor
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GT_TileEntity_ElectricImplosionCompressor>
implements ISurvivalConstructable {
    private static final boolean pistonEnabled = !ConfigHandler.disablePistonInEIC;
    private Boolean piston = true;
    private static final SoundResource sound = SoundResource.RANDOM_EXPLODE;
    private final ArrayList<ChunkCoordinates> chunkCoordinates = new ArrayList(5);
    private int mBlockTier = 0;
    private int mCasing;
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cec", "ccc"}, {"ttt", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"nnn", "nnn", "nnn"}, {"nNn", "NNN", "nNn"}, {"nnn", "nnn", "nnn"}, {"t~t", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"CCC", "CeC", "CCC"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4)})).addElement('t', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement('f', StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement('n', StructureUtility.ofBlocksTiered(GT_TileEntity_ElectricImplosionCompressor.tieredBlockConverter(), GT_TileEntity_ElectricImplosionCompressor.getAllBlockTiers(), (Object)0, GT_TileEntity_ElectricImplosionCompressor::setBlockTier, GT_TileEntity_ElectricImplosionCompressor::getBlockTier)).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_ElectricImplosionCompressor.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(16).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4))})).addElement('e', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_ElectricImplosionCompressor.class).atLeast(new IHatchElement[]{GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(16).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4))})).addElement('N', (IStructureElement)new IStructureElement<GT_TileEntity_ElectricImplosionCompressor>(){
        private final List<Pair<Block, Integer>> tiers = GT_TileEntity_ElectricImplosionCompressor.getAllBlockTiers();

        public boolean check(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z) {
            if (!te.piston.booleanValue() && !world.func_147437_c(x, y, z)) {
                return false;
            }
            if (te.piston.booleanValue()) {
                int candidateMeta;
                Block candidate = world.func_147439_a(x, y, z);
                return GT_TileEntity_ElectricImplosionCompressor.getTierOfBlock(candidate, candidateMeta = world.func_72805_g(x, y, z)) != -1;
            }
            return true;
        }

        private Pair<Block, Integer> getTier(ItemStack trigger) {
            return this.tiers.get(Math.min(Math.max(trigger.field_77994_a, 1), this.tiers.size()) - 1);
        }

        public boolean spawnHint(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
            Pair<Block, Integer> tier = this.getTier(itemStack);
            if (te.piston.booleanValue()) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)((Block)tier.getKey()), (int)((Integer)tier.getValue()));
            }
            return true;
        }

        public boolean placeBlock(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
            Pair<Block, Integer> tier = this.getTier(itemStack);
            if (te.piston.booleanValue()) {
                world.func_147465_d(x, y, z, (Block)tier.getKey(), ((Integer)tier.getValue()).intValue(), 3);
            } else {
                world.func_147468_f(x, y, z);
            }
            return true;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(GT_TileEntity_ElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.createEmpty();
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(GT_TileEntity_ElectricImplosionCompressor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return StructureUtility.isAir().survivalPlaceBlock((Object)t, world, x, y, z, trigger, env);
        }
    }).build();

    public GT_TileEntity_ElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ElectricImplosionCompressor(String aName) {
        super(aName);
    }

    public static List<Pair<Block, Integer>> getAllBlockTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            private static final long serialVersionUID = 8171991663102417651L;
            {
                this.add(Pair.of((Object)GregTech_API.sBlockMetal5, (Object)2));
                this.add(Pair.of((Object)LudicrousBlocks.resource_block, (Object)1));
                this.add(Pair.of((Object)GregTech_API.sBlockMetal9, (Object)4));
                this.add(Pair.of((Object)GregTech_API.sBlockMetal9, (Object)3));
                this.add(Pair.of((Object)GregTech_API.sBlockMetal9, (Object)8));
            }
        };
    }

    public static ITierConverter<Integer> tieredBlockConverter() {
        return GT_TileEntity_ElectricImplosionCompressor::getTierOfBlock;
    }

    private static int getTierOfBlock(Block block, int meta) {
        if (block == null) {
            return -1;
        }
        if (block == GregTech_API.sBlockMetal5 && meta == 2) {
            return 1;
        }
        if (block == LudicrousBlocks.resource_block && meta == 1) {
            return 2;
        }
        if (block == GregTech_API.sBlockMetal9) {
            int n;
            switch (meta) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 5;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            return n;
        }
        return -1;
    }

    private void setBlockTier(int tier) {
        this.mBlockTier = tier;
    }

    private int getBlockTier() {
        return this.mBlockTier;
    }

    public IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Implosion Compressor").addInfo("Explosions are fun").addInfo("Controller block for the Electric Implosion Compressor").addInfo("Uses electricity instead of Explosives").addInfo("Can parallel up to 4^(Tier - 1)").addInfo("Tier is determined by containment block").addInfo("Valid blocks: Neutronium, Infinity, Transcendent Metal, Spacetime, Universium").addInfo("Minimum allowed energy hatch tier is one below recipe tier").addInfo("Supports " + BW_Tooltip_Reference.TT + " energy hatches").addSeparator().beginStructureBlock(3, 9, 3, false).addController("Front 3rd layer center").addCasingInfoMin("Solid Steel Machine Casing", 8, false).addStructureInfo("Casings can be replaced with Explosion Warning Signs").addOtherStructurePart("Transformer-Winding Blocks", "Outer layer 2,3,7,8").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Inner layer 2,3,7,8").addOtherStructurePart("Containment Blocks", "Layer 4,5,6").addMaintenanceHatch("Any bottom casing", new int[]{1}).addInputBus("Any bottom casing", new int[]{1}).addInputHatch("Any bottom casing", new int[]{1}).addOutputBus("Any bottom casing", new int[]{1}).addEnergyHatch("Bottom middle and/or top middle", new int[]{2}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.electricImplosionCompressorRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(GT_TileEntity_ElectricImplosionCompressor.this.getMaxInputEu()).setAmperage(1L);
            }
        }.setMaxParallelSupplier(() -> (int)Math.pow(4.0, Math.max(this.mBlockTier - 1, 0)));
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        long amperage = this.getMaxInputAmps();
        long voltage = this.getAverageInputVoltage();
        logic.setAvailableVoltage(amperage >= 4L ? voltage * 4L : voltage);
        logic.setAvailableAmperage(amperage >= 4L ? amperage / 4L : amperage);
    }

    private void updateChunkCoordinates() {
        this.chunkCoordinates.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                int[] abc = new int[]{x, -2, z + 1};
                int[] xyz = new int[]{0, 0, 0};
                this.getExtendedFacing().getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + this.getBaseMetaTileEntity().getXCoord();
                xyz[1] = xyz[1] + this.getBaseMetaTileEntity().getYCoord();
                xyz[2] = xyz[2] + this.getBaseMetaTileEntity().getZCoord();
                this.chunkCoordinates.add(new ChunkCoordinates(xyz[0], xyz[1], xyz[2]));
            }
        }
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.updateChunkCoordinates();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (pistonEnabled && aBaseMetaTileEntity.isActive() && aTick % 20L == 0L) {
            if (aBaseMetaTileEntity.isClientSide()) {
                this.animatePiston(aBaseMetaTileEntity);
            } else if (aBaseMetaTileEntity.hasMufflerUpgrade()) {
                MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(aBaseMetaTileEntity.getWorld(), (GT_Packet)new EICPacket(new Coords(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), true), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
            }
        }
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        super.setExtendedFacing(newExtendedFacing);
        this.updateChunkCoordinates();
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void stopMachine() {
        this.resetPiston(this.mBlockTier);
        super.stopMachine();
    }

    private void resetPiston(int tier) {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (!this.piston.booleanValue()) {
            List<Pair<Block, Integer>> tiers = GT_TileEntity_ElectricImplosionCompressor.getAllBlockTiers();
            Pair<Block, Integer> tieredBlock = tiers.get(Math.min(tier, tiers.size()) - 1);
            this.chunkCoordinates.forEach(c -> {
                if (aBaseMetaTileEntity.getWorld().func_147437_c(c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)tieredBlock.getKey(), ((Integer)tieredBlock.getValue()).intValue(), 3);
                }
            });
            this.piston = this.piston == false;
        }
    }

    private void activatePiston() {
        if (!pistonEnabled) {
            return;
        }
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        if (this.piston.booleanValue()) {
            this.chunkCoordinates.forEach(c -> aBaseMetaTileEntity.getWorld().func_147468_f(c.field_71574_a, c.field_71572_b, c.field_71573_c));
            this.piston = this.piston == false;
        }
    }

    private void animatePiston(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!aBaseMetaTileEntity.getWorld().field_72995_K) {
            return;
        }
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            GT_Utility.doSoundAtClient((SoundResource)sound, (int)10, (float)1.0f, (float)1.0f, (double)this.chunkCoordinates.get((int)0).field_71574_a, (double)this.chunkCoordinates.get((int)0).field_71572_b, (double)this.chunkCoordinates.get((int)0).field_71573_c);
        }
        this.spawnVisualPistonBlocks(aBaseMetaTileEntity.getWorld(), this.chunkCoordinates.get((int)2).field_71574_a, this.chunkCoordinates.get((int)2).field_71572_b, this.chunkCoordinates.get((int)2).field_71573_c, 10);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVisualPistonBlocks(World world, int x, int y, int z, int age) {
        BW_EICPistonVisualizer pistonVisualizer = new BW_EICPistonVisualizer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)pistonVisualizer);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("piston", this.piston.booleanValue());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("piston")) {
            this.piston = aNBT.func_74767_n("piston");
        }
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        int pistonTier = this.mBlockTier;
        this.mCasing = 0;
        int mMaxHatchTier = 0;
        this.setBlockTier(0);
        boolean isOK = this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0);
        List energyHatches = this.getExoticAndNormalEnergyHatchList();
        for (GT_MetaTileEntity_Hatch hatch : energyHatches) {
            mMaxHatchTier = Math.max(mMaxHatchTier, hatch.mTier);
        }
        boolean bl = isOK = isOK && this.mMaintenanceHatches.size() == 1 && energyHatches.size() >= 1;
        if (isOK) {
            this.activatePiston();
            return true;
        }
        this.resetPiston(pistonTier);
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ElectricImplosionCompressor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 6, 0, elementBudget, env, false, true);
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    public boolean supportsVoidProtection() {
        return true;
    }
}

