/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import java.awt.Color;
import net.minecraft.item.EnumRarity;

public class BioCultureLoader {
    public static final BioData BIO_DATA_BETA_LACMATASE = BioData.createAndRegisterBioData("beta-Lactamase", EnumRarity.uncommon, 10000, 0);
    private static final BioData BIO_DATA_YEAST = BioData.createAndRegisterBioData("Saccharomyces cerevisiae", EnumRarity.common);
    private static final BioDNA BIO_DNA_WHINE_YEAST = BioDNA.createAndRegisterBioDNA("Saccharomyces cerevisiae var bayanus", EnumRarity.uncommon);
    private static final BioDNA BIO_DNA_BEER_YEAST = BioDNA.createAndRegisterBioDNA("Saccharomyces cerevisiae var cerevisiae", EnumRarity.uncommon);
    private static final BioData eColiData = BioData.createAndRegisterBioData("Escherichia koli", EnumRarity.uncommon, 10000, 0);
    private static final BioDNA BIO_DNA_ANAEROBIC_OIL = BioDNA.createAndRegisterBioDNA("Pseudomonas Veronii", EnumRarity.uncommon);
    private static final BioData BIO_DATA_ANAEROBIC_OIL = BioData.createAndRegisterBioData("Pseudomonas Veronii", EnumRarity.uncommon, 5000, 1);
    public static BioCulture CommonYeast;
    public static BioCulture WhineYeast;
    public static BioCulture BeerYeast;
    public static BioCulture rottenFleshBacteria;
    public static BioCulture eColi;
    public static BioCulture anaerobicOil;
    public static BioCulture generalPurposeFermentingBacteria;

    public static void run() {
        CommonYeast = BioCulture.createAndRegisterBioCulture(new Color(255, 248, 200), "Saccharomyces cerevisiae", BioPlasmid.convertDataToPlasmid(BIO_DATA_YEAST), BioDNA.convertDataToDNA(BIO_DATA_YEAST), true);
        WhineYeast = BioCulture.createAndRegisterBioCulture(new Color(255, 248, 200), "Saccharomyces cerevisiae var bayanus", BioPlasmid.convertDataToPlasmid(BIO_DNA_WHINE_YEAST), BIO_DNA_WHINE_YEAST, EnumRarity.uncommon, true);
        BeerYeast = BioCulture.createAndRegisterBioCulture(new Color(255, 248, 200), "Saccharomyces cerevisiae var cerevisiae", BioPlasmid.convertDataToPlasmid(BIO_DNA_BEER_YEAST), BIO_DNA_BEER_YEAST, EnumRarity.uncommon, true);
        rottenFleshBacteria = BioCulture.createAndRegisterBioCulture(new Color(110, 40, 25), "Escherichia cadaver", BioPlasmid.convertDataToPlasmid(BIO_DATA_BETA_LACMATASE), BioDNA.convertDataToDNA(BIO_DATA_BETA_LACMATASE), false);
        eColi = BioCulture.createAndRegisterBioCulture(new Color(149, 132, 75), "Escherichia koli", BioPlasmid.convertDataToPlasmid(eColiData), BioDNA.convertDataToDNA(eColiData), true);
        anaerobicOil = BioCulture.createAndRegisterBioCulture(new Color(0, 0, 0), "Pseudomonas Veronii", BioPlasmid.convertDataToPlasmid(BIO_DNA_ANAEROBIC_OIL), BioDNA.convertDataToDNA(BIO_DATA_ANAEROBIC_OIL), true);
        generalPurposeFermentingBacteria = BioCulture.createAndRegisterBioCulture(new Color(127, 69, 26), "Saccharomyces escherichia", CommonYeast.getPlasmid(), eColi.getdDNA(), EnumRarity.epic, true);
        CommonYeast.setLocalisedName("Common Yeast");
        WhineYeast.setLocalisedName("Whine Yeast");
        BeerYeast.setLocalisedName("Beer Yeast");
        rottenFleshBacteria.setLocalisedName("Rotten Flesh Bacteria");
        eColi.setLocalisedName("eColi Bacteria");
        anaerobicOil.setLocalisedName("Anaerobic Oil Bacteria");
        generalPurposeFermentingBacteria.setLocalisedName("General Purpose Fermenting Bacteria");
    }
}

