/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticgreg;

import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_Layer_Space;
import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_SmallPieces_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModContainer;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_Layer_Space;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_SmallOre_Space;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.GT_Worldgen_GT_Ore_SmallPieces;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VoidMinerUtility {
    public static final FluidStack[] NOBLE_GASSES = new FluidStack[]{WerkstoffLoader.Neon.getFluidOrGas(1), WerkstoffLoader.Krypton.getFluidOrGas(1), WerkstoffLoader.Xenon.getFluidOrGas(1), WerkstoffLoader.Oganesson.getFluidOrGas(1)};
    public static final int[] NOBEL_GASSES_MULTIPLIER = new int[]{4, 8, 16, 64};
    public static final Map<Integer, DropMap> dropMapsByDimId = new HashMap<Integer, DropMap>();
    public static final Map<String, DropMap> dropMapsByChunkProviderName = new HashMap<String, DropMap>();
    public static final Map<Integer, DropMap> extraDropsDimMap = new HashMap<Integer, DropMap>();

    public static void generateDropMaps() {
        dropMapsByDimId.put(-1, VoidMinerUtility.getDropMapVanilla(-1));
        dropMapsByDimId.put(0, VoidMinerUtility.getDropMapVanilla(0));
        dropMapsByDimId.put(1, VoidMinerUtility.getDropMapVanilla(1));
        dropMapsByDimId.put(7, VoidMinerUtility.getDropMapVanilla(7));
        dropMapsByDimId.put(ConfigHandler.ross128BID, VoidMinerUtility.getDropMapRoss(ConfigHandler.ross128BID));
        dropMapsByDimId.put(ConfigHandler.ross128BAID, VoidMinerUtility.getDropMapRoss(ConfigHandler.ross128BAID));
        for (ModContainer modContainer : GalacticGregRegistry.getModContainers()) {
            for (ModDimensionDef dimDef : modContainer.getDimensionList()) {
                dropMapsByChunkProviderName.put(dimDef.getChunkProviderName(), VoidMinerUtility.getDropMapSpace(dimDef));
            }
        }
    }

    private static DropMap getDropMapVanilla(int dimId) {
        DropMap dropMap = new DropMap();
        Predicate<GT_Worldgen_GT_Ore_Layer> oreLayerPredicate = VoidMinerUtility.makeOreLayerPredicate(dimId);
        GT_Worldgen_GT_Ore_Layer.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && oreLayerPredicate.test((GT_Worldgen_GT_Ore_Layer)gt_worldgen)).forEach(element -> {
            dropMap.addDrop(element.mPrimaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSecondaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSporadicMeta, (float)element.mWeight / 8.0f, false);
            dropMap.addDrop(element.mBetweenMeta, (float)element.mWeight / 8.0f, false);
        });
        Predicate<GT_Worldgen_GT_Ore_SmallPieces> smallOresPredicate = VoidMinerUtility.makeSmallOresPredicate(dimId);
        GT_Worldgen_GT_Ore_SmallPieces.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && smallOresPredicate.test((GT_Worldgen_GT_Ore_SmallPieces)gt_worldgen)).forEach(element -> dropMap.addDrop(element.mMeta, (float)element.mAmount, false));
        return dropMap;
    }

    private static Predicate<GT_Worldgen_GT_Ore_Layer> makeOreLayerPredicate(int dimensionId) {
        Predicate<GT_Worldgen_GT_Ore_Layer> predicate;
        switch (dimensionId) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd || gt_worldgen.mEndAsteroid;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.isGenerationAllowed("Twilight Forest", 0, 7);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private static Predicate<GT_Worldgen_GT_Ore_SmallPieces> makeSmallOresPredicate(int dimensionId) {
        Predicate<GT_Worldgen_GT_Ore_SmallPieces> predicate;
        switch (dimensionId) {
            case -1: {
                predicate = gt_worldgen -> gt_worldgen.mNether;
                break;
            }
            case 0: {
                predicate = gt_worldgen -> gt_worldgen.mOverworld;
                break;
            }
            case 1: {
                predicate = gt_worldgen -> gt_worldgen.mEnd;
                break;
            }
            case 7: {
                predicate = gt_worldgen -> gt_worldgen.isGenerationAllowed("Twilight Forest", 0, 7);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return predicate;
    }

    private static DropMap getDropMapRoss(int aID) {
        DropMap dropMap = new DropMap();
        for (BW_OreLayer oreLayer : BW_OreLayer.sList) {
            if (!oreLayer.mEnabled || !oreLayer.isGenerationAllowed("", aID, 0)) continue;
            List<ItemStack> data = oreLayer.getStacks();
            dropMap.addDrop(data.get(0), oreLayer.mWeight);
            dropMap.addDrop(data.get(1), oreLayer.mWeight);
            dropMap.addDrop(data.get(2), (float)oreLayer.mWeight / 8.0f);
            dropMap.addDrop(data.get(3), (float)oreLayer.mWeight / 8.0f);
        }
        return dropMap;
    }

    private static DropMap getDropMapSpace(ModDimensionDef finalDef) {
        DropMap dropMap = new DropMap();
        GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> {
            GT_Worldgen_GT_Ore_Layer_Space oreLayerSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_Layer_Space && (oreLayerSpace = (GT_Worldgen_GT_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (GT_Worldgen_GT_Ore_Layer_Space)gt_worldgen).forEach(element -> {
            dropMap.addDrop(element.mPrimaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSecondaryMeta, (float)element.mWeight, false);
            dropMap.addDrop(element.mSporadicMeta, (float)element.mWeight / 8.0f, false);
            dropMap.addDrop(element.mBetweenMeta, (float)element.mWeight / 8.0f, false);
        });
        GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> {
            GT_Worldgen_GT_Ore_SmallPieces_Space oreSmallPiecesSpace;
            return gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_SmallPieces_Space && (oreSmallPiecesSpace = (GT_Worldgen_GT_Ore_SmallPieces_Space)gt_worldgen).isEnabledForDim(finalDef);
        }).map(gt_worldgen -> (GT_Worldgen_GT_Ore_SmallPieces_Space)gt_worldgen).forEach(element -> dropMap.addDrop(element.mMeta, (float)element.mAmount, false));
        try {
            GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> {
                BW_Worldgen_Ore_Layer_Space oreLayerSpace;
                return gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_Layer_Space && (oreLayerSpace = (BW_Worldgen_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef);
            }).map(gt_worldgen -> (BW_Worldgen_Ore_Layer_Space)gt_worldgen).forEach(oreLayer -> {
                List data = oreLayer.getStacks();
                dropMap.addDrop((ItemStack)data.get(0), oreLayer.mWeight);
                dropMap.addDrop((ItemStack)data.get(1), oreLayer.mWeight);
                dropMap.addDrop((ItemStack)data.get(2), (float)oreLayer.mWeight / 8.0f);
                dropMap.addDrop((ItemStack)data.get(3), (float)oreLayer.mWeight / 8.0f);
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> {
                BW_Worldgen_Ore_SmallOre_Space smallOreSpace;
                return gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_SmallOre_Space && (smallOreSpace = (BW_Worldgen_Ore_SmallOre_Space)gt_worldgen).isEnabledForDim(finalDef);
            }).map(gt_worldgen -> (BW_Worldgen_Ore_SmallOre_Space)gt_worldgen).forEach(element -> dropMap.addDrop(element.mPrimaryMeta, (float)element.mDensity, element.bwOres != 0));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dropMap;
    }

    public static void addBlockToDimensionList(int dimId, Block block, int meta, float weight) {
        if (!extraDropsDimMap.containsKey(dimId)) {
            extraDropsDimMap.put(dimId, new DropMap());
        }
        extraDropsDimMap.get(dimId).addDrop(block, meta, weight);
    }

    public static void addMaterialToDimensionList(int DimensionID, ISubTagContainer Material2, float weight) {
        if (Material2 instanceof Materials) {
            Materials gtMaterial = (Materials)Material2;
            VoidMinerUtility.addBlockToDimensionList(DimensionID, GregTech_API.sBlockOres1, gtMaterial.mMetaItemSubID, weight);
        } else if (Material2 instanceof Werkstoff) {
            Werkstoff werkstoff = (Werkstoff)Material2;
            VoidMinerUtility.addBlockToDimensionList(DimensionID, WerkstoffLoader.BWOres, werkstoff.getmID(), weight);
        }
    }

    static {
        VoidMinerUtility.addMaterialToDimensionList(0, (ISubTagContainer)Materials.Tellurium, 8.0f);
    }

    public static class DropMap {
        private float totalWeight = 0.0f;
        private final Map<GT_Utility.ItemId, Float> internalMap = new HashMap<GT_Utility.ItemId, Float>();

        public void addDrop(int meta, float weight, boolean isBWOres) {
            if (isBWOres) {
                this.addDrop(WerkstoffLoader.BWOres, meta, weight);
            } else {
                this.addDrop(GregTech_API.sBlockOres1, meta, weight);
            }
        }

        public void addDrop(Block block, int meta, float weight) {
            if (ConfigHandler.voidMinerBlacklist.contains(String.format("%s:%d", GameRegistry.findUniqueIdentifierFor((Block)block).toString(), meta))) {
                return;
            }
            Item item = Item.func_150898_a((Block)block);
            this.addDrop(item, meta, weight);
        }

        public void addDrop(ItemStack itemStack, float weight) {
            Item item = itemStack.func_77973_b();
            int meta = Items.field_151008_G.getDamage(itemStack);
            if (ConfigHandler.voidMinerBlacklist.contains(String.format("%s:%d", GameRegistry.findUniqueIdentifierFor((Block)Block.func_149634_a((Item)item)).toString(), meta))) {
                return;
            }
            this.addDrop(item, meta, weight);
        }

        private void addDrop(Item item, int meta, float weight) {
            GT_Utility.ItemId ore = GT_Utility.ItemId.createNoCopy((Item)item, (int)meta, null);
            this.internalMap.merge(ore, Float.valueOf(weight), Float::sum);
            this.totalWeight += weight;
        }

        public float getTotalWeight() {
            return this.totalWeight;
        }

        public Map<GT_Utility.ItemId, Float> getInternalMap() {
            return this.internalMap;
        }
    }
}

