/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.API;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class BorosilicateGlass {
    private static Block block;
    private static List<Pair<Block, Integer>> representatives;

    private static Block getGlassBlock() {
        if (block == null) {
            block = GameRegistry.findBlock((String)"bartworks", (String)"BW_GlasBlocks");
        }
        return block;
    }

    private static List<Pair<Block, Integer>> getRepresentatives() {
        if (representatives == null) {
            ArrayList<Pair<Block, Integer>> ret = new ArrayList<Pair<Block, Integer>>();
            Block block = BorosilicateGlass.getGlassBlock();
            ret.add(Pair.of((Object)block, (Object)0));
            ret.add(Pair.of((Object)block, (Object)1));
            ret.add(Pair.of((Object)block, (Object)2));
            ret.add(Pair.of((Object)block, (Object)3));
            ret.add(Pair.of((Object)block, (Object)4));
            ret.add(Pair.of((Object)block, (Object)5));
            ret.add(Pair.of((Object)block, (Object)13));
            ret.add(Pair.of((Object)block, (Object)14));
            representatives = ret;
        }
        return representatives;
    }

    private static byte checkWithinBound(byte val, byte lo, byte hi) {
        return val > hi || val < lo ? (byte)-1 : val;
    }

    public static boolean hasGlassInTier(int tier) {
        return tier >= 3 && tier <= 10;
    }

    public static <T> IStructureElement<T> ofBoroGlass(int tier) {
        if (!BorosilicateGlass.hasGlassInTier(tier)) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.lazy(t -> {
            Pair<Block, Integer> pair = BorosilicateGlass.getRepresentatives().get(tier - 3);
            return StructureUtility.ofBlockAdder((t1, block1, meta) -> BorosilicateGlass.getTier(block1, meta) == tier, (Block)((Block)pair.getKey()), (int)((Integer)pair.getValue()));
        });
    }

    public static <T> IStructureElement<T> ofBoroGlassAnyTier() {
        return StructureUtility.lazy(t -> StructureUtility.ofBlockAnyMeta((Block)BorosilicateGlass.getGlassBlock()));
    }

    public static <T> IStructureElement<T> ofBoroGlass(byte initialValue, BiConsumer<T, Byte> setter, Function<T, Byte> getter) {
        return StructureUtility.lazy(t -> StructureUtility.ofBlocksTiered(BorosilicateGlass::getTier, BorosilicateGlass.getRepresentatives(), (Object)initialValue, (BiConsumer)setter, (Function)getter));
    }

    public static <T> IStructureElement<T> ofBoroGlass(byte initialValue, byte minTier, byte maxTier, BiConsumer<T, Byte> setter, Function<T, Byte> getter) {
        if (minTier > maxTier || minTier < 0) {
            throw new IllegalArgumentException();
        }
        return StructureUtility.lazy(t -> StructureUtility.ofBlocksTiered((block1, meta) -> BorosilicateGlass.checkWithinBound(BorosilicateGlass.getTier(block1, meta), minTier, maxTier), BorosilicateGlass.getRepresentatives().stream().skip(Math.max(minTier - 3, 0)).limit(maxTier - minTier + 1).collect(Collectors.toList()), (Object)initialValue, (BiConsumer)setter, (Function)getter));
    }

    public static byte getTier(Block block, int meta) {
        byte ret;
        switch (meta) {
            case 1: {
                ret = 4;
                break;
            }
            case 2: 
            case 12: {
                ret = 5;
                break;
            }
            case 3: {
                ret = 6;
                break;
            }
            case 4: {
                ret = 7;
                break;
            }
            case 5: {
                ret = 8;
                break;
            }
            case 13: {
                ret = 9;
                break;
            }
            case 14: {
                ret = 10;
                break;
            }
            default: {
                ret = 3;
            }
        }
        return block == BorosilicateGlass.getGlassBlock() ? ret : (byte)-1;
    }
}

