/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class GT_TileEntity_CircuitAssemblyLine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_CircuitAssemblyLine> {
    private static final IStructureDefinition<GT_TileEntity_CircuitAssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{"~", "G", "G"}, {"g", "l", "g"}, {"b", "i", "b"}})).addShape("next", StructureUtility.transpose((String[][])new String[][]{{"G", "G", "G"}, {"g", "l", "g"}, {"b", "I", "b"}})).addElement(Character.valueOf('G'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)16, (int)1), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)10)})).addElement(Character.valueOf('g'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockAnyMeta((Block)GameRegistry.findBlock((String)"IC2", (String)"blockAlloyGlass")), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)1), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)2), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)3), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)4), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)5), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)12), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)13), StructureUtility.ofBlock((Block)ItemRegistry.bw_realglas, (int)14)})).addElement(Character.valueOf('l'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)5)).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)16, (int)2), GT_StructureUtility.ofHatchAdder(GT_TileEntity_CircuitAssemblyLine::addInputHatchToMachineList, (int)16, (int)2), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)})).addElement(Character.valueOf('i'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_TileEntity_CircuitAssemblyLine::addInputToMachineList, (int)16, (int)3)).addElement(Character.valueOf('I'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_TileEntity_CircuitAssemblyLine::addInputToMachineList, (int)16, (int)4), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)16, (int)4)})).build();
    private NBTTagCompound type = new NBTTagCompound();
    private GT_Recipe bufferedRecipe;
    private final Collection<GT_Recipe> GT_RECIPE_COLLECTION = new HashSet<GT_Recipe>();
    private static final String[] DESCRIPTION = new String[]{"Circuit Assembly Line", "Size(WxHxD): (2-7)x3x3, variable length", "Bottom: Steel Machine Casing(or 1x Maintenance or Input Hatch),", "Input Bus (Last Output Bus), Steel Machine Casing", "Middle: EV+ Tier Glass, Assembling Line Casing, EV+ Tier Glass", "Top: Grate Machine Casing (or Controller or 1x Energy Hatch)", "Up to 7 repeating slices, last is Output Bus", "Imprint this machine with a Circuit Imprint,", "by putting the imprint in the controller.", "Every Circuit Assembly Line can only be imprinted ONCE.", BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()};
    private String[] infoDataBuffer;
    private static final String[] description = new String[]{StatCollector.func_74838_a((String)"BW.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"BW.tile.CircuitAssemblyLine.hint.0"), StatCollector.func_74838_a((String)"BW.tile.CircuitAssemblyLine.hint.1"), StatCollector.func_74838_a((String)"BW.tile.CircuitAssemblyLine.hint.2"), StatCollector.func_74838_a((String)"BW.tile.CircuitAssemblyLine.hint.3")};

    public IStructureDefinition<GT_TileEntity_CircuitAssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        return new GT_Multiblock_Tooltip_Builder();
    }

    public String getTypeForDisplay() {
        if (this.type.equals((Object)new NBTTagCompound())) {
            return "";
        }
        return GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(this.type)));
    }

    public GT_TileEntity_CircuitAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_CircuitAssemblyLine(String aName) {
        super(aName);
    }

    private boolean imprintMachine(ItemStack itemStack) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            return true;
        }
        if (!GT_Utility.isStackValid((Object)itemStack)) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof BW_Meta_Items.BW_GT_MetaGenCircuits && itemStack.func_77960_j() == 0 && itemStack.func_77978_p() != null && this.type.equals((Object)new NBTTagCompound())) {
            this.type = itemStack.func_77978_p();
            this.mInventory[1] = null;
            this.getBaseMetaTileEntity().issueBlockUpdate();
            return true;
        }
        return false;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.type = aNBT.func_74775_l("Type");
        super.loadNBTData(aNBT);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a("Type", (NBTBase)this.type);
        }
        super.saveNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        if (!this.type.equals((Object)new NBTTagCompound())) {
            aNBT.func_74782_a("Type", (NBTBase)this.type);
        }
        super.saveNBTData(aNBT);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (this.type.equals((Object)new NBTTagCompound()) && !this.imprintMachine(itemStack)) {
            return false;
        }
        if (this.bufferedRecipe != null && this.bufferedRecipe.isRecipeInputEqual(true, false, BW_Util.getFluidsFromInputHatches((GT_MetaTileEntity_MultiBlockBase)this), this.getStoredInputs().toArray(new ItemStack[0]))) {
            this.setRecipeStats();
            return true;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)this.type);
        if (stack == null) {
            return false;
        }
        if (this.GT_RECIPE_COLLECTION.isEmpty()) {
            for (GT_Recipe recipe : BWRecipes.instance.getMappingsFor((byte)3).mRecipeList) {
                if (!GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[0], (ItemStack)stack, (boolean)true)) continue;
                this.GT_RECIPE_COLLECTION.add(recipe);
            }
        }
        for (GT_Recipe recipe : this.GT_RECIPE_COLLECTION) {
            if (!recipe.isRecipeInputEqual(true, false, BW_Util.getFluidsFromInputHatches((GT_MetaTileEntity_MultiBlockBase)this), this.getStoredInputs().toArray(new ItemStack[0]))) continue;
            this.bufferedRecipe = recipe;
            this.setRecipeStats();
            return true;
        }
        return false;
    }

    private void setRecipeStats() {
        this.calculatePerfectOverclockedNessMulti(this.bufferedRecipe.mEUt, this.bufferedRecipe.mDuration, 1, this.getMaxInputVoltage());
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputItems = this.bufferedRecipe.mOutputs;
        this.mOutputFluids = this.bufferedRecipe.mFluidOutputs;
        this.sendLoopStart((byte)20);
        this.updateSlots();
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        block0: for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_TileEntity_CircuitAssemblyLine.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
                continue block0;
            }
        }
        return rList;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    private boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_CircuitAssemblyLine(this.mName);
    }

    public String[] getDescription() {
        return DESCRIPTION;
    }

    public String[] getInfoData() {
        if (this.infoDataBuffer != null) {
            return this.infoDataBuffer;
        }
        String[] oldInfo = super.getInfoData();
        this.infoDataBuffer = new String[oldInfo.length + 1];
        System.arraycopy(oldInfo, 0, this.infoDataBuffer, 0, oldInfo.length);
        this.infoDataBuffer[oldInfo.length] = "Imprinted with: " + GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)CircuitImprintLoader.getStackFromTag(this.type)));
        return this.infoDataBuffer;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.getCasingTextureForId((int)16);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = TextureFactory.of((ITexture[])new ITexture[]{aActive ? TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW}).glow().build()}) : TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW}).glow().build()})});
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.getCasingTextureForId((int)16);
        }
        return iTextureArray;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece("first", 0, 0, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 7; ++i) {
            if (!this.checkPiece("next", leftToRight ? -i : i, 0, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return this.mEnergyHatches.size() == 1 && this.mMaintenanceHatches.size() == 1;
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("first", stackSize, hintsOnly, 0, 0, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 7);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece("next", stackSize, hintsOnly, -i, 0, 0);
        }
    }
}

