/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TileEntity_ElectricImplosionCompressor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_ElectricImplosionCompressor> {
    public static GT_Recipe.GT_Recipe_Map eicMap;
    private Boolean piston = true;
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> STRUCTURE_DEFINITION;

    public GT_TileEntity_ElectricImplosionCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ElectricImplosionCompressor(String aName) {
        super(aName);
    }

    public IStructureDefinition<GT_TileEntity_ElectricImplosionCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Implosion Compressor").addInfo("Explosions are fun").addInfo("Controller block for the Electric Implosion Compressor").addInfo("Uses electricity instead of Explosives").addSeparator().beginStructureBlock(3, 9, 3, false).addController("Front 3rd layer center").addCasingInfo("Solid Steel Machine Casing", 8).addStructureInfo("Casings can be replaced with Explosion Warning Signs").addOtherStructurePart("Transformer-Winding Blocks", "Outer layer 2,3,7,8").addOtherStructurePart("Nickel-Zinc-Ferrite Blocks", "Inner layer 2,3,7,8").addOtherStructurePart("Neutronium Blocks", "Layer 4,5,6").addMaintenanceHatch("Any bottom casing", new int[]{1}).addInputBus("Any bottom casing", new int[]{1}).addOutputBus("Any bottom casing", new int[]{1}).addEnergyHatch("Bottom and top middle", new int[]{2}).toolTipFinisher("Bartworks");
        return tt;
    }

    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        if (((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getEUVar() <= 0L || ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(1)).getEUVar() <= 0L) {
            return false;
        }
        ArrayList tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                if (((ItemStack)tInputList.get((int)i)).field_77994_a < ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block0;
                }
                tInputList.remove(j--);
                tInputList_sS = tInputList.size();
            }
        }
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
        if (tInputList.size() > 0 && (tRecipe = eicMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, tInputs)) != null && tRecipe.isRecipeInputEqual(true, null, tInputs)) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mEUt = -tRecipe.mEUt;
            this.mMaxProgresstime = Math.max(1, tRecipe.mDuration);
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
            this.sendLoopStart((byte)20);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        GT_MetaTileEntity_Hatch_Energy h1 = (GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0);
        GT_MetaTileEntity_Hatch_Energy h2 = (GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(1);
        if (!GT_TileEntity_ElectricImplosionCompressor.isValidMetaTileEntity((MetaTileEntity)h1) || !GT_TileEntity_ElectricImplosionCompressor.isValidMetaTileEntity((MetaTileEntity)h2)) {
            return false;
        }
        return h1.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU / 2L, false) && h2.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU / 2L, false);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mRuntime % 10 == 0) {
            this.togglePiston();
        }
        return super.onRunningTick(aStack);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public void stopMachine() {
        this.resetPiston();
        super.stopMachine();
    }

    private void resetPiston() {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (!this.piston.booleanValue() && this.mMachine) {
            int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
            int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
            int aX = this.getBaseMetaTileEntity().getXCoord();
            short aY = this.getBaseMetaTileEntity().getYCoord();
            int aZ = this.getBaseMetaTileEntity().getZCoord();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.getBaseMetaTileEntity().getWorld().func_147465_d(xDir + aX + x, aY + 2, zDir + aZ + z, GregTech_API.sBlockMetal5, 2, 3);
                }
            }
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
            this.piston = this.piston == false;
        }
    }

    private void togglePiston() {
        if (this.getBaseMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        int aX = this.getBaseMetaTileEntity().getXCoord();
        short aY = this.getBaseMetaTileEntity().getYCoord();
        int aZ = this.getBaseMetaTileEntity().getZCoord();
        boolean hax = false;
        if (this.piston.booleanValue()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    if (this.getBaseMetaTileEntity().getBlock(xDir + aX + x, aY + 2, zDir + aZ + z) != GregTech_API.sBlockMetal5 && this.getBaseMetaTileEntity().getMetaID(xDir + aX + x, aY + 2, zDir + aZ + z) != 2) {
                        hax = true;
                    }
                    this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + aX + x, aY + 2, zDir + aZ + z);
                }
            }
        } else {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.getBaseMetaTileEntity().getWorld().func_147465_d(xDir + aX + x, aY + 2, zDir + aZ + z, GregTech_API.sBlockMetal5, 2, 3);
                }
            }
        }
        GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(5)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        this.piston = this.piston == false;
        if (hax) {
            this.explodeMultiblock();
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("piston", this.piston.booleanValue());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.piston = aNBT.func_74767_n("piston");
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 2;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ElectricImplosionCompressor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            ITexture[] iTextureArray;
            if (aActive) {
                ITexture[] iTextureArray2 = new ITexture[3];
                iTextureArray2[0] = Textures.BlockIcons.casingTexturePages[0][16];
                iTextureArray2[1] = TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE}).extFacing().build();
                iTextureArray = iTextureArray2;
                iTextureArray2[2] = TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW}).extFacing().glow().build();
            } else {
                ITexture[] iTextureArray3 = new ITexture[3];
                iTextureArray3[0] = Textures.BlockIcons.casingTexturePages[0][16];
                iTextureArray3[1] = TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR}).extFacing().build();
                iTextureArray = iTextureArray3;
                iTextureArray3[2] = TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW}).extFacing().glow().build();
            }
            return iTextureArray;
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 6, 0);
    }

    static {
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"ccc", "cec", "ccc"}, {"ttt", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"nnn", "nnn", "nnn"}, {"nNn", "NNN", "nNn"}, {"nnn", "nnn", "nnn"}, {"t~t", "tft", "ttt"}, {"ttt", "tft", "ttt"}, {"CCC", "CeC", "CCC"}})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4)})).addElement(Character.valueOf('t'), StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)1)).addElement(Character.valueOf('f'), StructureUtility.ofBlock((Block)ItemRegistry.BW_BLOCKS[2], (int)0)).addElement(Character.valueOf('n'), StructureUtility.ofBlock((Block)GregTech_API.sBlockMetal5, (int)2)).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)16, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)16, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)16, (int)1), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)4)})).addElement(Character.valueOf('e'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)16, (int)2)).addElement(Character.valueOf('N'), (IStructureElement)new IStructureElement<GT_TileEntity_ElectricImplosionCompressor>(){

            public boolean check(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z) {
                if (!te.piston.booleanValue() && !world.func_147437_c(x, y, z)) {
                    return false;
                }
                return te.piston == false || world.func_147439_a(x, y, z) == GregTech_API.sBlockMetal5 && world.func_72805_g(x, y, z) == 2;
            }

            public boolean spawnHint(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
                if (te.piston.booleanValue()) {
                    StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTech_API.sBlockMetal5, (int)2);
                }
                return true;
            }

            public boolean placeBlock(GT_TileEntity_ElectricImplosionCompressor te, World world, int x, int y, int z, ItemStack itemStack) {
                if (te.piston.booleanValue()) {
                    world.func_147465_d(x, y, z, GregTech_API.sBlockMetal5, 2, 3);
                } else {
                    world.func_147468_f(x, y, z);
                }
                return true;
            }
        }).build();
    }
}

