/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.tiered.LowPowerLaser;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_AbstractMultiFurnace;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_ElectricBlastFurnace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaBlastFurnace
extends GT_MetaTileEntity_ElectricBlastFurnace
implements TecTechEnabledMulti {
    private static final int CASING_INDEX = 11;
    private static final IStructureDefinition<GT_TileEntity_MegaBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", GT_TileEntity_MegaBlastFurnace.createShape()).addElement(Character.valueOf('t'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_ElectricBlastFurnace::addOutputHatchToTopList, (int)11, (int)1, (Block)GregTech_API.sBlockCasings1, (int)11)).addElement(Character.valueOf('m'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMufflerToMachineList, (int)11, (int)2)).addElement(Character.valueOf('C'), GT_StructureUtility.ofCoil(GT_MetaTileEntity_AbstractMultiFurnace::setCoilLevel, GT_MetaTileEntity_AbstractMultiFurnace::getCoilLevel)).addElement(Character.valueOf('g'), BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier)).addElement(Character.valueOf('b'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_AbstractMultiFurnace::addBottomHatch, (int)11, (int)3, (Block)GregTech_API.sBlockCasings1, (int)11)).build();
    private int mHeatingCapacity;
    private byte glasTier;
    private int polPtick = ConfigHandler.basePollutionMBFSecond / 20 * ConfigHandler.megaMachinesMax;
    public ArrayList<Object> TTTunnels = new ArrayList();
    public ArrayList<Object> TTMultiAmp = new ArrayList();
    private byte circuitMode = 0;
    private long lEUt = 0L;

    private static String[][] createShape() {
        int i;
        String[][] raw = new String[20][];
        raw[0] = new String[15];
        String topCasing = "ttttttttttttttt";
        String mufflerLine = "tmmmmmmmmmmmmmt";
        raw[0][0] = topCasing;
        for (int i2 = 1; i2 < 14; ++i2) {
            raw[0][i2] = mufflerLine;
        }
        raw[0][14] = topCasing;
        raw[1] = new String[15];
        String allGlass = "ggggggggggggggg";
        String allCoil = "gCCCCCCCCCCCCCg";
        String middleLine = "gC-----------Cg";
        raw[1][0] = allGlass;
        raw[1][1] = allCoil;
        raw[1][13] = allCoil;
        raw[1][14] = allGlass;
        for (i = 2; i < 13; ++i) {
            raw[1][i] = middleLine;
        }
        for (i = 2; i < 19; ++i) {
            raw[i] = raw[1];
        }
        String bottomCasing = "bbbbbbbbbbbbbbb";
        raw[19] = new String[15];
        for (int i3 = 0; i3 < 15; ++i3) {
            raw[19][i3] = bottomCasing;
        }
        raw[17] = Arrays.copyOf(raw[17], raw[17].length);
        raw[17][0] = "ggggggg~ggggggg";
        return StructureUtility.transpose((String[][])raw);
    }

    public GT_TileEntity_MegaBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaBlastFurnace(String aName) {
        super(aName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Blast Furnace").addInfo("Controller block for the Mega Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required reduces power consumption by 5% (multiplicatively)").addInfo("Each 1800K over the min. Heat required grants one perfect overclock").addInfo("For each perfect overclock the EBF will reduce recipe time 4 times (instead of 2) (100% efficiency)").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(15, 20, 15, true).addController("3rd layer center").addCasingInfo("Heat Proof Machine Casing", 0).addOtherStructurePart("Heating Coils", "Inner 13x18x13 (Hollow)").addOtherStructurePart("Borosilicate Glass", "Outer 15x18x15").addStructureInfo("The glass tier limits the Energy Input tier").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Top middle 13x13").addInputBus("Any bottom layer casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("Gasses, Any top layer casing").addStructureInfo("Recovery amount scales with Muffler Hatch tier").addOutputHatch("Platline fluids, Any bottom layer casing").addStructureHint("This Mega Multiblock is too big to have its structure hologram displayed fully.").toolTipFinisher(BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get());
        return tt;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.circuitMode = aNBT.func_74771_c("circuitMode");
        this.glasTier = aNBT.func_74771_c("glasTier");
        this.lEUt = aNBT.func_74763_f("lEUt");
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            this.addEnergyOutput(this.lEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.lEUt < 0L && !this.drainEnergyInput(-this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    public void stopMachine() {
        this.mOutputItems = null;
        this.mEUt = 0;
        this.lEUt = 0L;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.circuitMode = (byte)(this.circuitMode - 1);
            if (this.circuitMode < 0) {
                this.circuitMode = (byte)24;
            }
        } else {
            this.circuitMode = (byte)(this.circuitMode + 1);
            if (this.circuitMode > 24) {
                this.circuitMode = 0;
            }
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.circuitMode > 0 ? "MEBF will prioritise circuit: " + this.circuitMode : "Circuit prioritisation disabled."));
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("glasTier", this.glasTier);
        aNBT.func_74774_a("circuitMode", this.circuitMode);
        aNBT.func_74772_a("lEUt", this.lEUt);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (LoaderReference.tectech) {
            return TecTechUtils.addEnergyInputToMachineList(this, aTileEntity, aBaseCasingIndex);
        }
        return super.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    protected byte calculateOverclockednessEBF(long aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.lEUt = 0x7FFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.lEUt = (int)(aEUt >> 2);
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime <= 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > maxInputVoltage) {
                xEUt >>= 2;
                this.mMaxProgresstime <<= 1;
                timesOverclocked = (byte)(timesOverclocked - 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.lEUt = 0x7FFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.lEUt = (int)xEUt;
                if (this.lEUt == 0L) {
                    this.lEUt = 1L;
                }
                if (this.mMaxProgresstime <= 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler e : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)e)) continue;
            mPollutionReduction = Math.max(e.calculatePollutionReduction(this.mPollution), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        if (LoaderReference.tectech) {
            long[] info = this.getCurrentInfoData();
            storedEnergy = info[0];
            maxEnergy = info[1];
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)(-this.lEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public boolean drainEnergyInput(long aEU) {
        if (LoaderReference.tectech) {
            return TecTechUtils.drainEnergyMEBFTecTech(this, aEU);
        }
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }

    public long getMaxInputVoltage() {
        if (LoaderReference.tectech) {
            return TecTechUtils.getMaxInputVoltage(this);
        }
        return super.getMaxInputVoltage();
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return this.polPtick;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_MegaBlastFurnace(this.mName);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        GT_Recipe tRecipe;
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        if (this.circuitMode > 0 && Arrays.stream(tInputs).anyMatch(e -> GT_Utility.areStacksEqual((ItemStack)e, (ItemStack)GT_Utility.getIntegratedCircuit((int)this.circuitMode), (boolean)true))) {
            List<ItemStack> modInputs = Arrays.stream(tInputs).filter(Objects::nonNull).filter(e -> !e.func_77973_b().equals(GT_Utility.getIntegratedCircuit((int)this.circuitMode).func_77973_b())).collect(Collectors.toList());
            modInputs.add(GT_Utility.getIntegratedCircuit((int)this.circuitMode));
            tInputs = modInputs.toArray(new ItemStack[0]);
        }
        if ((tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs)) == null) {
            if (this.circuitMode == 0) {
                return false;
            }
            tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
            tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe == null) {
                return false;
            }
        }
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        boolean found_Recipe = false;
        int processed = 0;
        int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
        long precutRecipeVoltage = (long)((double)tRecipe.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
        long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / precutRecipeVoltage);
        if (this.mHeatingCapacity >= tRecipe.mSpecialValue) {
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tFluids, tInputs, (int)tMaxPara);
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = tCurrentPara;
            found_Recipe = true;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = precutRecipeVoltage * (long)processed;
            byte overclockCount = this.calculateOverclockednessEBF(actualEUT, tRecipe.mDuration, nominalV);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            if (tHeatCapacityDivTiers > 0) {
                this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
                if (this.mMaxProgresstime < 1) {
                    this.mMaxProgresstime = 1;
                }
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.polPtick = ConfigHandler.basePollutionMBFSecond / 20 * processed;
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            this.updateSlots();
            return true;
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public IStructureDefinition<GT_MetaTileEntity_ElectricBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 7, 17, 0);
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        this.mHeatingCapacity = 0;
        this.glasTier = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mPollutionOutputHatches.clear();
        if (!this.checkPiece("main", 7, 17, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (LoaderReference.tectech && this.glasTier < 8 && (!this.areLazorsLowPowa() || this.areThingsNotProperlyTiered(this.getTecTechEnergyTunnels()) || this.areThingsNotProperlyTiered(this.getTecTechEnergyMultis()))) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (GT_Utility.getTier((long)this.getMaxInputVoltage()) - 2);
        return true;
    }

    @Optional.Method(modid="tectech")
    private boolean areThingsNotProperlyTiered(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (((GT_MetaTileEntity_TieredMachineBlock)tecTechEnergyMulti).mTier <= this.glasTier) continue;
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="tectech")
    private boolean areLazorsLowPowa() {
        List collection = this.getTecTechEnergyTunnels();
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (tecTechEnergyMulti instanceof LowPowerLaser) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="tectech")
    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyTunnels() {
        return this.TTTunnels;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyMultis() {
        return this.TTMultiAmp;
    }
}

