/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaVacuumFreezer
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_MegaVacuumFreezer>
implements TecTechEnabledMulti {
    public ArrayList TTTunnels = new ArrayList();
    public ArrayList TTMultiAmp = new ArrayList();
    private int mCasing = 0;
    private static final int CASING_INDEX = 17;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_MegaVacuumFreezer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccc~ccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "c-------------c", "ccccccccccccccc"}, {"ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc"}})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_TileEntity_MegaVacuumFreezer::addEnergyInputToMachineList, (int)17, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)17, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)17, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)17, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)1))})).build();

    public GT_TileEntity_MegaVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaVacuumFreezer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaVacuumFreezer(this.mName);
    }

    public IStructureDefinition<GT_TileEntity_MegaVacuumFreezer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 7, 7, 0);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (LoaderReference.tectech) {
            return TecTechUtils.addEnergyInputToMachineList(this, aTileEntity, aBaseCasingIndex);
        }
        return super.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean drainEnergyInput(long aEU) {
        if (LoaderReference.tectech) {
            return TecTechUtils.drainEnergyMEBFTecTech(this, aEU);
        }
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }

    public long getMaxInputVoltage() {
        if (LoaderReference.tectech) {
            return TecTechUtils.getMaxInputVoltage(this);
        }
        return super.getMaxInputVoltage();
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sVacuumRecipes;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tInputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sVacuumRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tInputFluids, tInputs);
        boolean found_Recipe = false;
        int processed = 0;
        if (tRecipe != null) {
            found_Recipe = true;
            long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / (long)tRecipe.mEUt);
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tInputFluids, tInputs, (int)tMaxPara);
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = tCurrentPara;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = (long)tRecipe.mEUt * (long)processed;
            if (actualEUT > Integer.MAX_VALUE) {
                int divider = 0;
                while (actualEUT > Integer.MAX_VALUE) {
                    actualEUT /= 2L;
                    divider = (byte)(divider + 1);
                }
                BW_Util.calculateOverclockedNessMulti((int)(actualEUT / (long)(divider * 2)), tRecipe.mDuration * (divider * 2), 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            } else {
                BW_Util.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            }
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 7, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1 && (LoaderReference.tectech ? !this.getTecTechEnergyMultis().isEmpty() || !this.getTecTechEnergyTunnels().isEmpty() || !this.mEnergyHatches.isEmpty() : !this.mEnergyHatches.isEmpty()) && this.mCasing >= 900;
    }

    public String[] getInfoData() {
        return LoaderReference.tectech ? this.getInfoDataArray((GT_MetaTileEntity_MultiBlockBase)this) : super.getInfoData();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Vacuum Freezer").addInfo("Controller Block for the Mega Vacuum Freezer").addInfo("Cools hot ingots and cells").addSeparator().beginStructureBlock(15, 15, 15, true).addController("Front center").addCasingInfo("Frost Proof Machine Casing", 900).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addInputHatch("Any casing", new int[]{1}).addOutputHatch("Any casing", new int[]{1}).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).toolTipFinisher("Bartworks");
        return tt;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = aSide == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE_GLOW}).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_GLOW}).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17]};
        return rTexture;
    }

    @Override
    @Optional.Method(modid="tectech")
    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyTunnels() {
        return this.TTTunnels;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyMultis() {
        return this.TTMultiAmp;
    }
}

