/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.tiered;

import com.github.bartimaeusnek.bartworks.API.BioVatLogicAdder;
import com.github.bartimaeusnek.bartworks.API.IRadMaterial;
import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.client.gui.GT_GUIContainer_RadioHatch;
import com.github.bartimaeusnek.bartworks.server.container.GT_Container_RadioHatch;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.github.bartimaeusnek.crossmod.GTpp.loader.RadioHatchCompat;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_RadioHatch
extends GT_MetaTileEntity_Hatch {
    private final int cap;
    public int sievert;
    private long timer = 1L;
    private short[] colorForGUI;
    private byte mass;
    private String material;
    private byte coverage;

    public GT_MetaTileEntity_RadioHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.0.name"), StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.3.name") + " " + (aTier - 2) + " " + (aTier - 2 >= 2 ? StatCollector.func_74838_a((String)"tooltip.bw.kg.1.name") : StatCollector.func_74838_a((String)"tooltip.bw.kg.0.name")), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.1.name"), BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()}, new ITexture[0]);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public static long calcDecayTicks(int x) {
        long ret = x == 43 ? 5000L : (x == 61 ? 4500L : (x <= 100 ? MathUtils.ceilLong((8000.0f * MathUtils.tanh((float)(-x) / 20.0f) + 8000.0f) * 1000.0f) : MathUtils.ceilLong(8000.0f * MathUtils.tanh((float)(-x) / 65.0f) + 8000.0f)));
        return ret;
    }

    public int getSievert() {
        return this.sievert - MathUtils.ceilInt((float)this.sievert / 100.0f * (float)this.coverage);
    }

    public short[] getColorForGUI() {
        if (this.colorForGUI != null) {
            return this.colorForGUI;
        }
        return new short[]{250, 250, 255};
    }

    public byte getMass() {
        return this.mass;
    }

    public byte getCoverage() {
        return this.coverage;
    }

    public void setCoverage(short coverage) {
        int nu = coverage > 100 ? 100 : (coverage < 0 ? 0 : (int)((byte)coverage));
        this.coverage = (byte)nu;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_RadioHatch(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aPlayer.openGui((Object)"bartworks", 2, this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mass > 0) {
                ++this.timer;
            }
            if (this.mass > 0 && this.sievert > 0 && GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) > 0L && this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) == 0L) {
                this.mass = (byte)(this.mass - 1);
                if (this.mass == 0) {
                    this.material = StatCollector.func_74838_a((String)"tooltip.bw.empty.name");
                    this.sievert = 0;
                }
                this.timer = 1L;
            }
            if (this.mass >= this.cap) {
                return;
            }
            ItemStack lStack = this.mInventory[0];
            this.isStackValidRadioMaterial(lStack, true);
        }
    }

    public boolean isStackValidRadioMaterial(ItemStack lStack) {
        return this.isStackValidRadioMaterial(lStack, false);
    }

    public boolean isStackValidRadioMaterial(ItemStack lStack, boolean use) {
        Materials materials;
        OrePrefixes orePrefixes;
        if (lStack == null) {
            return false;
        }
        IRadMaterial radmat = null;
        if (LoaderReference.miscutils) {
            radmat = RadioHatchCompat.GTppRadChecker(lStack);
        }
        if (lStack.func_77973_b() instanceof IRadMaterial || radmat != null) {
            if (radmat == null) {
                radmat = (IRadMaterial)lStack.func_77973_b();
            }
            int sv = radmat.getRadiationLevel(lStack);
            byte amount = radmat.getAmountOfMaterial(lStack);
            if (sv > BioVatLogicAdder.RadioHatch.getMaxSv()) {
                BioVatLogicAdder.RadioHatch.MaxSV = sv;
            }
            if ((this.mass == 0 || this.sievert == sv) && sv > 0 && amount > 0) {
                if (use) {
                    if (this.mass + amount <= this.cap) {
                        String name = radmat.getNameForGUI(lStack);
                        if (this.mass == 0 || this.material.equals(name)) {
                            this.mass = (byte)(this.mass + amount);
                            this.sievert = sv;
                            --this.mInventory[0].field_77994_a;
                            this.updateSlots();
                            this.colorForGUI = radmat.getColorForGUI(lStack);
                            this.material = name;
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }
        }
        for (ItemStack varStack : BioVatLogicAdder.RadioHatch.getIsSv().keySet()) {
            if (!GT_Utility.areStacksEqual((ItemStack)varStack, (ItemStack)lStack, (boolean)true)) continue;
            int amount = BioVatLogicAdder.RadioHatch.getIsKg().getOrDefault(varStack, 0);
            int sv = BioVatLogicAdder.RadioHatch.getIsSv().get(varStack);
            if (this.mass != 0 && this.sievert != sv || sv <= 0 || amount <= 0) continue;
            if (use) {
                if (this.mass + amount <= this.cap) {
                    String name = StatCollector.func_74838_a((String)varStack.func_77977_a());
                    if (this.mass == 0 || this.material.equals(name)) {
                        this.mass = (byte)(this.mass + amount);
                        this.sievert = BioVatLogicAdder.RadioHatch.getIsSv().get(varStack);
                        --this.mInventory[0].field_77994_a;
                        this.updateSlots();
                        this.colorForGUI = BioVatLogicAdder.RadioHatch.getIsColor().get(varStack);
                        this.material = name;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (GT_OreDictUnificator.getAssociation((ItemStack)lStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial.mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mPrefix != null && ((orePrefixes = GT_OreDictUnificator.getAssociation((ItemStack)lStack).mPrefix).equals((Object)OrePrefixes.stickLong) || orePrefixes.equals((Object)OrePrefixes.stick)) && ((materials = GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial.mMaterial).getProtons() >= 83L && materials.getProtons() != 125L || materials.getProtons() == 61L || materials.getProtons() == 43L)) {
            if (use) {
                int amount;
                int sv = BW_Util.calculateSv(materials);
                int n = amount = orePrefixes.equals((Object)OrePrefixes.stickLong) ? 2 : 1;
                if ((this.mass == 0 || this.sievert == sv) && this.mass + amount <= this.cap) {
                    String name = materials.mName;
                    if (this.mass == 0 || this.material.equals(name)) {
                        this.sievert = sv;
                        this.mass = (byte)(this.mass + (orePrefixes.equals((Object)OrePrefixes.stickLong) ? 2 : 1));
                        --this.mInventory[0].field_77994_a;
                        this.updateSlots();
                        this.colorForGUI = materials.mColor.mRGBa;
                        this.material = materials.mName;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (this.sievert != 0) {
            return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + this.material, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " " + this.sievert, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " " + this.mass, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.5.name") + " " + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) * 60L)) + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.6.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.7.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.8.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L / 60L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.9.name")};
        }
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.func_74838_a((String)"tooltip.bw.empty.name"), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " 0", StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " 0"};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing() && this.isStackValidRadioMaterial(aStack);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_RadioHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_RadioHatch(aPlayerInventory, aBaseMetaTileEntity, this.mName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMass", this.mass);
        aNBT.func_74774_a("mSv", (byte)(this.sievert - 100));
        aNBT.func_74774_a("mCoverage", this.coverage);
        aNBT.func_74768_a("mTextColor", BW_ColorUtil.getColorFromRGBArray(this.getColorForGUI()));
        if (this.material != null && !this.material.isEmpty()) {
            aNBT.func_74778_a("mMaterial", this.material);
        }
        aNBT.func_74772_a("timer", this.timer);
        super.saveNBTData(aNBT);
    }

    public long getTimer() {
        return this.timer;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.timer = aNBT.func_74763_f("timer");
        this.mass = aNBT.func_74771_c("mMass");
        this.sievert = aNBT.func_74771_c("mSv") + 100;
        this.coverage = aNBT.func_74771_c("mCoverage");
        this.colorForGUI = BW_ColorUtil.splitColorToRBGArray(aNBT.func_74762_e("mTextColor"));
        this.material = aNBT.func_74779_i("mMaterial");
        super.loadNBTData(aNBT);
    }
}

