/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticraft.solarsystems;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.crossmod.galacticraft.UniversalTeleportType;
import com.github.bartimaeusnek.crossmod.galacticraft.planets.ross128b.WorldProviderRoss128b;
import com.github.bartimaeusnek.crossmod.galacticraft.planets.ross128ba.WorldProviderRoss128ba;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.util.ResourceLocation;

public class Ross128SolarSystem {
    public static SolarSystem Ross128System;
    public static Star Ross128;
    public static Planet Ross128b;
    public static Moon Ross128ba;

    private Ross128SolarSystem() {
    }

    public static void init() {
        Ross128System = new SolarSystem("Ross128System", "milkyWay").setMapPosition(new Vector3(-1.0, 1.3, 0.0));
        Ross128 = (Star)new Star("Ross128").setParentSolarSystem(Ross128System).setTierRequired(-1);
        Ross128.setUnreachable();
        Ross128.setBodyIcon(new ResourceLocation("bartworkscrossmod:galacticraft/Ross128b/MapObjs/Ross128.png"));
        Ross128System.setMainStar(Ross128);
        Ross128b = new Planet("Ross128b").setParentSolarSystem(Ross128System);
        Ross128b.setRingColorRGB(0.62352943f, 0.5411765f, 0.4745098f);
        Ross128b.setPhaseShift(1.25f);
        Ross128b.setBodyIcon(new ResourceLocation("bartworkscrossmod:galacticraft/Ross128b/MapObjs/Ross128b.png"));
        Ross128b.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 1.75f));
        Ross128b.setRelativeOrbitTime(0.65f);
        Ross128SolarSystem.Ross128b.atmosphere.addAll(Arrays.asList(IAtmosphericGas.OXYGEN, IAtmosphericGas.NITROGEN, IAtmosphericGas.ARGON));
        Ross128b.setDimensionInfo(ConfigHandler.ross128BID, WorldProviderRoss128b.class);
        Ross128b.setTierRequired(ConfigHandler.ross128btier);
        Ross128ba = new Moon("Ross128ba").setParentPlanet(Ross128b);
        Ross128ba.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 15.0f)).setRelativeOrbitTime(100.0f);
        Ross128ba.setBodyIcon(new ResourceLocation("bartworkscrossmod:galacticraft/Ross128b/MapObjs/Ross128ba.png"));
        Ross128ba.setDimensionInfo(ConfigHandler.ross128BAID, WorldProviderRoss128ba.class);
        Ross128ba.setTierRequired(LoaderReference.GalaxySpace ? Math.min(ConfigHandler.ross128btier + 2, 8) : 3);
        GalaxyRegistry.registerSolarSystem((SolarSystem)Ross128System);
        GalaxyRegistry.registerPlanet((Planet)Ross128b);
        GalaxyRegistry.registerMoon((Moon)Ross128ba);
        GalacticraftRegistry.registerRocketGui(WorldProviderRoss128b.class, (ResourceLocation)new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/overworldRocketGui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderRoss128ba.class, (ResourceLocation)new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/moonRocketGui.png"));
        GalacticraftRegistry.registerTeleportType(WorldProviderRoss128b.class, (ITeleportType)new UniversalTeleportType());
        GalacticraftRegistry.registerTeleportType(WorldProviderRoss128ba.class, (ITeleportType)new UniversalTeleportType());
    }
}

