/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.client.renderer.BW_CropVisualizer;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_DummyWorld;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_ExtremeIndustrialGreenhouse
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_ExtremeIndustrialGreenhouse> {
    private static final boolean debug = false;
    private int mCasing = 0;
    private int mMaxSlots = 0;
    private int setupphase = 1;
    private boolean isIC2Mode = false;
    private byte glasTier = 0;
    private int waterusage = 0;
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final Item forestryfertilizer = GameRegistry.findItem((String)"Forestry", (String)"fertilizerCompound");
    private static final IStructureDefinition<GT_TileEntity_ExtremeIndustrialGreenhouse> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ccccc", "clllc", "clllc", "clllc", "ccccc"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ccccc", "cdddc", "cdwdc", "cdddc", "ccccc"}, {"cc~cc", "cCCCc", "cCCCc", "cCCCc", "ccccc"}})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)49, (int)1)})).addElement(Character.valueOf('C'), StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))).addElement(Character.valueOf('l'), LoaderReference.ProjRedIllumination ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ProjRed|Illumination:projectred.illumination.lamp"), (int)10) : StructureUtility.ofBlock((Block)Blocks.field_150379_bu, (int)0)).addElement(Character.valueOf('g'), BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier)).addElement(Character.valueOf('d'), StructureUtility.ofBlock((Block)(LoaderReference.RandomThings ? Block.func_149684_b((String)"RandomThings:fertilizedDirt_tilled") : Blocks.field_150458_ak), (int)0)).addElement(Character.valueOf('w'), StructureUtility.ofBlock((Block)Blocks.field_150355_j, (int)0)).build();
    public List<GreenHouseSlot> mStorage = new ArrayList<GreenHouseSlot>();

    public GT_TileEntity_ExtremeIndustrialGreenhouse(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_ExtremeIndustrialGreenhouse(String aName) {
        super(aName);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You cant change IC2 mode if the machine is working!");
                return;
            }
            if (!this.mStorage.isEmpty()) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You cant change IC2 mode if there are seeds inside!");
                return;
            }
            this.isIC2Mode = !this.isIC2Mode;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("IC2 mode is now " + (this.isIC2Mode ? "enabled" : "disabled.")));
        } else {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You cant enable/disable setup if the machine is working!");
                return;
            }
            ++this.setupphase;
            if (this.setupphase == 3) {
                this.setupphase = 0;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("EIG is now running in " + (this.setupphase == 1 ? "setup mode (input)." : (this.setupphase == 2 ? "setup mode (output)." : "normal operation."))));
        }
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_ExtremeIndustrialGreenhouse(this.mName);
    }

    public IStructureDefinition<GT_TileEntity_ExtremeIndustrialGreenhouse> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    private static String tierString(int tier) {
        return GT_Values.TIER_COLORS[tier] + GT_Values.VN[tier] + "\u00a7r" + "\u00a77";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Crop Farm").addInfo("Controller block for the Extreme Industrial Greenhouse").addInfo("Grow your crops like a chad !").addInfo("Use screwdriver to enable/change/disable setup mode").addInfo("Use screwdriver while sneaking to enable/disable IC2 mode").addInfo("Uses 1000L of water per crop per operation").addInfo("You can insert fertilizer each operation to get more drops (max +400%)").addInfo("-------------------- SETUP   MODE --------------------").addInfo("Does not take power").addInfo("There are two modes: input / output").addInfo("Input mode: machine will take seeds from input bus and plant them").addInfo("[IC2] You need to also input block that is required under the crop").addInfo("Output mode: machine will take planted seeds and output them").addInfo("-------------------- NORMAL CROPS --------------------").addInfo("Minimal tier: " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(4)).addInfo("Starting with 1 slot").addInfo("Every slot gives 64 crops").addInfo("Every tier past " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(4) + ", slots are multiplied by 2").addInfo("Base process time: 5 sec").addInfo("Process time is divided by number of tiers past " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(3) + " (Minimum 1 sec)").addInfo("All crops are grown at the end of the operation").addInfo("Will automatically craft seeds if they are not dropped").addInfo("1 Fertilizer per 1 crop +200%").addInfo("-------------------- IC2    CROPS --------------------").addInfo("Minimal tier: " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(6)).addInfo("Need " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(6) + " glass tier").addInfo("Starting with 4 slots").addInfo("Every slot gives 1 crop").addInfo("Every tier past " + GT_TileEntity_ExtremeIndustrialGreenhouse.tierString(6) + ", slots are multiplied by 4").addInfo("Process time: 5 sec").addInfo("All crops are accelerated by x32 times").addInfo("1 Fertilizer per 1 crop +10%").addInfo(BW_Tooltip_Reference.TT_BLUEPRINT).addSeparator().beginStructureBlock(5, 4, 5, false).addController("Front bottom center").addCasingInfo("Clean Stainless Steel Casings", 70).addOtherStructurePart("Borosilicate Glass", "Hollow two middle layers", new int[]{2}).addStructureInfo("The glass tier limits the Energy Input tier").addStructureInfo("The dirt is from RandomThings, must be tilled").addStructureInfo("Purple lamps are from ProjectRedIllumination. They can be lit").addMaintenanceHatch("Any casing (Except inner bottom ones)", new int[]{1}).addInputBus("Any casing (Except inner bottom ones)", new int[]{1}).addOutputBus("Any casing (Except inner bottom ones)", new int[]{1}).addInputHatch("Any casing (Except inner bottom ones)", new int[]{1}).addEnergyHatch("Any casing (Except inner bottom ones)", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_VIA_BARTWORKS.apply("\u00a76kuba6000"));
        return tt;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getStructureDescription(stackSize)));
        info.add("The dirt is from RandomThings, must be tilled");
        info.add("Purple lamps are from ProjectRedIllumination. They can be lit");
        return info.toArray(new String[0]);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("glasTier", this.glasTier);
        aNBT.func_74768_a("setupphase", this.setupphase);
        aNBT.func_74757_a("isIC2Mode", this.isIC2Mode);
        aNBT.func_74768_a("mStorageSize", this.mStorage.size());
        for (int i = 0; i < this.mStorage.size(); ++i) {
            aNBT.func_74782_a("mStorage." + i, (NBTBase)this.mStorage.get(i).toNBTTagCompound());
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.glasTier = aNBT.func_74771_c("glasTier");
        this.setupphase = aNBT.func_74762_e("setupphase");
        this.isIC2Mode = aNBT.func_74767_n("isIC2Mode");
        for (int i = 0; i < aNBT.func_74762_e("mStorageSize"); ++i) {
            this.mStorage.add(new GreenHouseSlot(aNBT.func_74775_l("mStorage." + i)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnVisualCrop(World world, int x, int y, int z, int meta, int age) {
        BW_CropVisualizer crop = new BW_CropVisualizer(world, x, y, z, meta, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)crop);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0) continue;
                    int[] abc = new int[]{x, -2, z + 2};
                    int[] xyz = new int[]{0, 0, 0};
                    this.getExtendedFacing().getWorldOffset(abc, xyz);
                    xyz[0] = xyz[0] + aBaseMetaTileEntity.getXCoord();
                    xyz[1] = xyz[1] + aBaseMetaTileEntity.getYCoord();
                    xyz[2] = xyz[2] + aBaseMetaTileEntity.getZCoord();
                    this.spawnVisualCrop(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], aBaseMetaTileEntity.getRandomNumber(8), 40);
                }
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && this.mMaxProgresstime > 0 && this.setupphase > 0 && aTick % 5L == 0L) {
            this.startRecipeProcessing();
            if (this.setupphase == 1 && this.mStorage.size() < this.mMaxSlots) {
                ItemStack input;
                ArrayList inputs = this.getStoredInputs();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext() && !this.addCrop(input = (ItemStack)iterator.next())) {
                }
                this.updateSlots();
            } else if (this.setupphase == 2 && this.mStorage.size() > 0) {
                this.addOutput(this.mStorage.get((int)0).input.func_77946_l());
                if (this.mStorage.get((int)0).undercrop != null) {
                    this.addOutput(this.mStorage.get((int)0).undercrop.func_77946_l());
                }
                this.mStorage.remove(0);
                this.updateSlots();
            }
            this.endRecipeProcessing();
        }
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 5, 0);
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    private void updateMaxSlots() {
        long v = this.getMaxInputVoltage();
        byte tier = GT_Utility.getTier((long)v);
        this.mMaxSlots = tier < (this.isIC2Mode ? (byte)6 : 4) ? 0 : (this.isIC2Mode ? 4 << 2 * (tier - 6) : 1 << tier - 4);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        long v = this.getMaxInputVoltage();
        byte tier = GT_Utility.getTier((long)v);
        this.updateMaxSlots();
        if (this.setupphase > 0) {
            if (this.mStorage.size() >= this.mMaxSlots && this.setupphase == 1 || this.mStorage.size() == 0 && this.setupphase == 2) {
                return false;
            }
            this.mMaxProgresstime = 20;
            this.mEUt = 0;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            return true;
        }
        if (this.mStorage.size() > this.mMaxSlots) {
            return false;
        }
        if (this.mStorage.isEmpty()) {
            return false;
        }
        this.waterusage = 0;
        for (GreenHouseSlot s : this.mStorage) {
            this.waterusage += s.input.field_77994_a;
        }
        if (!this.depleteInput(new FluidStack(FluidRegistry.WATER, this.waterusage * 1000))) {
            return false;
        }
        int boost = 0;
        int maxboost = 0;
        for (GreenHouseSlot greenHouseSlot : this.mStorage) {
            maxboost += greenHouseSlot.input.field_77994_a * (this.isIC2Mode ? 40 : 2);
        }
        ArrayList inputs = this.getStoredInputs();
        for (ItemStack i : inputs) {
            if (i.func_77973_b() == Items.field_151100_aR && i.func_77960_j() == 15 || forestryfertilizer != null && i.func_77973_b() == forestryfertilizer || GT_Utility.areStacksEqual((ItemStack)i, (ItemStack)Ic2Items.fertilizer)) {
                int used = Math.min(i.field_77994_a, maxboost - boost);
                i.field_77994_a -= used;
                boost += used;
            }
            if (boost != maxboost) continue;
            break;
        }
        double d = 1.0 + (double)boost / (double)maxboost * 4.0;
        if (this.isIC2Mode) {
            if (this.glasTier < 6) {
                return false;
            }
            this.mMaxProgresstime = 100;
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < Math.min(this.mMaxSlots, this.mStorage.size()); ++i) {
                outputs.addAll(this.mStorage.get(i).getIC2Drops((double)this.mMaxProgresstime / 8.0 * d));
            }
            this.mOutputItems = outputs.toArray(new ItemStack[0]);
        } else {
            this.mMaxProgresstime = Math.max(20, 100 / (tier - 3));
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < Math.min(this.mMaxSlots, this.mStorage.size()); ++i) {
                for (ItemStack drop : this.mStorage.get(i).getDrops()) {
                    ItemStack s = drop.func_77946_l();
                    s.field_77994_a = (int)((double)s.field_77994_a * d);
                    outputs.add(s);
                }
            }
            this.mOutputItems = outputs.toArray(new ItemStack[0]);
        }
        this.mEUt = -((int)((double)GT_Values.V[tier] * 0.99));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        boolean valid;
        this.mCasing = 0;
        this.glasTier = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 5, 0)) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        boolean bl = valid = this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() >= 1 && this.mCasing >= 70;
        if (valid) {
            this.updateMaxSlots();
        }
        return valid;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public String[] getInfoData() {
        String[] stringArray = new String[4];
        stringArray[0] = "Running in mode: " + EnumChatFormatting.GREEN + (this.setupphase == 0 ? (this.isIC2Mode ? "IC2 crops" : "Normal crops") : "Setup mode " + (this.setupphase == 1 ? "(input)" : "(output)")) + EnumChatFormatting.RESET;
        stringArray[1] = "Uses " + this.waterusage * 1000 + "L/operation of water";
        stringArray[2] = "Max slots: " + EnumChatFormatting.GREEN + this.mMaxSlots + EnumChatFormatting.RESET;
        stringArray[3] = "Used slots: " + (this.mStorage.size() > this.mMaxSlots ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + this.mStorage.size() + EnumChatFormatting.RESET;
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(stringArray));
        for (int i = 0; i < this.mStorage.size(); ++i) {
            if (!this.mStorage.get((int)i).isValid) continue;
            StringBuilder a = new StringBuilder("Slot " + i + ": " + EnumChatFormatting.GREEN + "x" + this.mStorage.get((int)i).input.field_77994_a + " " + this.mStorage.get((int)i).input.func_82833_r());
            if (this.isIC2Mode) {
                a.append(" : ");
                for (Map.Entry<String, Double> entry : this.mStorage.get((int)i).dropprogress.entrySet()) {
                    a.append((int)(entry.getValue() * 100.0)).append("% ");
                }
            }
            a.append(EnumChatFormatting.RESET);
            info.add(a.toString());
        }
        if (this.mStorage.size() > this.mMaxSlots) {
            info.add(EnumChatFormatting.DARK_RED + "There are too many crops inside to run !" + EnumChatFormatting.RESET);
        }
        info.addAll(Arrays.asList(super.getInfoData()));
        return info.toArray(new String[0]);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    public boolean addCrop(ItemStack input) {
        if (!this.isIC2Mode) {
            for (GreenHouseSlot g : this.mStorage) {
                if (!GT_Utility.areStacksEqual((ItemStack)g.input, (ItemStack)input)) continue;
                g.addAll(this.getBaseMetaTileEntity().getWorld(), input);
                if (input.field_77994_a != 0) continue;
                return true;
            }
        }
        GreenHouseSlot h = new GreenHouseSlot(this, input.func_77946_l(), true, this.isIC2Mode);
        if (h.isValid) {
            input.field_77994_a = this.isIC2Mode ? --input.field_77994_a : 0;
            this.mStorage.add(h);
            return true;
        }
        return false;
    }

    private static class GreenHouseRandom
    extends Random {
        private GreenHouseRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }

    private static class GreenHouseWorld
    extends GT_DummyWorld {
        public int x = 0;
        public int y = 0;
        public int z = 0;
        public int meta = 0;
        public Block block;

        GreenHouseWorld(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.field_73012_v = new GreenHouseRandom();
        }

        public int func_72805_g(int aX, int aY, int aZ) {
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return 7;
            }
            return 0;
        }

        public Block func_147439_a(int aX, int aY, int aZ) {
            if (aY == this.y - 1) {
                return Blocks.field_150458_ak;
            }
            return Blocks.field_150350_a;
        }

        public int func_72957_l(int p_72957_1_, int p_72957_2_, int p_72957_3_) {
            return 10;
        }

        public boolean func_147465_d(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
            if (aBlock == Blocks.field_150350_a) {
                return false;
            }
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return false;
            }
            this.block = aBlock;
            this.meta = aMeta;
            return true;
        }
    }

    private static class GreenHouseSlot
    extends InventoryCrafting {
        ItemStack input;
        Block crop;
        ItemStack undercrop = null;
        List<ItemStack> drops;
        boolean isValid;
        boolean isIC2Crop;
        int growthticks;
        List<List<ItemStack>> generations;
        Random rn;
        IRecipe recipe;
        ItemStack recipeInput;
        int optimalgrowth = 7;
        boolean needsreplanting = true;
        static GreenHouseWorld fakeworld = new GreenHouseWorld(5, 5, 5);
        Map<String, Double> dropprogress = new HashMap<String, Double>();
        static Map<String, ItemStack> dropstacks = new HashMap<String, ItemStack>();

        public NBTTagCompound toNBTTagCompound() {
            NBTTagCompound aNBT = new NBTTagCompound();
            aNBT.func_74782_a("input", (NBTBase)this.input.func_77955_b(new NBTTagCompound()));
            aNBT.func_74757_a("isValid", this.isValid);
            aNBT.func_74757_a("isIC2Crop", this.isIC2Crop);
            if (!this.isIC2Crop) {
                aNBT.func_74768_a("crop", Block.func_149682_b((Block)this.crop));
                aNBT.func_74768_a("dropscount", this.drops.size());
                for (int i = 0; i < this.drops.size(); ++i) {
                    aNBT.func_74782_a("drop." + i, (NBTBase)this.drops.get(i).func_77955_b(new NBTTagCompound()));
                }
                aNBT.func_74768_a("optimalgrowth", this.optimalgrowth);
                aNBT.func_74757_a("needsreplanting", this.needsreplanting);
            } else {
                if (this.undercrop != null) {
                    aNBT.func_74782_a("undercrop", (NBTBase)this.undercrop.func_77955_b(new NBTTagCompound()));
                }
                aNBT.func_74768_a("generationscount", this.generations.size());
                for (int i = 0; i < this.generations.size(); ++i) {
                    aNBT.func_74768_a("generation." + i + ".count", this.generations.get(i).size());
                    for (int j = 0; j < this.generations.get(i).size(); ++j) {
                        aNBT.func_74782_a("generation." + i + "." + j, (NBTBase)this.generations.get(i).get(j).func_77955_b(new NBTTagCompound()));
                    }
                }
                aNBT.func_74768_a("growthticks", this.growthticks);
            }
            return aNBT;
        }

        public GreenHouseSlot(NBTTagCompound aNBT) {
            super(null, 3, 3);
            this.isIC2Crop = aNBT.func_74767_n("isIC2Crop");
            this.isValid = aNBT.func_74767_n("isValid");
            this.input = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("input"));
            if (!this.isIC2Crop) {
                this.crop = Block.func_149729_e((int)aNBT.func_74762_e("crop"));
                this.drops = new ArrayList<ItemStack>();
                for (int i = 0; i < aNBT.func_74762_e("dropscount"); ++i) {
                    this.drops.add(ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("drop." + i)));
                }
                this.optimalgrowth = aNBT.func_74762_e("optimalgrowth");
                if (this.optimalgrowth == 0) {
                    this.optimalgrowth = 7;
                }
                if (aNBT.func_74764_b("needsreplanting")) {
                    this.needsreplanting = aNBT.func_74767_n("needsreplanting");
                }
            } else {
                if (aNBT.func_74764_b("undercrop")) {
                    this.undercrop = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("undercrop"));
                }
                this.generations = new ArrayList<List<ItemStack>>();
                for (int i = 0; i < aNBT.func_74762_e("generationscount"); ++i) {
                    this.generations.add(new ArrayList());
                    for (int j = 0; j < aNBT.func_74762_e("generation." + i + ".count"); ++j) {
                        this.generations.get(i).add(ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("generation." + i + "." + j)));
                    }
                }
                this.growthticks = aNBT.func_74762_e("growthticks");
                this.rn = new Random();
            }
        }

        public boolean addAll(World world, ItemStack input) {
            if (!GT_Utility.areStacksEqual((ItemStack)this.input, (ItemStack)input)) {
                return false;
            }
            if (this.input.field_77994_a == 64) {
                return false;
            }
            int toconsume = Math.min(64 - this.input.field_77994_a, input.field_77994_a);
            int left = this.addDrops(world, toconsume, true);
            input.field_77994_a -= toconsume - left;
            this.input.field_77994_a += toconsume - left;
            return left == 0;
        }

        public boolean findCropRecipe(World world) {
            if (this.recipe != null) {
                return true;
            }
            Iterator<ItemStack> iterator = this.drops.iterator();
            block0: while (iterator.hasNext()) {
                ItemStack drop;
                this.recipeInput = drop = iterator.next();
                for (int j = 0; j < CraftingManager.func_77594_a().func_77592_b().size(); ++j) {
                    this.recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(j);
                    if (this.recipe.func_77569_a((InventoryCrafting)this, world) && GT_Utility.areStacksEqual((ItemStack)this.recipe.func_77572_b((InventoryCrafting)this), (ItemStack)this.input)) break block0;
                    this.recipe = null;
                }
            }
            return this.recipe != null;
        }

        public ItemStack func_70301_a(int p_70301_1_) {
            if (p_70301_1_ == 0) {
                return this.recipeInput.func_77946_l();
            }
            return null;
        }

        public ItemStack func_70304_b(int par1) {
            return null;
        }

        public ItemStack func_70298_a(int par1, int par2) {
            return null;
        }

        public void func_70299_a(int par1, ItemStack par2ItemStack) {
        }

        public GreenHouseSlot(GT_TileEntity_ExtremeIndustrialGreenhouse tileEntity, ItemStack input, boolean autocraft, boolean IC22) {
            super(null, 3, 3);
            World world = tileEntity.getBaseMetaTileEntity().getWorld();
            this.input = input.func_77946_l();
            this.isValid = false;
            if (IC22) {
                this.GreenHouseSlotIC2(tileEntity, world, input);
                return;
            }
            Item i = input.func_77973_b();
            Block b = null;
            if (i instanceof IPlantable) {
                if (i instanceof ItemSeeds) {
                    b = ((ItemSeeds)i).getPlant((IBlockAccess)world, 0, 0, 0);
                } else if (i instanceof ItemSeedFood) {
                    b = ((ItemSeedFood)i).getPlant((IBlockAccess)world, 0, 0, 0);
                }
            } else {
                if (i == Items.field_151120_aE) {
                    b = Blocks.field_150436_aH;
                } else {
                    b = Block.func_149634_a((Item)i);
                    if (b != Blocks.field_150434_aF) {
                        return;
                    }
                }
                this.needsreplanting = false;
            }
            if (!(b instanceof IPlantable)) {
                return;
            }
            GameRegistry.UniqueIdentifier u = GameRegistry.findUniqueIdentifierFor((Item)i);
            if (u != null && Objects.equals(u.modId, "Natura")) {
                this.optimalgrowth = 8;
            }
            if (b instanceof BlockStem) {
                GreenHouseSlot.fakeworld.block = null;
                try {
                    b.func_149674_a((World)fakeworld, 5, 5, 5, GreenHouseSlot.fakeworld.field_73012_v);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                if (GreenHouseSlot.fakeworld.block == null) {
                    return;
                }
                b = GreenHouseSlot.fakeworld.block;
                this.needsreplanting = false;
            }
            this.crop = b;
            this.isIC2Crop = false;
            if (this.addDrops(world, input.field_77994_a, autocraft) == 0 && !this.drops.isEmpty()) {
                this.isValid = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void GreenHouseSlotIC2(GT_TileEntity_ExtremeIndustrialGreenhouse tileEntity, World world, ItemStack input) {
            if (!ItemList.IC2_Crop_Seeds.isStackEqual((Object)input, true, true)) {
                return;
            }
            CropCard cc = Crops.instance.getCropCard(input);
            this.input.field_77994_a = 1;
            NBTTagCompound nbt = input.func_77978_p();
            byte gr = nbt.func_74771_c("growth");
            byte ga = nbt.func_74771_c("gain");
            byte re = nbt.func_74771_c("resistance");
            this.isIC2Crop = true;
            int[] abc = new int[]{0, -2, 3};
            int[] xyz = new int[]{0, 0, 0};
            tileEntity.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + tileEntity.getBaseMetaTileEntity().getXCoord();
            xyz[1] = xyz[1] + tileEntity.getBaseMetaTileEntity().getYCoord();
            xyz[2] = xyz[2] + tileEntity.getBaseMetaTileEntity().getZCoord();
            boolean cheating = false;
            try {
                if (world.func_147439_a(xyz[0], xyz[1] - 2, xyz[2]) != GregTech_API.sBlockCasings4 || world.func_72805_g(xyz[0], xyz[1] - 2, xyz[2]) != 1) {
                    cheating = true;
                    return;
                }
                world.func_147465_d(xyz[0], xyz[1], xyz[2], Block.func_149634_a((Item)Ic2Items.crop.func_77973_b()), 0, 0);
                TileEntity wte = world.func_147438_o(xyz[0], xyz[1], xyz[2]);
                if (!(wte instanceof TileEntityCrop)) {
                    return;
                }
                TileEntityCrop te = (TileEntityCrop)wte;
                te.ticker = '\u0001';
                te.setCrop(cc);
                te.setGrowth(gr);
                te.setGain(ga);
                te.setResistance(re);
                ItemStack tobeused = null;
                te.setSize((byte)(cc.maxSize() - 1));
                if (!cc.canGrow((ICropTile)te)) {
                    boolean cangrow = false;
                    ArrayList inputs = tileEntity.getStoredInputs();
                    for (ItemStack a : inputs) {
                        Block b = Block.func_149634_a((Item)a.func_77973_b());
                        if (b == Blocks.field_150350_a) continue;
                        world.func_147465_d(xyz[0], xyz[1] - 2, xyz[2], b, a.func_77960_j(), 0);
                        if (!cc.canGrow((ICropTile)te)) continue;
                        cangrow = true;
                        this.undercrop = a.func_77946_l();
                        this.undercrop.field_77994_a = 1;
                        tobeused = a;
                        break;
                    }
                    if (!cangrow) {
                        return;
                    }
                }
                te.setSize((byte)cc.maxSize());
                if (!cc.canBeHarvested((ICropTile)te)) {
                    return;
                }
                this.generations = new ArrayList<List<ItemStack>>();
                block12: for (int i = 0; i < 10; ++i) {
                    ItemStack[] st = te.harvest_automated(false);
                    te.setSize((byte)cc.maxSize());
                    if (st == null || st.length == 0) continue;
                    for (ItemStack s : st) {
                        if (s == null) continue block12;
                    }
                    this.generations.add(new ArrayList<ItemStack>(Arrays.asList(st)));
                }
                if (this.generations.isEmpty()) {
                    return;
                }
                this.rn = new Random();
                te.humidity = (byte)12;
                te.airQuality = (byte)6;
                te.nutrients = (byte)8;
                int dur = cc.growthDuration((ICropTile)te);
                int rate = te.calcGrowthRate();
                if (rate == 0) {
                    return;
                }
                this.growthticks = dur / rate;
                if (this.growthticks < 1) {
                    this.growthticks = 1;
                }
                --input.field_77994_a;
                if (tobeused != null) {
                    --tobeused.field_77994_a;
                }
                this.isValid = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (!cheating) {
                    world.func_147465_d(xyz[0], xyz[1] - 2, xyz[2], GregTech_API.sBlockCasings4, 1, 0);
                }
                world.func_147468_f(xyz[0], xyz[1], xyz[2]);
            }
        }

        public List<ItemStack> getDrops() {
            return this.drops;
        }

        public List<ItemStack> getIC2Drops(double timeelapsed) {
            int r = this.rn.nextInt(10);
            if (this.generations.size() <= r) {
                return new ArrayList<ItemStack>();
            }
            double growthPercent = timeelapsed / (double)this.growthticks;
            List<ItemStack> generation = this.generations.get(r);
            ArrayList<ItemStack> copied = new ArrayList<ItemStack>();
            for (ItemStack itemStack : generation) {
                copied.add(itemStack.func_77946_l());
            }
            for (ItemStack itemStack : copied) {
                double pro = (double)itemStack.field_77994_a * growthPercent;
                itemStack.field_77994_a = 1;
                if (this.dropprogress.containsKey(itemStack.toString())) {
                    this.dropprogress.put(itemStack.toString(), this.dropprogress.get(itemStack.toString()) + pro);
                } else {
                    this.dropprogress.put(itemStack.toString(), pro);
                }
                if (dropstacks.containsKey(itemStack.toString())) continue;
                dropstacks.put(itemStack.toString(), itemStack.func_77946_l());
            }
            copied.clear();
            for (Map.Entry entry : this.dropprogress.entrySet()) {
                if (!((Double)entry.getValue() >= 1.0)) continue;
                copied.add(dropstacks.get(entry.getKey()).func_77946_l());
                ((ItemStack)copied.get((int)(copied.size() - 1))).field_77994_a = ((Double)entry.getValue()).intValue();
                entry.setValue((Double)entry.getValue() - (double)((Double)entry.getValue()).intValue());
            }
            return copied;
        }

        public int addDrops(World world, int count, boolean autocraft) {
            int i;
            this.drops = new ArrayList<ItemStack>();
            for (i = 0; i < count; ++i) {
                ArrayList d = this.crop.getDrops(world, 0, 0, 0, this.optimalgrowth, 0);
                for (ItemStack x : this.drops) {
                    for (ItemStack y : d) {
                        if (!GT_Utility.areStacksEqual((ItemStack)x, (ItemStack)y)) continue;
                        x.field_77994_a += y.field_77994_a;
                        y.field_77994_a = 0;
                    }
                }
                for (ItemStack x : d) {
                    if (x.field_77994_a <= 0) continue;
                    this.drops.add(x.func_77946_l());
                }
            }
            if (!this.needsreplanting) {
                return 0;
            }
            for (i = 0; i < this.drops.size(); ++i) {
                if (!GT_Utility.areStacksEqual((ItemStack)this.drops.get(i), (ItemStack)this.input)) continue;
                int took = Math.min(this.drops.get((int)i).field_77994_a, count);
                this.drops.get((int)i).field_77994_a -= took;
                count -= took;
                if (this.drops.get((int)i).field_77994_a == 0) {
                    this.drops.remove(i);
                    --i;
                }
                if (count != 0) continue;
                return 0;
            }
            if (autocraft) {
                if (!this.findCropRecipe(world)) {
                    return count;
                }
                int totake = count / this.recipe.func_77572_b((InventoryCrafting)this).field_77994_a + 1;
                for (int i2 = 0; i2 < this.drops.size(); ++i2) {
                    if (!GT_Utility.areStacksEqual((ItemStack)this.drops.get(i2), (ItemStack)this.recipeInput)) continue;
                    int took = Math.min(this.drops.get((int)i2).field_77994_a, totake);
                    this.drops.get((int)i2).field_77994_a -= took;
                    totake -= took;
                    if (this.drops.get((int)i2).field_77994_a == 0) {
                        this.drops.remove(i2);
                        --i2;
                    }
                    if (totake != 0) continue;
                    return 0;
                }
            }
            return count;
        }
    }
}

