/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis;

import com.github.bartimaeusnek.bartworks.client.gui.BW_GUIContainer_Windmill;
import com.github.bartimaeusnek.bartworks.common.items.BW_Stonage_Rotors;
import com.github.bartimaeusnek.bartworks.common.tileentities.classic.BW_RotorBlock;
import com.github.bartimaeusnek.bartworks.server.container.BW_Container_Windmill;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class GT_TileEntity_Windmill
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_TileEntity_Windmill>
implements ISurvivalConstructable {
    private static final IIcon[] iIcons = new IIcon[2];
    private static final IIconContainer[] iIconContainers = new IIconContainer[2];
    private static final ITexture[] iTextures = new ITexture[3];
    private static final XSTR localRandomInstance = new XSTR();
    private BW_RotorBlock rotorBlock;
    private int mDoor = 0;
    private int mHardenedClay = 0;
    private int mMulti = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_Windmill> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "       ", "       ", "   p   ", "       ", "       ", "       "}, {"       ", "       ", "  ppp  ", "  p p  ", "  ppp  ", "       ", "       "}, {"       ", " ppppp ", " p   p ", " p   p ", " p   p ", " ppppp ", "       "}, {" ppppp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {" ppspp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {" ppppp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {"       ", " ppppp ", " p   p ", " p   p ", " p   p ", " ppppp ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {" bb~bb ", "bbbbbbb", "bbbbbbb", "bbbbbbb", "bbbbbbb", "bbbbbbb", " bbbbb "}})).addElement(Character.valueOf('p'), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150344_f)).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mHardenedClay, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150405_ch, (int)0)), StructureUtility.ofTileAdder(GT_TileEntity_Windmill::addDispenserToOutputSet, (Block)Blocks.field_150405_ch, (int)0), StructureUtility.onElementPass(t -> ++t.mDoor, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150466_ao, (int)0))})).addElement(Character.valueOf('b'), StructureUtility.ofBlock((Block)Blocks.field_150336_V, (int)0)).addElement(Character.valueOf('s'), (IStructureElement)StructureUtility.ofTileAdder(GT_TileEntity_Windmill::setRotorBlock, (Block)StructureLibAPI.getBlockHint(), (int)0)).build();
    private final Set<TileEntityDispenser> tileEntityDispensers = new HashSet<TileEntityDispenser>();

    public GT_TileEntity_Windmill(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private GT_TileEntity_Windmill(String aName) {
        super(aName);
    }

    public IStructureDefinition<GT_TileEntity_Windmill> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Windmill").addInfo("Controller block for the Windmill").addInfo("A primitive Grinder powered by Kinetic energy").addInfo("Speed and output will be affected by wind speed, recipe and rotor").addInfo("Please use the Primitive Rotor").addInfo("Macerates 16 items at a time").addInfo("The structure is too complex!").addInfo("Follow the StructureLib hologram projector to build the main structure.").addSeparator().beginStructureBlock(7, 12, 7, false).addController("Front bottom center").addCasingInfo("Hardened Clay block", 40).addOtherStructurePart("Dispenser", "Any Hardened Clay block").addOtherStructurePart("0-1 Wooden door", "Any Hardened Clay block").addStructureHint("Primitive Kinetic Shaftbox", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mMaxProgresstime > 0) {
            this.mProgresstime += this.rotorBlock.getGrindPower();
        }
        if (!this.rotorBlock.rotorSlot.isEmpty()) {
            this.setRotorDamage(this.rotorBlock, this.rotorBlock.getGrindPower());
        }
        return this.rotorBlock.getGrindPower() > 0;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    private float[] multiplierRecipe(ItemStack itemStack) {
        if (itemStack.func_77973_b().equals(Items.field_151015_O)) {
            return new float[]{1.13f, 1.5f};
        }
        if (itemStack.func_77973_b().equals(Items.field_151103_aS) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150426_aN) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150423_aK)) {
            return new float[]{0.8f, 1.0f};
        }
        if (Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150351_n) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150347_e) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150348_b) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150322_A) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150435_aG) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150405_ch) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150406_ce) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150325_L) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150424_aL) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150364_r) || Block.func_149634_a((Item)itemStack.func_77973_b()).equals(Blocks.field_150363_s)) {
            return new float[]{1.0f, 1.5f};
        }
        if (GT_OreDictUnificator.getAssociation((ItemStack)itemStack) == null || GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix == null || GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial == null || GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial == null || GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial.getDust(1) == null) {
            return new float[]{1.0f, 1.0f};
        }
        if (OrePrefixes.ore.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreNetherrack.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreEndstone.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreBlackgranite.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreRedgranite.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreMarble.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.oreBasalt.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix)) {
            return new float[]{0.5f, 1.0f};
        }
        if (OrePrefixes.stone.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneBricks.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneChiseled.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneCobble.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneCracked.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneMossy.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneMossyBricks.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.stoneSmooth.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix) || OrePrefixes.cobblestone.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix)) {
            return new float[]{1.0f, 1.5f};
        }
        return new float[]{1.0f, 1.0f};
    }

    public boolean checkRecipe(ItemStack itemStack) {
        GT_Recipe.GT_Recipe_Map tMap;
        GT_Recipe tRecipe;
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        if (this.mOutputItems == null) {
            this.mOutputItems = new ItemStack[2];
        }
        if ((tRecipe = (tMap = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes).findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, false, GT_Values.V[1], null, new ItemStack[]{itemStack})) == null) {
            return false;
        }
        if (tRecipe.getOutput(0) != null) {
            ItemStack tmp;
            int amount;
            for (int i = 0; i < this.mMulti; ++i) {
                if (tRecipe.isRecipeInputEqual(true, null, new ItemStack[]{itemStack})) continue;
                this.mMulti = i + 1;
                break;
            }
            this.updateSlots();
            this.mOutputItems[0] = tRecipe.getOutput(0);
            float[] mRecipe = this.multiplierRecipe(itemStack);
            float multiper = Math.min(mRecipe[1], Math.max(mRecipe[0], 2.0f * (float)Math.sqrt(1.0f / (float)(this.rotorBlock.getWindStrength() + 1)) * this.OutputMultiplier(this.rotorBlock) * (mRecipe[0] + mRecipe[1])));
            ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
            for (amount = Math.round(multiper * (float)(this.mOutputItems[0].field_77994_a * this.mMulti)); amount > this.mOutputItems[0].func_77976_d(); amount -= this.mOutputItems[0].func_77976_d()) {
                tmp = this.mOutputItems[0];
                tmp.field_77994_a = this.mOutputItems[0].func_77976_d();
                splitStacks.add(tmp);
            }
            tmp = this.mOutputItems[0];
            tmp.field_77994_a = amount;
            splitStacks.add(tmp);
            this.mOutputItems = splitStacks.toArray(new ItemStack[splitStacks.size()]);
        }
        this.mMaxProgresstime = tRecipe.mDuration * 2 * 100 * this.mMulti / this.getSpeed(this.rotorBlock);
        this.mMulti = 16;
        return true;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new BW_GUIContainer_Windmill(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new BW_Container_Windmill(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void stopMachine() {
        this.getBaseMetaTileEntity().disableWorking();
    }

    public boolean addDispenserToOutputSet(TileEntity aTileEntity) {
        if (aTileEntity instanceof TileEntityDispenser) {
            this.tileEntityDispensers.add((TileEntityDispenser)aTileEntity);
            return true;
        }
        return false;
    }

    public boolean setRotorBlock(TileEntity aTileEntity) {
        if (aTileEntity instanceof BW_RotorBlock) {
            this.rotorBlock = (BW_RotorBlock)aTileEntity;
            return true;
        }
        return false;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        for (TileEntityDispenser tHatch : this.tileEntityDispensers) {
            for (int i = tHatch.func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.func_70301_a(i) != null && (!GT_Utility.areStacksEqual((ItemStack)tHatch.func_70301_a(i), (ItemStack)aStack) || aStack.field_77994_a + tHatch.func_70301_a((int)i).field_77994_a > 64)) continue;
                if (GT_Utility.areStacksEqual((ItemStack)tHatch.func_70301_a(i), (ItemStack)aStack)) {
                    ItemStack merge = tHatch.func_70301_a(i).func_77946_l();
                    merge.field_77994_a = aStack.field_77994_a + tHatch.func_70301_a((int)i).field_77994_a;
                    tHatch.func_70299_a(i, merge);
                } else {
                    tHatch.func_70299_a(i, aStack.func_77946_l());
                }
                if (GT_Utility.areStacksEqual((ItemStack)tHatch.func_70301_a(i), (ItemStack)aStack)) {
                    aStack = null;
                    return true;
                }
                tHatch.func_70299_a(i, null);
                aStack = null;
                return false;
            }
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.tileEntityDispensers.clear();
        this.mDoor = 0;
        this.mHardenedClay = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 11, 0)) {
            return false;
        }
        if (this.tileEntityDispensers.isEmpty() || this.mDoor > 2 || this.mHardenedClay < 40) {
            return false;
        }
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
        return true;
    }

    public int getCurrentEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public void updateSlots() {
        if (this.mInventory[1] != null && this.mInventory[1].field_77994_a <= 0) {
            this.mInventory[1] = null;
        }
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_Windmill(this.mName);
    }

    public String[] getInfoData() {
        return new String[]{"Progress:", this.mProgresstime + " Grindings of " + this.mMaxProgresstime + " needed Grindings", "GrindPower:", this.rotorBlock.getGrindPower() + "KU/t"};
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        GT_TileEntity_Windmill.iIcons[0] = Blocks.field_150336_V.func_149691_a(0, 0);
        GT_TileEntity_Windmill.iIconContainers[0] = new IIconContainer(){

            public IIcon getIcon() {
                return iIcons[0];
            }

            public IIcon getOverlayIcon() {
                return null;
            }

            public ResourceLocation getTextureFile() {
                return new ResourceLocation("brick");
            }
        };
        GT_TileEntity_Windmill.iIcons[1] = aBlockIconRegister.func_94245_a("bartworks:windmill_top");
        GT_TileEntity_Windmill.iIconContainers[1] = new IIconContainer(){

            public IIcon getIcon() {
                return iIcons[1];
            }

            public IIcon getOverlayIcon() {
                return null;
            }

            public ResourceLocation getTextureFile() {
                return new ResourceLocation("bartworks:windmill_top");
            }
        };
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        Object[] ret = new ITexture[6];
        if (this.isClientSide()) {
            if (aFacing == aSide || aSide == 0) {
                GT_TileEntity_Windmill.iTextures[0] = TextureFactory.of((IIconContainer)iIconContainers[0]);
                Arrays.fill(ret, iTextures[0]);
            } else if (aSide == 1) {
                GT_TileEntity_Windmill.iTextures[1] = TextureFactory.of((IIconContainer)iIconContainers[1]);
                Arrays.fill(ret, iTextures[1]);
            } else {
                GT_TileEntity_Windmill.iTextures[2] = TextureFactory.of((IIconContainer)Textures.BlockIcons.COVER_WOOD_PLATE);
                Arrays.fill(ret, iTextures[2]);
            }
        }
        return ret;
    }

    public boolean isClientSide() {
        if (this.getBaseMetaTileEntity().getWorld() != null) {
            return this.getBaseMetaTileEntity().getWorld().field_72995_K ? FMLCommonHandler.instance().getSide() == Side.CLIENT : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 3, 11, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 11, 0, elementBudget, source, actor, false, true);
    }

    public float OutputMultiplier(BW_RotorBlock rotorBlock) {
        try {
            return ((BW_Stonage_Rotors)rotorBlock.rotorSlot.get().func_77973_b()).getmRotor();
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public int getSpeed(BW_RotorBlock rotorBlock) {
        try {
            return ((BW_Stonage_Rotors)rotorBlock.rotorSlot.get().func_77973_b()).getSpeed();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setRotorDamage(BW_RotorBlock rotorBlock, int damage) {
        try {
            ((BW_Stonage_Rotors)rotorBlock.rotorSlot.get().func_77973_b()).damageItemStack(rotorBlock.rotorSlot.get(), damage);
        }
        catch (Exception e) {
            rotorBlock.rotorSlot.damage(damage, false);
        }
    }
}

