/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaChemicalReactor
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaChemicalReactor>
implements ISurvivalConstructable {
    private byte glasTier;
    private static final int CASING_INDEX = 176;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_MegaChemicalReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ttttt", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "ttttt"}, {"tgggt", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", "teeet"}, {"tg~gt", " gcg ", " gcg ", " gcg ", " gcg ", " gcg ", " gcg ", " gcg ", "teret"}, {"tgggt", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", " ggg ", "teeet"}, {"ttttt", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "dptpd", "ttttt"}})).addElement(Character.valueOf('p'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)1)).addElement(Character.valueOf('t'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0)).addElement(Character.valueOf('d'), (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaChemicalReactor.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch}).casingIndex(176).dot(1).buildAndChain(GregTech_API.sBlockCasings8, 0)).addElement(Character.valueOf('r'), GT_HatchElement.Maintenance.newAny(176, 2)).addElement(Character.valueOf('e'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_TileEntity_MegaMultiBlockBase.TTEnabledEnergyHatchElement.INSTANCE.newAny(176, 3), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0)})).addElement(Character.valueOf('c'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)7)).addElement(Character.valueOf('g'), BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier)).build();

    public GT_TileEntity_MegaChemicalReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaChemicalReactor(String aName) {
        super(aName);
    }

    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Chemical Reactor").addInfo("Controller block for the Chemical Reactor").addInfo("What molecule do you want to synthesize").addInfo("Or you want to replace something in this molecule").addInfo("The structure is too complex!").addInfo("Follow the Structure Lib hologram projector to build the main structure.").addSeparator().beginStructureBlock(5, 5, 9, false).addController("Front center").addStructureInfo("46x Chemically Inert Machine Casing (minimum)").addStructureInfo("7x Fusion Coil Block").addStructureInfo("28x PTFE Pipe Casing").addStructureInfo("64x Borosilicate Glass Block (any tier)").addStructureInfo("The glass tier limits the Energy Input tier").addEnergyHatch("Hint block ", new int[]{3}).addMaintenanceHatch("Hint block ", new int[]{2}).addInputHatch("Hint block ", new int[]{1}).addInputBus("Hint block ", new int[]{1}).addOutputBus("Hint block ", new int[]{1}).addOutputHatch("Hint block ", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaChemicalReactor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48]};
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeChemicalReactor.png");
    }

    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tInputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tInputFluids, tInputs);
        boolean found_Recipe = false;
        int processed = 0;
        if (tRecipe != null) {
            found_Recipe = true;
            long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / (long)tRecipe.mEUt);
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tInputFluids, tInputs, (int)tMaxPara);
            this.updateSlots();
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = tCurrentPara;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = (long)tRecipe.mEUt * (long)processed;
            this.calculatePerfectOverclockedNessMulti(actualEUT, tRecipe.mDuration, nominalV);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            return true;
        }
        return false;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 2, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 2, 0, realBudget, source, actor, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glasTier = 0;
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 2, 0)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (LoaderReference.tectech && this.glasTier < 8 && (!this.areLazorsLowPowa() || this.areThingsNotProperlyTiered(this.getTecTechEnergyTunnels()) || this.areThingsNotProperlyTiered(this.getTecTechEnergyMultis()))) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        return true;
    }

    public IStructureDefinition<GT_TileEntity_MegaChemicalReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Optional.Method(modid="tectech")
    private boolean areThingsNotProperlyTiered(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (((GT_MetaTileEntity_TieredMachineBlock)tecTechEnergyMulti).mTier <= this.glasTier) continue;
                return true;
            }
        }
        return false;
    }
}

