/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaVacuumFreezer
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaVacuumFreezer>
implements ISurvivalConstructable {
    private int mCasing = 0;
    private static final int CASING_INDEX = 17;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_MegaVacuumFreezer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccc~ccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "c=============c", "ccccccccccccccc"}, {"ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc", "ccccccccccccccc"}})).addElement(Character.valueOf('='), GT_TileEntity_MegaMultiBlockBase.StructureElementAirNoHint.getInstance()).addElement(Character.valueOf('c'), (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaVacuumFreezer.class).atLeast(new IHatchElement[]{GT_TileEntity_MegaMultiBlockBase.TTEnabledEnergyHatchElement.INSTANCE, GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance}).casingIndex(17).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)1))})).build();

    public GT_TileEntity_MegaVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaVacuumFreezer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaVacuumFreezer(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Vacuum Freezer").addInfo("Controller Block for the Mega Vacuum Freezer").addInfo("Cools hot ingots and cells").addSeparator().beginStructureBlock(15, 15, 15, true).addController("Front center").addCasingInfo("Frost Proof Machine Casing", 900).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addInputHatch("Any casing", new int[]{1}).addOutputHatch("Any casing", new int[]{1}).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public IStructureDefinition<GT_TileEntity_MegaVacuumFreezer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 7, 7, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 7, 0, realBudget, source, actor, false, true);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sVacuumRecipes;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "VacuumFreezer.png");
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tInputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sVacuumRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tInputFluids, tInputs);
        boolean found_Recipe = false;
        int processed = 0;
        if (tRecipe != null) {
            found_Recipe = true;
            long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / (long)tRecipe.mEUt);
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tInputFluids, tInputs, (int)tMaxPara);
            this.updateSlots();
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = tCurrentPara;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = (long)tRecipe.mEUt * (long)processed;
            this.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, nominalV);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 7, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1 && (LoaderReference.tectech ? !this.getTecTechEnergyMultis().isEmpty() || !this.getTecTechEnergyTunnels().isEmpty() || !this.mEnergyHatches.isEmpty() : !this.mEnergyHatches.isEmpty()) && this.mCasing >= 900;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = aSide == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE_GLOW}).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_GLOW}).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17]};
        return rTexture;
    }
}

