/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.tiered;

import com.github.bartimaeusnek.bartworks.client.gui.GT_GUIContainer_RadioHatch;
import com.github.bartimaeusnek.bartworks.server.container.GT_Container_RadioHatch;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_RadioHatch
extends GT_MetaTileEntity_Hatch {
    private final int cap;
    public int sievert;
    private long timer = 1L;
    private long decayTime = 1L;
    private short[] colorForGUI;
    private byte mass;
    private String material;
    private byte coverage;
    private ItemStack lastUsedItem = null;
    private boolean lastFail = false;
    private GT_Recipe lastRecipe = null;

    public GT_MetaTileEntity_RadioHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.0.name"), StatCollector.func_74838_a((String)"tooltip.tile.tiereddsc.3.name") + " " + (aTier - 2) + " " + (aTier - 2 >= 2 ? StatCollector.func_74838_a((String)"tooltip.bw.kg.1.name") : StatCollector.func_74838_a((String)"tooltip.bw.kg.0.name")), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.1.name"), BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()}, new ITexture[0]);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public int getSievert() {
        return this.sievert - MathUtils.ceilInt((float)this.sievert / 100.0f * (float)this.coverage);
    }

    public short[] getColorForGUI() {
        if (this.colorForGUI != null) {
            return this.colorForGUI;
        }
        return new short[]{250, 250, 255};
    }

    public byte getMass() {
        return this.mass;
    }

    public byte getCoverage() {
        return this.coverage;
    }

    public long getDecayTime() {
        return this.decayTime;
    }

    public void setCoverage(short coverage) {
        int nu = coverage > 100 ? 100 : (coverage < 0 ? 0 : (int)((byte)coverage));
        this.coverage = (byte)nu;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_RadioHatch(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aPlayer.openGui((Object)"bartworks", 2, this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!aBaseMetaTileEntity.isClientSide()) {
            aBaseMetaTileEntity.openGUI(aPlayer);
        }
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        BaseMetaTileEntity myMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (myMetaTileEntity.isServerSide()) {
            if (this.mass > 0) {
                ++this.timer;
            }
            if (this.mass > 0 && (this.decayTime == 0L || this.decayTime > 0L && this.timer % this.decayTime == 0L)) {
                this.mass = (byte)(this.mass - 1);
                if (this.mass == 0) {
                    this.material = StatCollector.func_74838_a((String)"tooltip.bw.empty.name");
                    this.sievert = 0;
                }
                this.timer = 1L;
            }
            if (myMetaTileEntity.mTickTimer > myMetaTileEntity.mLastSoundTick + (long)GT_Values.ticksBetweenSounds && this.sievert > 0) {
                this.sendLoopStart((byte)1);
                myMetaTileEntity.mLastSoundTick = myMetaTileEntity.mTickTimer;
            }
            if (this.mass == 0) {
                ItemStack lStack = this.mInventory[0];
                if (lStack == null) {
                    return;
                }
                if (this.lastFail && GT_Utility.areStacksEqual((ItemStack)this.lastUsedItem, (ItemStack)lStack, (boolean)true)) {
                    return;
                }
                if (!this.lastFail && this.lastUsedItem != null && this.lastRecipe != null) {
                    if (GT_Utility.areStacksEqual((ItemStack)this.lastUsedItem, (ItemStack)lStack, (boolean)true)) {
                        this.mass = (byte)this.lastRecipe.mDuration;
                        this.decayTime = this.lastRecipe.mSpecialValue;
                        this.sievert = this.lastRecipe.mEUt;
                        this.material = this.lastUsedItem.func_82833_r();
                        --lStack.field_77994_a;
                        this.updateSlots();
                    } else {
                        this.lastRecipe = null;
                    }
                }
                if (this.lastRecipe == null || this.lastFail) {
                    this.lastRecipe = BWRecipes.instance.getMappingsFor((byte)4).findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, 0x7FFFFFF8L, null, new ItemStack[]{this.mInventory[0]});
                    if (this.lastRecipe == null) {
                        this.lastFail = true;
                        this.lastUsedItem = this.mInventory[0] == null ? null : this.mInventory[0].func_77946_l();
                    } else {
                        if (this.lastRecipe.mDuration > this.cap) {
                            this.lastFail = true;
                            this.lastUsedItem = this.mInventory[0].func_77946_l();
                            return;
                        }
                        this.lastFail = false;
                        this.lastUsedItem = this.mInventory[0].func_77946_l();
                        this.mass = (byte)this.lastRecipe.mDuration;
                        this.decayTime = this.lastRecipe.mSpecialValue;
                        this.sievert = this.lastRecipe.mEUt;
                        this.colorForGUI = new short[]{(short)this.lastRecipe.mChances[0], (short)this.lastRecipe.mChances[1], (short)this.lastRecipe.mChances[2]};
                        this.material = lStack.func_82833_r();
                        --lStack.field_77994_a;
                        this.updateSlots();
                    }
                }
            }
        }
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (this.sievert != 0) {
            return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.func_74838_a((String)this.material), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " " + this.sievert, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " " + this.mass, StatCollector.func_74838_a((String)"tooltip.tile.radhatch.5.name") + " " + (this.decayTime - this.timer % (this.decayTime * 60L)) + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.6.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.7.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.8.name") + "/" + (this.decayTime - this.timer % this.decayTime) / 20L / 60L / 60L + StatCollector.func_74838_a((String)"tooltip.tile.radhatch.9.name")};
        }
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.func_74838_a((String)"tooltip.bw.empty.name"), StatCollector.func_74838_a((String)"tooltip.tile.radhatch.3.name") + " 0", StatCollector.func_74838_a((String)"tooltip.tile.radhatch.4.name") + " 0"};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing() && BWRecipes.instance.getMappingsFor((byte)4).containsInput(aStack);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_RadioHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_RadioHatch(aPlayerInventory, aBaseMetaTileEntity, this.mName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMass", this.mass);
        aNBT.func_74774_a("mSv", (byte)(this.sievert - 100));
        aNBT.func_74774_a("mCoverage", this.coverage);
        aNBT.func_74768_a("mTextColor", BW_ColorUtil.getColorFromRGBArray(this.getColorForGUI()));
        if (this.material != null && !this.material.isEmpty()) {
            aNBT.func_74778_a("mMaterial", this.material);
        }
        aNBT.func_74772_a("timer", this.timer);
        aNBT.func_74772_a("decay", this.decayTime);
        super.saveNBTData(aNBT);
    }

    public long getTimer() {
        return this.timer;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.timer = aNBT.func_74763_f("timer");
        this.mass = aNBT.func_74771_c("mMass");
        this.sievert = aNBT.func_74771_c("mSv") + 100;
        this.coverage = aNBT.func_74771_c("mCoverage");
        this.colorForGUI = BW_ColorUtil.splitColorToRBGArray(aNBT.func_74762_e("mTextColor"));
        this.material = aNBT.func_74779_i("mMaterial");
        this.decayTime = aNBT.func_74763_f("decay");
        super.loadNBTData(aNBT);
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        ResourceLocation rl = new ResourceLocation("bartworks", "hatch.RadOn");
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((ResourceLocation)rl, (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }
}

