/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.neiHandler;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.bartimaeusnek.bartworks.common.items.LabParts;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.github.bartimaeusnek.bartworks.neiHandler.NEI_BW_Config;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.nei.GT_NEI_DefaultHandler;
import java.awt.Rectangle;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class BW_NEI_BioVatHandler
extends GT_NEI_DefaultHandler {
    public BW_NEI_BioVatHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_BW_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)GT_Values.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtech@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new BW_NEI_BioVatHandler(this.mRecipeMap);
    }

    public void drawExtras(int aRecipeIndex) {
        block7: {
            String[] recipeDesc;
            block5: {
                int[] tSpecialA;
                int[] lines;
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                int base = 70;
                                lines = new int[]{base, base + 8, base + 16, base + 24, base + 32, base + 40, base + 48, base + 56, base + 64};
                                int tEUt = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mEUt;
                                int tDuration = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mDuration;
                                recipeDesc = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.getNeiDesc();
                                if (recipeDesc != null) break block5;
                                if (tEUt != 0) {
                                    this.drawText(10, lines[0], this.trans("152", "Total: ") + GT_Utility.formatNumbers((long)((long)tDuration * (long)tEUt)) + " EU", -16777216);
                                    this.drawText(10, lines[1], this.trans("153", "Usage: ") + GT_Utility.formatNumbers((long)tEUt) + " EU/t", -16777216);
                                    if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                                        this.drawText(10, lines[2], this.trans("154", "Voltage: ") + GT_Utility.formatNumbers((long)(tEUt / this.mRecipeMap.mAmperage)) + " EU", -16777216);
                                        this.drawText(10, lines[3], this.trans("155", "Amperage: ") + GT_Utility.formatNumbers((long)this.mRecipeMap.mAmperage), -16777216);
                                    } else {
                                        this.drawText(10, lines[2], this.trans("156", "Voltage: unspecified"), -16777216);
                                        this.drawText(10, lines[3], this.trans("157", "Amperage: unspecified"), -16777216);
                                    }
                                }
                                if (tDuration > 0) {
                                    this.drawText(10, lines[4], this.trans("158", "Time: ") + GT_Utility.formatNumbers((double)(0.05 * (double)tDuration)) + this.trans("161", " secs"), -16777216);
                                }
                                int tSpecial = ((GT_NEI_DefaultHandler.CachedDefaultRecipe)this.arecipes.get((int)aRecipeIndex)).mRecipe.mSpecialValue;
                                tSpecialA = GT_TileEntity_BioVat.specialValueUnpack(tSpecial);
                                this.drawText(10, lines[5], StatCollector.func_74838_a((String)"nei.biovat.0.name") + " " + tSpecialA[0], -16777216);
                                if (tSpecialA[1] != -100 || !GT_Mod.gregtechproxy.mLowGravProcessing) break block6;
                                this.drawText(10, lines[7], this.trans("159", "Needs Low Gravity"), -16777216);
                                break block7;
                            }
                            if (tSpecialA[1] != -200 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block8;
                            this.drawText(10, lines[7], this.trans("160", "Needs Cleanroom"), -16777216);
                            break block7;
                        }
                        if (tSpecialA[1] != -300 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block9;
                        this.drawText(10, lines[7], this.trans("160", "Needs Cleanroom & LowGrav"), -16777216);
                        break block7;
                    }
                    if (tSpecialA[1] != -400) break block10;
                    this.drawText(10, lines[7], this.trans("216", "Deprecated Recipe"), -16777216);
                    break block7;
                }
                if (!GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePre) && !GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePost)) break block7;
                this.drawText(10, lines[6], (tSpecialA[2] == 1 ? StatCollector.func_74838_a((String)"nei.biovat.1.name") : StatCollector.func_74838_a((String)"nei.biovat.2.name")) + this.mRecipeMap.mNEISpecialValuePre + GT_Utility.formatNumbers((long)(tSpecialA[3] * this.mRecipeMap.mNEISpecialValueMultiplier)) + this.mRecipeMap.mNEISpecialValuePost, -16777216);
                break block7;
            }
            int tSpecial = 0;
            for (String descLine : recipeDesc) {
                this.drawText(10, 73 + 10 * tSpecial, descLine, -16777216);
                ++tSpecial;
            }
        }
    }

    private void loadLabPartRecipes(ItemStack aResult) {
        for (GT_NEI_DefaultHandler.CachedDefaultRecipe recipe : this.getCache()) {
            for (PositionedStack stack : recipe.mInputs) {
                if (stack.relx != 120 || stack.rely != 52 || !NEI_BW_Config.checkRecipe(aResult, Collections.singletonList(stack))) continue;
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack aResult) {
        if (aResult != null && aResult.func_77973_b() instanceof LabParts && aResult.func_77960_j() < 3 && aResult.func_77978_p() != null) {
            this.loadLabPartRecipes(aResult);
        } else {
            super.loadUsageRecipes(aResult);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        if (aResult != null && aResult.func_77973_b() instanceof LabParts && aResult.func_77960_j() < 3 && aResult.func_77978_p() != null) {
            this.loadLabPartRecipes(aResult);
        } else {
            super.loadCraftingRecipes(aResult);
        }
    }
}

