/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.API.IRadMaterial;
import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.client.textures.PrefixTextureLinker;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import ic2.core.IC2Potion;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BW_MetaGenerated_Items
extends GT_MetaGenerated_Item
implements IRadMaterial {
    public static final CreativeTabs metaTab = new CreativeTabs("bartworksMetaMaterials"){

        public Item func_78016_d() {
            return new ItemStack(Blocks.field_150366_p).func_77973_b();
        }
    };
    protected final OrePrefixes orePrefixes;
    protected final String itemTypeLocalizedName;

    public BW_MetaGenerated_Items(OrePrefixes orePrefixes, Object unused) {
        super("bwMetaGeneratedGTEnhancement" + orePrefixes.name(), (short)32766, (short)0);
        this.orePrefixes = orePrefixes;
        this.itemTypeLocalizedName = GT_LanguageManager.addStringLocalization((String)("bw.itemtype." + orePrefixes), (String)(orePrefixes.mLocalizedMaterialPre + "%material" + orePrefixes.mLocalizedMaterialPost));
    }

    public BW_MetaGenerated_Items(OrePrefixes orePrefixes) {
        super("bwMetaGenerated" + orePrefixes.name(), (short)32766, (short)0);
        this.orePrefixes = orePrefixes;
        this.itemTypeLocalizedName = GT_LanguageManager.addStringLocalization((String)("bw.itemtype." + orePrefixes), (String)(orePrefixes.mLocalizedMaterialPre + "%material" + orePrefixes.mLocalizedMaterialPost));
        this.func_77637_a(metaTab);
        for (Werkstoff w : Werkstoff.werkstoffHashSet) {
            ItemStack tStack = new ItemStack((Item)this, 1, (int)w.getmID());
            if (!w.hasItemType(this.orePrefixes)) continue;
            GT_OreDictUnificator.registerOre((Object)(this.orePrefixes.name() + w.getVarName()), (ItemStack)tStack);
        }
    }

    public boolean onEntityItemUpdate(EntityItem aItemEntity) {
        Werkstoff aMaterial;
        int aDamage;
        if (!(this.orePrefixes != OrePrefixes.dustImpure && this.orePrefixes != OrePrefixes.dustPure && this.orePrefixes != OrePrefixes.crushed || (aDamage = aItemEntity.func_92059_d().func_77960_j()) < 0 || aItemEntity.field_70170_p.field_72995_K || (aMaterial = Werkstoff.werkstoffHashMap.get((short)aDamage)) == null || aMaterial == Werkstoff.default_null_Werkstoff)) {
            int tX = MathHelper.func_76128_c((double)aItemEntity.field_70165_t);
            int tY = MathHelper.func_76128_c((double)aItemEntity.field_70163_u);
            int tZ = MathHelper.func_76128_c((double)aItemEntity.field_70161_v);
            Block tBlock = aItemEntity.field_70170_p.func_147439_a(tX, tY, tZ);
            byte tMetaData = (byte)aItemEntity.field_70170_p.func_72805_g(tX, tY, tZ);
            if (this.orePrefixes == OrePrefixes.dustImpure || this.orePrefixes == OrePrefixes.dustPure) {
                if (tBlock == Blocks.field_150383_bp && tMetaData > 0) {
                    aItemEntity.func_92058_a(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.dust, aMaterial, aItemEntity.func_92059_d().field_77994_a));
                    aItemEntity.field_70170_p.func_72921_c(tX, tY, tZ, tMetaData - 1, 3);
                    return true;
                }
            } else if (tBlock == Blocks.field_150383_bp && tMetaData > 0) {
                aItemEntity.func_92058_a(WerkstoffLoader.getCorrespondingItemStack(OrePrefixes.crushedPurified, aMaterial, aItemEntity.func_92059_d().field_77994_a));
                aItemEntity.field_70170_p.func_72921_c(tX, tY, tZ, tMetaData - 1, 3);
                return true;
            }
        }
        return false;
    }

    protected void addAdditionalToolTips(List aList, ItemStack aStack, EntityPlayer aPlayer) {
        Werkstoff werkstoff;
        if (this.orePrefixes == OrePrefixes.dustImpure || this.orePrefixes == OrePrefixes.dustPure) {
            aList.add(GT_LanguageManager.getTranslation((String)"metaitem.01.tooltip.purify"));
        }
        if (this.orePrefixes == OrePrefixes.crushed) {
            aList.add(GT_LanguageManager.getTranslation((String)"metaitem.01.tooltip.purify.2"));
        }
        if (aStack != null && aStack.func_77973_b() instanceof BW_MetaGenerated_Items && aStack.func_77960_j() == WerkstoffLoader.Tiberium.getmID()) {
            aList.add(GT_LanguageManager.getTranslation((String)"metaitem.01.tooltip.nqgen"));
        }
        if ((werkstoff = Werkstoff.werkstoffHashMap.get((short)this.getDamage(aStack))) != null) {
            String owner;
            String tooltip = werkstoff.getLocalizedToolTip();
            if (!tooltip.isEmpty()) {
                aList.add(tooltip);
            }
            if ((owner = werkstoff.getOwner()) != null) {
                aList.add(BW_Tooltip_Reference.ADDED_VIA_BARTWORKS.apply(owner));
            } else {
                aList.add(BW_Tooltip_Reference.ADDED_BY_BARTWORKS.get());
            }
        } else {
            aList.add(BW_Tooltip_Reference.ADDED_BY_BARTWORKS.get());
        }
    }

    public String func_77653_i(ItemStack aStack) {
        int aMetaData = aStack.func_77960_j();
        Werkstoff werkstoff = Werkstoff.werkstoffHashMap.get((short)aMetaData);
        if (werkstoff == null) {
            werkstoff = Werkstoff.default_null_Werkstoff;
        }
        return this.itemTypeLocalizedName.replace("%material", werkstoff.getLocalizedName());
    }

    public IIconContainer getIconContainer(int aMetaData) {
        if (Werkstoff.werkstoffHashMap.get((short)aMetaData) == null) {
            return null;
        }
        if (this.orePrefixes.mTextureIndex == -1) {
            return this.getIconContainerBartWorks(aMetaData);
        }
        return Werkstoff.werkstoffHashMap.get((Object)Short.valueOf((short)((short)aMetaData))).getTexSet().mTextures[this.orePrefixes.mTextureIndex];
    }

    protected IIconContainer getIconContainerBartWorks(int aMetaData) {
        if (SideReference.Side.Client) {
            return (IIconContainer)PrefixTextureLinker.texMap.get(this.orePrefixes).get(Werkstoff.werkstoffHashMap.get((short)aMetaData).getTexSet());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff == null || !werkstoff.hasItemType(this.orePrefixes)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, (int)werkstoff.getmID());
            aList.add(tStack);
        }
    }

    public short[] getRGBa(ItemStack aStack) {
        Werkstoff werkstoff = Werkstoff.werkstoffHashMap.get((short)this.getDamage(aStack));
        return werkstoff == null ? Materials._NULL.mRGBa : werkstoff.getRGBA();
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        super.func_77663_a(aStack, aWorld, aPlayer, aTimer, aIsInHand);
        if (aStack == null || aStack.func_77973_b() == null || !(aPlayer instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer bPlayer = (EntityPlayer)aPlayer;
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        if (w == null || w.getStats() == null) {
            return;
        }
        if (w.getStats().isToxic() && !GT_Utility.isWearingFullBioHazmat((EntityLivingBase)bPlayer)) {
            bPlayer.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 80, 4));
        }
        if (w.getStats().isRadioactive() && !GT_Utility.isWearingFullRadioHazmat((EntityLivingBase)bPlayer)) {
            bPlayer.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, 80, 4));
        }
    }

    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        Werkstoff tMaterial = Werkstoff.werkstoffHashMap.get((short)aMetaData);
        if (tMaterial == null) {
            return null;
        }
        IIconContainer tIcon = this.getIconContainer(aMetaData);
        if (tIcon != null) {
            return tIcon.getIcon();
        }
        return null;
    }

    public int getItemStackLimit(ItemStack aStack) {
        return this.orePrefixes.mDefaultStackSize;
    }

    @Override
    public int getRadiationLevel(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getStats().isRadioactive() ? (int)w.getStats().getProtons() : 0;
    }

    @Override
    public byte getAmountOfMaterial(ItemStack aStack) {
        return (byte)(this.orePrefixes == OrePrefixes.stick ? 1 : (this.orePrefixes == OrePrefixes.stickLong ? 2 : 0));
    }

    @Override
    public short[] getColorForGUI(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getRGBA();
    }

    @Override
    public String getNameForGUI(ItemStack aStack) {
        Werkstoff w = Werkstoff.werkstoffHashMap.get((short)aStack.func_77960_j());
        return w.getDefaultName();
    }

    public int getCapacity(ItemStack aStack) {
        return this.orePrefixes == OrePrefixes.capsule || this.orePrefixes == OrePrefixes.cell || this.orePrefixes == OrePrefixes.cellPlasma ? 1000 : (this.orePrefixes == WerkstoffLoader.cellMolten || this.orePrefixes == WerkstoffLoader.capsuleMolten ? 144 : 0);
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return this.orePrefixes == OrePrefixes.cell || this.orePrefixes == OrePrefixes.cellPlasma || this.orePrefixes == WerkstoffLoader.cellMolten ? Materials.Empty.getCells(1) : null;
    }
}

