/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.AfterLuVTierEnhacement;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class LuVTierEnhancer
implements Runnable {
    private static List<ItemStack> blackListForOsmiridium = new ArrayList<ItemStack>();

    @Override
    public void run() {
        List bufferedRecipeList = null;
        try {
            bufferedRecipeList = (List)FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        HashSet<ItemStack> LuVMachines = new HashSet<ItemStack>();
        LuVMachines.add(ItemRegistry.cal);
        OrePrefixes[] LuVMaterialsGenerated = new OrePrefixes[]{OrePrefixes.dust, OrePrefixes.ingot, OrePrefixes.plate, OrePrefixes.stick, OrePrefixes.stickLong, OrePrefixes.rotor, OrePrefixes.plateDouble, OrePrefixes.plateDense};
        Arrays.stream(ItemList.values()).filter(item -> item.toString().contains("LuV") && item.hasBeenSet()).forEach(item -> LuVMachines.add(item.get(1L, new Object[0])));
        if (LoaderReference.dreamcraft) {
            LuVTierEnhancer.addDreamcraftItemListItems(LuVMachines);
        }
        GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Casing_LuV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.REVERSIBLE | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES), (Object[])new Object[]{"PPP", "PwP", "PPP", Character.valueOf('P'), WerkstoffLoader.LuVTierMaterial.get(OrePrefixes.plate)});
        LuVTierEnhancer.replaceAllRecipes(LuVMachines, LuVMaterialsGenerated, bufferedRecipeList);
        AfterLuVTierEnhacement.run();
    }

    public static void addToBlackListForOsmiridiumReplacement(ItemStack stack) {
        blackListForOsmiridium.add(stack);
    }

    private static void replaceAllRecipes(Collection<ItemStack> LuVMachines, OrePrefixes[] LuVMaterialsGenerated, List<IRecipe> bufferedRecipeList) {
        LuVTierEnhancer.replaceOsmiridiumInLuVRecipes();
        for (GT_Recipe.GT_Recipe_AssemblyLine sAssemblylineRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
            for (ItemStack stack : LuVMachines) {
                LuVTierEnhancer.rewriteAsslineRecipes(stack, LuVMaterialsGenerated, sAssemblylineRecipe);
            }
        }
        for (GT_Recipe.GT_Recipe_Map map : GT_Recipe.GT_Recipe_Map.sMappings) {
            for (GT_Recipe recipe : map.mRecipeList) {
                for (ItemStack stack : LuVMachines) {
                    LuVTierEnhancer.rewriteMachineRecipes(stack, LuVMaterialsGenerated, recipe);
                }
            }
        }
        for (ItemStack stack : LuVMachines) {
            Predicate<Object> recipeFilter = obj -> obj instanceof GT_Shaped_Recipe && GT_Utility.areStacksEqual((ItemStack)((GT_Shaped_Recipe)obj).func_77571_b(), (ItemStack)stack, (boolean)true);
            LuVTierEnhancer.rewriteCraftingRecipes(bufferedRecipeList, LuVMaterialsGenerated, recipeFilter);
        }
    }

    private static void addDreamcraftItemListItems(Collection LuVMachines) {
        try {
            Class<?> customItemListClass = Class.forName("com.dreammaster.gthandler.CustomItemList");
            Method hasnotBeenSet = MethodUtils.getAccessibleMethod(customItemListClass, (String)"hasBeenSet", (Class[])new Class[0]);
            Method get = MethodUtils.getAccessibleMethod(customItemListClass, (String)"get", (Class[])new Class[]{Long.TYPE, Object[].class});
            for (Enum customItemList : (Enum[])FieldUtils.getField(customItemListClass, (String)"$VALUES", (boolean)true).get(null)) {
                if (!customItemList.toString().contains("LuV") || !((Boolean)hasnotBeenSet.invoke((Object)customItemList, new Object[0])).booleanValue()) continue;
                LuVMachines.add((ItemStack)get.invoke((Object)customItemList, 1, new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void rewriteCraftingRecipes(List<IRecipe> bufferedRecipeList, OrePrefixes[] LuVMaterialsGenerated, Predicate recipeFilter) {
        for (OrePrefixes prefixes : LuVMaterialsGenerated) {
            Consumer<Object> recipeAction = obj -> LuVTierEnhancer.doStacksContainAndReplace(null, ((GT_Shaped_Recipe)obj).getInput(), GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            CraftingManager.func_77594_a().func_77592_b().stream().filter(recipeFilter).forEach(recipeAction);
            bufferedRecipeList.stream().filter(recipeFilter).forEach(recipeAction);
        }
    }

    private static void rewriteMachineRecipes(ItemStack stack, OrePrefixes[] LuVMaterialsGenerated, GT_Recipe recipe) {
        if (LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : LuVMaterialsGenerated) {
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            }
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidOutputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
        if (LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mOutputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : LuVMaterialsGenerated) {
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mOutputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            }
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidOutputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
    }

    private static void rewriteAsslineRecipes(ItemStack stack, OrePrefixes[] LuVMaterialsGenerated, GT_Recipe.GT_Recipe_AssemblyLine recipe) {
        for (OrePrefixes prefixes : LuVMaterialsGenerated) {
            if (LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, stack, false, new ItemStack[0])) {
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
                LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            }
            if (!LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) continue;
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, new Object[]{recipe.mOutput}, GT_OreDictUnificator.get((OrePrefixes)prefixes, (Object)Materials.Chrome, (long)1L), true, WerkstoffLoader.LuVTierMaterial.get(prefixes));
        }
        if (LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mInputs, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
        if (LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) {
            LuVTierEnhancer.doStacksContainAndReplace((Object)recipe, recipe.mFluidInputs, Materials.Chrome.getMolten(1L), true, WerkstoffLoader.LuVTierMaterial.getMolten(1).getFluid());
        }
    }

    private static void replaceOsmiridiumInLuVRecipes() {
        Consumer<GT_Recipe> replace = gt_recipe -> {
            gt_recipe.mInputs = LuVTierEnhancer.replaceArrayWith(gt_recipe.mInputs, Materials.Osmiridium, WerkstoffLoader.Ruridit, gt_recipe);
        };
        GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.stream().filter(recipe_assemblyLine -> recipe_assemblyLine.mEUt <= 6000).forEach(recipe_assemblyLine -> {
            recipe_assemblyLine.mInputs = LuVTierEnhancer.replaceArrayWith(recipe_assemblyLine.mInputs, Materials.Osmiridium, WerkstoffLoader.Ruridit, recipe_assemblyLine);
        });
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList.stream().filter(gt_recipe -> (long)gt_recipe.mEUt < BW_Util.getTierVoltage(6) && !BW_Util.checkStackAndPrefix(gt_recipe.mOutputs[0]) && !LuVTierEnhancer.isOutputBlackListed(gt_recipe.mOutputs[0])).forEach(replace);
        GT_Recipe.GT_Recipe_Map.sAssemblylineVisualRecipes.mRecipeList.stream().filter(gt_recipe -> gt_recipe.mEUt <= 6000 && !LuVTierEnhancer.isOutputBlackListed(gt_recipe.mOutputs[0])).forEach(replace);
    }

    private static boolean isOutputBlackListed(ItemStack output) {
        return blackListForOsmiridium.stream().anyMatch(s -> s.func_77969_a(output));
    }

    private static ItemStack[] replaceArrayWith(ItemStack[] stackArray, Materials source, Werkstoff target, Object recipe) {
        boolean replaced = false;
        for (int i = 0; i < stackArray.length; ++i) {
            ItemStack stack = stackArray[i];
            if (!BW_Util.checkStackAndPrefix(stack)) continue;
            stackArray[i] = LuVTierEnhancer.replaceStackWith(stack, source, target, recipe);
        }
        return stackArray;
    }

    private static ItemStack replaceStackWith(ItemStack stack, Materials source, Werkstoff target, Object recipe) {
        ItemData ass = GT_OreDictUnificator.getAssociation((ItemStack)stack);
        if (ass.mMaterial.mMaterial.equals(source) && target.hasItemType(ass.mPrefix)) {
            stack = target.get(ass.mPrefix, stack.field_77994_a);
            if (recipe instanceof GT_Recipe) {
                ((GT_Recipe)recipe).setOwner("bartworks");
            } else if (recipe instanceof GT_Recipe.GT_Recipe_AssemblyLine) {
                // empty if block
            }
        }
        return stack;
    }

    private static boolean doStacksContainAndReplace(Object recipe, FluidStack[] stacks, FluidStack stack, boolean replace, Fluid ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)stack, (FluidStack)stacks[i])) continue;
            if (!replace) {
                return true;
            }
            int amount = stacks[i].amount;
            stacks[i] = new FluidStack(replacement[0], amount);
            replaced = true;
        }
        if (replace && replaced) {
            if (recipe instanceof GT_Recipe) {
                ((GT_Recipe)recipe).setOwner("bartworks");
            } else if (recipe instanceof GT_Recipe.GT_Recipe_AssemblyLine) {
                // empty if block
            }
        }
        return replaced;
    }

    private static boolean doStacksContainAndReplace(Object recipe, Object[] stacks, ItemStack stack, boolean replace, ItemStack ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            int amount;
            if (!GT_Utility.isStackValid((Object)stacks[i])) {
                if (!(stacks[i] instanceof ArrayList) || ((ArrayList)stacks[i]).size() <= 0 || !GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)((ArrayList)stacks[i]).get(0)), (boolean)true)) continue;
                if (!replace) {
                    return true;
                }
                amount = ((ItemStack)((ArrayList)stacks[i]).get((int)0)).field_77994_a;
                stacks[i] = new ArrayList();
                ((ArrayList)stacks[i]).add(BW_Util.setStackSize(replacement[0], amount));
                replaced = true;
                continue;
            }
            if (!GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)stacks[i]), (boolean)true)) continue;
            if (!replace) {
                return true;
            }
            amount = ((ItemStack)stacks[i]).field_77994_a;
            stacks[i] = BW_Util.setStackSize(replacement[0], amount);
            replaced = true;
        }
        if (replace && replaced) {
            if (recipe instanceof GT_Recipe) {
                ((GT_Recipe)recipe).setOwner("bartworks");
            } else if (recipe instanceof GT_Recipe.GT_Recipe_AssemblyLine) {
                // empty if block
            }
        }
        return replaced;
    }

    static {
        LuVTierEnhancer.addToBlackListForOsmiridiumReplacement(ItemList.Casing_MiningOsmiridium.get(1L, new Object[0]));
    }
}

