/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.processingLoaders;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.BioCultureLoader;
import com.github.bartimaeusnek.bartworks.common.loaders.BioItemList;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.system.material.BW_NonMeta_MaterialItems;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement.LuVTierEnhancer;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.LoadItemContainers;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.BioCulture;
import com.github.bartimaeusnek.bartworks.util.BioDNA;
import com.github.bartimaeusnek.bartworks.util.BioData;
import com.github.bartimaeusnek.bartworks.util.BioPlasmid;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import ic2.core.item.ItemFluidCell;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;

public class AdditionalRecipes {
    private static BWRecipes.BW_Recipe_Map_LiquidFuel sAcidGenFuels = (BWRecipes.BW_Recipe_Map_LiquidFuel)BWRecipes.instance.getMappingsFor((byte)2);
    private static BWRecipes.BacteriaVatRecipeMap sBacteriaVat = (BWRecipes.BacteriaVatRecipeMap)BWRecipes.instance.getMappingsFor((byte)1);
    private static GT_Recipe.GT_Recipe_Map sBiolab = BWRecipes.instance.getMappingsFor((byte)0);

    private static void runBWRecipes() {
        if (ConfigHandler.BioLab) {
            FluidStack[] easyFluids;
            BioData DNA;
            FluidStack[] dnaFluid = new FluidStack[]{LoaderReference.gendustry ? FluidRegistry.getFluidStack((String)"liquiddna", (int)1000) : Materials.Biomass.getFluid(1000L)};
            for (ItemStack stack : BioItemList.getAllPetriDishes()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
                if (DNA == null) continue;
                ItemStack Detergent = BioItemList.getOther(1);
                ItemStack DNAFlask = BioItemList.getDNASampleFlask(null);
                ItemStack EthanolCell = Materials.Ethanol.getCells(1);
                sBiolab.addFakeRecipe(false, new ItemStack[]{stack, DNAFlask, Detergent, EthanolCell}, new ItemStack[]{BioItemList.getDNASampleFlask(BioDNA.convertDataToDNA(DNA)), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)Materials.Empty, (long)1L)}, (Object)BioItemList.mBioLabParts[0], new int[]{DNA.getChance(), 10000}, new FluidStack[]{FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}, null, 500, BW_Util.getMachineVoltageFromTier(3 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllDNASampleFlasks()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p());
                if (DNA == null) continue;
                ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)Outp, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)Outp, (String)DNA.getName());
                sBiolab.addFakeRecipe(false, new ItemStack[]{stack, FluidLoader.BioLabFluidCells[0], FluidLoader.BioLabFluidCells[3], ItemList.Tool_DataOrb.get(1L, new Object[0])}, new ItemStack[]{Outp, ItemList.Cell_Universal_Fluid.get(2L, new Object[0])}, (Object)BioItemList.mBioLabParts[1], new int[]{DNA.getChance(), 10000}, dnaFluid, null, 500, BW_Util.getMachineVoltageFromTier(4 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllPlasmidCells()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p());
                if (DNA == null) continue;
                ItemStack inp = ItemList.Tool_DataOrb.get(0L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)inp, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)inp, (String)DNA.getName());
                ItemStack inp2 = ItemList.Tool_DataOrb.get(0L, new Object[0]);
                Behaviour_DataOrb.setDataTitle((ItemStack)inp2, (String)"DNA Sample");
                Behaviour_DataOrb.setDataName((ItemStack)inp2, (String)BioCultureLoader.BIO_DATA_BETA_LACMATASE.getName());
                sBiolab.addFakeRecipe(false, new ItemStack[]{FluidLoader.BioLabFluidCells[1], BioItemList.getPlasmidCell(null), inp, inp2}, new ItemStack[]{stack, ItemList.Cell_Universal_Fluid.get(1L, new Object[0])}, (Object)BioItemList.mBioLabParts[2], new int[]{DNA.getChance(), 10000}, dnaFluid, null, 500, BW_Util.getMachineVoltageFromTier(4 + DNA.getTier()), 0);
            }
            for (ItemStack stack : BioItemList.getAllPetriDishes()) {
                DNA = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("DNA"));
                BioData Plasmid = BioData.getBioDataFromNBTTag(stack.func_77978_p().func_74775_l("Plasmid"));
                if (DNA.getName() == Plasmid.getName()) continue;
                sBiolab.addFakeRecipe(true, new ItemStack[]{BioItemList.getPetriDish(BioCulture.getBioCulture(DNA.getName())), BioItemList.getPlasmidCell(BioPlasmid.convertDataToPlasmid(Plasmid)), FluidLoader.BioLabFluidCells[2]}, new ItemStack[]{stack, ItemList.Cell_Universal_Fluid.get(1L, new Object[0])}, (Object)BioItemList.mBioLabParts[3], new int[]{10000, 10000}, new FluidStack[]{FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}, null, 500, BW_Util.getMachineVoltageFromTier(6), 0);
            }
            ItemStack Outp = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            Behaviour_DataOrb.setDataTitle((ItemStack)Outp, (String)"DNA Sample");
            Behaviour_DataOrb.setDataName((ItemStack)Outp, (String)"Any DNA");
            sBiolab.addFakeRecipe(false, new ItemStack[]{BioItemList.getPetriDish(null), BioItemList.getOther(4), ItemList.Circuit_Chip_Stemcell.get(2L, new Object[0]), Outp}, new ItemStack[]{BioItemList.getPetriDish(null).func_151001_c("The Culture made from DNA")}, (Object)BioItemList.mBioLabParts[4], new int[]{7500, 10000}, new FluidStack[]{new FluidStack(dnaFluid[0].getFluid(), 9000)}, null, 500, BW_Util.getMachineVoltageFromTier(6), 0);
            for (FluidStack fluidStack : easyFluids = new FluidStack[]{Materials.Water.getFluid(1000L), FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000)}) {
                for (BioCulture bioCulture : BioCulture.BIO_CULTURE_ARRAY_LIST) {
                    if (!bioCulture.isBreedable() || bioCulture.getTier() != 0) continue;
                    sBacteriaVat.addRecipe(new BWRecipes.BacteriaVatRecipe(true, new ItemStack[]{GT_Utility.getIntegratedCircuit((int)0), new ItemStack(Items.field_151102_aT, 64)}, null, BioItemList.getPetriDish(bioCulture), null, new FluidStack[]{fluidStack}, new FluidStack[]{new FluidStack(bioCulture.getFluid(), 10)}, 1000, BW_Util.getMachineVoltageFromTier(3), 0), true);
                    sBiolab.addRecipe((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{BioItemList.getPetriDish(null), fluidStack.equals((Object)Materials.Water.getFluid(1000L)) ? Materials.Water.getCells(1) : ItemFluidCell.getUniversalFluidCell((FluidStack)FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)1000))}, new ItemStack[]{BioItemList.getPetriDish(bioCulture), fluidStack.equals((Object)Materials.Water.getFluid(1000L)) ? Materials.Empty.getCells(1) : ItemList.Cell_Universal_Fluid.get(1L, new Object[0])}, null, new int[]{bioCulture.getChance(), 10000}, new FluidStack[]{new FluidStack(bioCulture.getFluid(), 1000)}, null, 500, BW_Util.getMachineVoltageFromTier(3), 0));
                }
            }
        }
        sAcidGenFuels.addLiquidFuel(Materials.PhosphoricAcid, 36);
        sAcidGenFuels.addLiquidFuel(Materials.DilutedHydrochloricAcid, 14);
        sAcidGenFuels.addLiquidFuel(Materials.HypochlorousAcid, 30);
        sAcidGenFuels.addLiquidFuel(Materials.HydrofluoricAcid, 40);
        sAcidGenFuels.addLiquidFuel(Materials.HydrochloricAcid, 28);
        sAcidGenFuels.addLiquidFuel(Materials.NitricAcid, 24);
        sAcidGenFuels.addLiquidFuel(Materials.Mercury, 32);
        sAcidGenFuels.addLiquidFuel(Materials.DilutedSulfuricAcid, 9);
        sAcidGenFuels.addLiquidFuel(Materials.SulfuricAcid, 18);
        sAcidGenFuels.addLiquidFuel(Materials.AceticAcid, 11);
        sAcidGenFuels.addMoltenFuel(Materials.Redstone, 10);
    }

    public static void run() {
        int i;
        AdditionalRecipes.runBWRecipes();
        GT_Values.RA.addImplosionRecipe(WerkstoffLoader.RawAdemicSteel.get(OrePrefixes.dust), 4, WerkstoffLoader.AdemicSteel.get(OrePrefixes.dust), null);
        ((BWRecipes.BW_Recipe_Map_LiquidFuel)BWRecipes.instance.getMappingsFor((byte)2)).addLiquidFuel(WerkstoffLoader.FormicAcid.getBridgeMaterial(), 40);
        GT_Values.RA.addBlastRecipe(WerkstoffLoader.YttriumOxide.get(OrePrefixes.dustSmall, 2), WerkstoffLoader.Thorianit.get(OrePrefixes.dustSmall, 2), Materials.Glass.getMolten(144L), null, new ItemStack(ItemRegistry.bw_glasses[0], 1, 12), null, 800, BW_Util.getMachineVoltageFromTier(5), 3663);
        GT_Values.RA.addSifterRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified), new ItemStack[]{WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), WerkstoffLoader.Thorianit.get(OrePrefixes.dust), Materials.Thorium.getDust(1), Materials.Thorium.getDust(1), WerkstoffLoader.Thorium232.get(OrePrefixes.dust)}, new int[]{7000, 1300, 700, 600, 300, 100}, 400, BW_Util.getMachineVoltageFromTier(5));
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 9), Materials.Aluminium.getDust(4), null, null, Materials.Thorium.getDust(3), Materials.Aluminiumoxide.getDust(10), 1000);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 3), Materials.Magnesium.getDust(2), null, null, Materials.Thorium.getDust(1), Materials.Magnesia.getDust(4), 1000);
        GT_Values.RA.addChemicalRecipe(WerkstoffLoader.Thorianit.get(OrePrefixes.crushed), ItemList.Crop_Drop_Thorium.get(9L, new Object[0]), Materials.Water.getFluid(1000L), Materials.Thorium.getMolten(144L), WerkstoffLoader.Thorianit.get(OrePrefixes.crushedPurified, 4), 96, 24);
        GT_Values.RA.addBlastRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Quartzite, (long)40L), Materials.Amethyst.getDust(10), GT_Values.NF, GT_Values.NF, WerkstoffLoader.Prasiolite.get(OrePrefixes.gemFlawed, 20), GT_Values.NI, 800, BW_Util.getMachineVoltageFromTier(2), 500);
        GT_Values.RA.addPrimitiveBlastRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Quartzite, (long)40L), Materials.Amethyst.getDust(10), 6, WerkstoffLoader.Prasiolite.get(OrePrefixes.gemFlawed, 20), GT_Values.NI, 800);
        GT_Values.RA.addChemicalRecipe(Materials.Yttrium.getDust(2), GT_Utility.getIntegratedCircuit((int)5), Materials.Oxygen.getGas(3000L), GT_Values.NF, WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust, 5), 4096, BW_Util.getMachineVoltageFromTier(1));
        GT_Recipe.GT_Recipe_Map.sBlastRecipes.addRecipe(false, new ItemStack[]{WerkstoffLoader.Zirconium.get(OrePrefixes.dust, 10), WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust)}, new ItemStack[]{WerkstoffLoader.YttriumOxide.get(OrePrefixes.dust), WerkstoffLoader.CubicZirconia.get(OrePrefixes.gemFlawed, 40)}, null, null, new FluidStack[]{Materials.Oxygen.getGas(20000L)}, null, 57600, BW_Util.getMachineVoltageFromTier(3), 2953);
        GT_Values.RA.addBlastRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushed, (Object)Materials.Lead, (long)10L), GT_Utility.getIntegratedCircuit((int)17), GT_Values.NF, GT_Values.NF, Materials.Lead.getIngots(10), Materials.Tellurium.getNuggets(20), 800, BW_Util.getMachineVoltageFromTier(2), 722);
        GT_Values.RA.addFusionReactorRecipe(Materials.Plutonium.getMolten(48L), Materials.Beryllium.getMolten(48L), WerkstoffLoader.Californium.getMolten(48), 240, 49152, 480000000);
        GT_Values.RA.addFusionReactorRecipe(WerkstoffLoader.Californium.getMolten(32), WerkstoffLoader.Calcium.getMolten(144), WerkstoffLoader.Oganesson.getFluidOrGas(144), 420, 49152, 600000000);
        GT_Values.RA.addDistillationTowerRecipe(Materials.LiquidAir.getFluid(100000000L), new FluidStack[]{Materials.Nitrogen.getGas(78084000L), Materials.Oxygen.getGas(20946000L), Materials.Argon.getGas(934000L), Materials.CarbonDioxide.getGas(40700L), WerkstoffLoader.Neon.getFluidOrGas(1818), Materials.Helium.getGas(524L), Materials.Methane.getGas(180L), WerkstoffLoader.Krypton.getFluidOrGas(114), Materials.Hydrogen.getGas(55L), WerkstoffLoader.Xenon.getFluidOrGas(9)}, null, 7500, BW_Util.getMachineVoltageFromTier(4));
        GT_Values.RA.addAutoclaveRecipe(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust), WerkstoffLoader.Neon.getFluidOrGas(1000), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemChipped, 9), 9000, 4500, BW_Util.getMachineVoltageFromTier(5));
        GT_Values.RA.addAutoclaveRecipe(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust), WerkstoffLoader.Krypton.getFluidOrGas(1000), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), 10000, 4500, BW_Util.getMachineVoltageFromTier(5));
        GT_Values.RA.addCentrifugeRecipe(GT_Utility.getIntegratedCircuit((int)1), GT_Values.NI, Materials.Milk.getFluid(10000L), Materials.Water.getFluid(8832L), Materials.Sugar.getDustSmall(21), Materials.Calcium.getDustTiny(1), Materials.Magnesium.getDustTiny(1), Materials.Potassium.getDustTiny(1), Materials.Sodium.getDustTiny(4), Materials.Phosphor.getDustTiny(1), new int[]{10000, 10000, 1000, 10000, 1000, 1000}, 50, 120);
        GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), ItemList.NandChip.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeSMD.get(4L, new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get(4L, new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get(4L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(4)}, null, null, new FluidStack[]{Materials.SolderingAlloy.getMolten(36L)}, null, 750, BW_Util.getMachineVoltageFromTier(1), -200));
        for (i = 1; i <= 6; ++i) {
            GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gem), BW_Meta_Items.getNEWCIRCUITS().getStack(i + 3), ItemList.Circuit_Parts_DiodeSMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get((long)((i + 1) * 4), new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get((long)((i + 1) * 4), new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(i + 4)}, null, null, new FluidStack[]{Materials.SolderingAlloy.getMolten((long)((i + 1) * 36))}, null, (i + 1) * 750, BW_Util.getMachineVoltageFromTier(i + 1), -200));
        }
        for (i = 7; i <= 10; ++i) {
            GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(3), WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.gemExquisite, 1), BW_Meta_Items.getNEWCIRCUITS().getStack(i + 3), ItemList.Circuit_Parts_DiodeSMD.get((long)((i + 6) * 4), new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get((long)((i + 6) * 4), new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get((long)((i + 6) * 4), new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStack(i + 4)}, null, null, new FluidStack[]{Materials.SolderingAlloy.getMolten((long)((i + 1) * 144))}, null, (i + 1) * 1500, BW_Util.getMachineVoltageFromTier(i + 1), -200));
        }
        GT_Recipe.GT_Recipe_Map.sSmallNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.bolt)}, new ItemStack[0], null, null, null, 0, 0, 12500);
        GT_Recipe.GT_Recipe_Map.sLargeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stick)}, new ItemStack[0], null, null, null, 0, 0, 62500);
        try {
            Class<GT_Recipe.GT_Recipe_Map> map = GT_Recipe.GT_Recipe_Map.class;
            GT_Recipe.GT_Recipe_Map sHugeNaquadahReactorFuels = (GT_Recipe.GT_Recipe_Map)FieldUtils.getField(map, (String)"sHugeNaquadahReactorFuels").get(null);
            GT_Recipe.GT_Recipe_Map sExtremeNaquadahReactorFuels = (GT_Recipe.GT_Recipe_Map)FieldUtils.getField(map, (String)"sExtremeNaquadahReactorFuels").get(null);
            GT_Recipe.GT_Recipe_Map sUltraHugeNaquadahReactorFuels = (GT_Recipe.GT_Recipe_Map)FieldUtils.getField(map, (String)"sUltraHugeNaquadahReactorFuels").get(null);
            sHugeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)}, new ItemStack[0], null, null, null, 0, 0, 125000);
            sExtremeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stick)}, new ItemStack[0], null, null, null, 0, 0, 31250);
            sUltraHugeNaquadahReactorFuels.addRecipe(true, new ItemStack[]{WerkstoffLoader.Tiberium.get(OrePrefixes.stickLong)}, new ItemStack[0], null, null, null, 0, 0, 125000);
        }
        catch (IllegalAccessException | NullPointerException exception) {
            // empty catch block
        }
        LoadItemContainers.run();
        GT_Values.RA.addCannerRecipe(ItemList.Large_Fluid_Cell_TungstenSteel.get(1L, new Object[0]), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 3), BW_NonMeta_MaterialItems.TiberiumCell_1.get(1L, new Object[0]), null, 30, 16);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_1.get(2L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.TungstenSteel, (long)4L), BW_NonMeta_MaterialItems.TiberiumCell_2.get(1L, new Object[0]), 100, 400);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_1.get(4L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)6L), BW_NonMeta_MaterialItems.TiberiumCell_4.get(1L, new Object[0]), 150, 400);
        GT_Values.RA.addAssemblerRecipe(BW_NonMeta_MaterialItems.TiberiumCell_2.get(2L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)Materials.TungstenSteel, (long)4L), BW_NonMeta_MaterialItems.TiberiumCell_4.get(1L, new Object[0]), 100, 400);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemList.NaquadahCell_1.get(32L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.TungstenSteel, (long)64L), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64), WerkstoffLoader.Tiberium.get(OrePrefixes.dust, 64)}, null, BW_NonMeta_MaterialItems.TheCoreCell.get(1L, new Object[0]), 100, BW_Util.getMachineVoltageFromTier(6));
        GregTech_API.sAfterGTPostload.add(new LuVTierEnhancer());
        AdditionalRecipes.oldGThelperMethod();
    }

    private static void oldGThelperMethod() {
        Werkstoff werkstoff = WerkstoffLoader.Oganesson;
        Materials werkstoffBridgeMaterial = null;
        boolean aElementSet = false;
        for (Element e : Element.values()) {
            if (!e.toString().equals("Uuo")) continue;
            werkstoffBridgeMaterial = werkstoff.getBridgeMaterial() != null ? werkstoff.getBridgeMaterial() : new Materials(-1, werkstoff.getTexSet(), 0.0f, 0, 0, false, werkstoff.getDefaultName(), werkstoff.getDefaultName());
            werkstoffBridgeMaterial.mElement = e;
            e.mLinkedMaterials.add(werkstoffBridgeMaterial);
            aElementSet = true;
            werkstoff.setBridgeMaterial(werkstoffBridgeMaterial);
            break;
        }
        if (!aElementSet) {
            return;
        }
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.cell, werkstoffBridgeMaterial, (ItemStack)werkstoff.get(OrePrefixes.cell), (boolean)false);
        try {
            Field f = Materials.class.getDeclaredField("MATERIALS_MAP");
            f.setAccessible(true);
            Map MATERIALS_MAP = (Map)f.get(null);
            MATERIALS_MAP.remove(werkstoffBridgeMaterial.mName);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        ItemStack scannerOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
        Behaviour_DataOrb.setDataTitle((ItemStack)scannerOutput, (String)"Elemental-Scan");
        Behaviour_DataOrb.setDataName((ItemStack)scannerOutput, (String)werkstoff.getToolTip());
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{werkstoff.get(OrePrefixes.cell)}, new ItemStack[]{scannerOutput}, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, null, (int)(werkstoffBridgeMaterial.getMass() * 8192L), 30, 0));
        GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, (GT_Recipe)new BWRecipes.DynamicGTRecipe(false, new ItemStack[]{Materials.Empty.getCells(1)}, new ItemStack[]{werkstoff.get(OrePrefixes.cell)}, scannerOutput, null, new FluidStack[]{Materials.UUMatter.getFluid(werkstoffBridgeMaterial.getMass())}, null, (int)(werkstoffBridgeMaterial.getMass() * 512L), 30, 0));
    }
}

