/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tgregworks;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Property;
import tconstruct.library.TConstructRegistry;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.integration.TGregRegistry;
import vexatos.tgregworks.item.ItemTGregPart;
import vexatos.tgregworks.reference.Config;

@Mod(modid="bartworkscrossmodtgregworkscontainer", name="BartWorks Mod Additions - TGregworks Container", version="0.5.86", dependencies="required-after:IC2; required-after:gregtech; required-after:bartworks;before:TGregworks;before:miscutils; ")
public class MaterialsInjector {
    public static final String NAME = "BartWorks Mod Additions - TGregworks Container";
    public static final String VERSION = "0.5.86";
    public static final String MOD_ID = "bartworkscrossmodtgregworkscontainer";
    private static HashMap<Materials, Property> configProps;
    private static ArrayList<Integer> configIDs;
    private static Method getGlobalMultiplierMethod;
    private static Method getGlobalMultiplierMethodTwoArguments;
    private static Method getMultiplierMethod;
    private static Method getMaterialIDMethod;
    private static Method getReinforcedLevelMethod;
    private static Method getStoneboundLevelMethod;

    @Mod.EventHandler
    public void init(FMLInitializationEvent init) {
        if (LoaderReference.TGregworks) {
            MaterialsInjector.preinit();
            MaterialsInjector.run();
        }
    }

    private static void preinit() {
        try {
            MaterialsInjector.getFields();
            MaterialsInjector.getMethodes();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            MainMod.LOGGER.catching((Throwable)e);
            FMLCommonHandler.instance().exitJava(1, true);
        }
    }

    private static void getFields() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        Field configPropsField = TGregRegistry.class.getDeclaredField("configProps");
        configPropsField.setAccessible(true);
        configProps = (HashMap)configPropsField.get(TGregworks.registry);
        Field configIDsField = TGregRegistry.class.getDeclaredField("configIDs");
        configIDsField.setAccessible(true);
        configIDs = (ArrayList)configIDsField.get(TGregworks.registry);
    }

    private static void getMethodes() throws NoSuchMethodException, SecurityException {
        getGlobalMultiplierMethod = TGregRegistry.class.getDeclaredMethod("getGlobalMultiplier", String.class);
        getGlobalMultiplierMethod.setAccessible(true);
        getGlobalMultiplierMethodTwoArguments = TGregRegistry.class.getDeclaredMethod("getGlobalMultiplier", String.class, Double.TYPE);
        getGlobalMultiplierMethodTwoArguments.setAccessible(true);
        getMultiplierMethod = TGregRegistry.class.getDeclaredMethod("getMultiplier", Materials.class, String.class);
        getMultiplierMethod.setAccessible(true);
        getMaterialIDMethod = TGregRegistry.class.getDeclaredMethod("getMaterialID", Materials.class);
        getMaterialIDMethod.setAccessible(true);
        getReinforcedLevelMethod = TGregRegistry.class.getDeclaredMethod("getReinforcedLevel", Materials.class);
        getReinforcedLevelMethod.setAccessible(true);
        getStoneboundLevelMethod = TGregRegistry.class.getDeclaredMethod("getStoneboundLevel", Materials.class);
        getStoneboundLevelMethod.setAccessible(true);
    }

    public static void run() {
        MainMod.LOGGER.info("Registering TGregworks - BartWorks tool parts.");
        Werkstoff.werkstoffHashSet.stream().filter(x -> x.hasItemType(OrePrefixes.gem) || x.hasItemType(OrePrefixes.plate)).map(Werkstoff::getBridgeMaterial).filter(x -> x.mMetaItemSubID == -1).filter(x -> x.mDurability != 0).forEach(m -> {
            MaterialsInjector.setConfigProps(m);
            MaterialsInjector.registerParts(m);
        });
        configProps.clear();
        configIDs.clear();
        ItemTGregPart.toolMaterialNames = TGregworks.registry.toolMaterialNames;
    }

    private static void registerParts(Materials m) {
        try {
            TGregworks.registry.toolMaterialNames.add(m.mDefaultLocalName);
            int matID = (Integer)getMaterialIDMethod.invoke((Object)TGregworks.registry, m);
            MaterialsInjector.addToolMaterial(matID, m);
            MaterialsInjector.addBowMaterial(matID, m);
            MaterialsInjector.addArrowMaterial(matID, m);
            TGregworks.registry.matIDs.put(m, matID);
            TGregworks.registry.materialIDMap.put(matID, m);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            MainMod.LOGGER.catching((Throwable)e);
            FMLCommonHandler.instance().exitJava(1, true);
        }
    }

    private static void setConfigProps(Materials m) {
        if (TGregworks.config.get("enable", m.mName, true).getBoolean(true)) {
            TGregworks.registry.toolMaterials.add(m);
            Property configProp = TGregworks.config.get(Config.onMaterial((String)"material-id"), m.mName, 0, null, 0, 100000);
            configProps.put(m, configProp);
            configIDs.add(configProp.getInt());
        }
    }

    private static void addToolMaterial(int matID, Materials m) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TConstructRegistry.addToolMaterial((int)matID, (String)m.mName, (String)m.mLocalizedName, (int)m.mToolQuality, (int)((int)((float)m.mDurability * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "durability")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "durability")).floatValue())), (int)((int)(m.mToolSpeed * 100.0f * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "miningspeed")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "miningspeed")).floatValue())), (int)((int)((float)m.mToolQuality * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "attack")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "attack")).floatValue())), (float)(((float)m.mToolQuality - 0.5f) * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "handlemodifier")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "handlemodifier")).floatValue()), (int)((Integer)getReinforcedLevelMethod.invoke((Object)TGregworks.registry, m)), (float)((Float)getStoneboundLevelMethod.invoke((Object)TGregworks.registry, m)).floatValue(), (String)"", (int)(m.getRGBA()[0] << 16 | m.getRGBA()[1] << 8 | m.getRGBA()[2]));
    }

    private static void addBowMaterial(int matID, Materials m) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TConstructRegistry.addBowMaterial((int)matID, (int)((int)((float)m.mToolQuality * 10.0f * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "bowdrawspeed")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "bowdrawspeed")).floatValue())), (float)(((float)m.mToolQuality - 0.5f) * ((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "bowflightspeed")).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "bowflightspeed")).floatValue()));
    }

    private static void addArrowMaterial(int matID, Materials m) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TConstructRegistry.addArrowMaterial((int)matID, (float)((float)((double)m.getMass() / 10.0 * (double)((Float)getGlobalMultiplierMethod.invoke((Object)TGregworks.registry, "arrowmass")).floatValue() * (double)((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "arrowmass")).floatValue())), (float)(((Float)getGlobalMultiplierMethodTwoArguments.invoke((Object)TGregworks.registry, "arrowfragility", 0.9)).floatValue() * ((Float)getMultiplierMethod.invoke((Object)TGregworks.registry, m, "arrowfragility")).floatValue()));
    }
}

