/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerMethodProcess;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ItemStackTransformer
extends TransformerMethodProcess {
    private String entityPlayerClassName;
    private String itemStackClassName;
    private String destroyMethodName;

    public ItemStackTransformer() {
        super("net.minecraft.item.ItemStack", "func_77972_a", new String[]{"damageItem", "(ILnet/minecraft/entity/EntityLivingBase;)V"});
    }

    @Override
    void processMethod(MethodNode method) {
        InsnList newList = new InsnList();
        for (AbstractInsnNode node : method.instructions) {
            if (node instanceof MethodInsnNode && node.getOpcode() == 182) {
                MethodInsnNode methNode = (MethodInsnNode)node;
                if (methNode.owner.equals(this.entityPlayerClassName) && methNode.name.equals(this.destroyMethodName) && methNode.desc.equals("()V")) {
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "onBowStackDepleted", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    continue;
                }
            }
            newList.add(node);
        }
        method.instructions = newList;
    }

    @Override
    void setupMappings() {
        super.setupMappings();
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.destroyMethodName = BattlegearTranslator.getMapedMethodName("func_71028_bD", "destroyCurrentEquippedItem");
    }
}

