/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.shield;

import mods.battlegear2.api.ISensible;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ShieldType {
    public static final ShieldType WOOD = new ShieldType("wood", 0.05f, 0.05f, 40, 15, -4417438).setRepair(new ItemStack(Blocks.field_150344_f), IDSensible.INSTANCE);
    public static final ShieldType HIDE = new ShieldType("hide", 0.033333335f, 0.05f, 40, 12, -6600661).setRepair(new ItemStack(Items.field_151116_aA), IDSensible.INSTANCE);
    public static final ShieldType IRON = new ShieldType("iron", 0.016666668f, 0.05f, 120, 9, -5460820).setRepair(new ItemStack(Items.field_151042_j), IDSensible.INSTANCE);
    public static final ShieldType DIAMOND = new ShieldType("diamond", 0.01f, 0.05f, 263, 10, -14434369).setRepair(new ItemStack(Items.field_151045_i), IDSensible.INSTANCE);
    public static final ShieldType GOLD = new ShieldType("gold", 0.025f, 0.05f, 56, 25, -5725184).setRepair(new ItemStack(Items.field_151043_k), IDSensible.INSTANCE);
    private final float decayRate;
    private final float damageDecay;
    private final String name;
    private final int enchantability;
    private final int maxDamage;
    private final int defaultRGB;
    private ItemStack repairingMaterial;
    private ISensible<ItemStack> comparator;

    public ShieldType(String name, float decayRate, float damageDecay, int maxDamage, int enchantability, int defaultColour) {
        this.name = name;
        this.decayRate = decayRate;
        this.damageDecay = damageDecay;
        this.enchantability = enchantability;
        this.maxDamage = maxDamage;
        this.defaultRGB = defaultColour;
    }

    private ShieldType(String name, NBTTagCompound compound) {
        this.name = name;
        this.decayRate = compound.func_74760_g("DecayRate");
        this.damageDecay = compound.func_74760_g("DamageDecay");
        this.maxDamage = compound.func_74762_e("MaxDamage");
        this.enchantability = compound.func_74762_e("Enchantability");
        this.defaultRGB = compound.func_74762_e("RGB");
    }

    public float getDecayRate() {
        return this.decayRate;
    }

    public float getDamageDecay() {
        return this.damageDecay;
    }

    public String getName() {
        return this.name;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public int getDefaultRGB() {
        return this.defaultRGB;
    }

    public ShieldType setRepair(ItemStack repairingMaterial, ISensible<ItemStack> comparator) {
        this.repairingMaterial = repairingMaterial;
        this.comparator = comparator;
        return this;
    }

    public boolean canBeRepairedWith(ItemStack stack) {
        if (this.comparator != null) {
            return this.repairingMaterial != null && !this.comparator.differenciate(stack, this.repairingMaterial);
        }
        return ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.repairingMaterial);
    }

    public ShieldType setRepair(NBTTagCompound compound) {
        if (compound.func_150297_b("Repair", 10)) {
            this.setRepair(ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Repair")), IDSensible.INSTANCE);
        }
        return this;
    }

    public static ShieldType fromNBT(NBTTagCompound compound) {
        String name = compound.func_74779_i("Name");
        if (name.isEmpty()) {
            return null;
        }
        return new ShieldType(name, compound).setRepair(compound);
    }

    public static class IDSensible
    implements ISensible<ItemStack> {
        public static final ISensible<ItemStack> INSTANCE = new IDSensible();

        private IDSensible() {
        }

        @Override
        public boolean differenciate(ItemStack holder1, ItemStack holder2) {
            return holder1.func_77973_b() != holder2.func_77973_b();
        }
    }
}

