/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class TransformerBase
implements IClassTransformer,
Opcodes {
    public static final String UTILITY_CLASS = "mods/battlegear2/api/core/BattlegearUtils";
    public static final String SIMPLEST_METHOD_DESC = "()V";
    public Logger logger = LogManager.getLogger((String)"battlegear2");
    protected final String classPath;
    protected final String unobfClass;
    private boolean skipDebug;

    public TransformerBase(String classPath) {
        this.classPath = classPath;
        this.unobfClass = classPath.substring(classPath.lastIndexOf(46) + 1);
        this.setDebug(false);
    }

    protected final void setDebug(boolean debug) {
        this.skipDebug = !debug;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals(this.classPath)) {
            this.logger.log(Level.INFO, "M&B - Patching Class " + this.unobfClass + " (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, this.skipDebug ? 2 : 0);
            this.setupMappings();
            boolean success = this.processFields(cn.fields) && this.processMethods(cn.methods);
            this.addInterface(cn.interfaces);
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            this.logger.log(success ? Level.INFO : Level.ERROR, "M&B - Patching Class " + this.unobfClass + (success ? " done" : " FAILED!"));
            if (!success && BattlegearTranslator.debug) {
                TransformerBase.writeClassFile(cw, this.unobfClass + " (" + name + ")");
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    void addInterface(List<String> interfaces) {
    }

    abstract boolean processMethods(List<MethodNode> var1);

    abstract boolean processFields(List<FieldNode> var1);

    abstract void setupMappings();

    public static void writeClassFile(ClassWriter cw, String name) {
        try {
            File outDir = BattlegearLoadingPlugin.debugOutputLocation;
            outDir.mkdirs();
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(new File(outDir, name + ".class")));
            dout.write(cw.toByteArray());
            dout.flush();
            dout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MethodNode replaceInventoryArrayAccess(MethodNode method, String className, String fieldName, int maxStack, int maxLocal) {
        return TransformerBase.replaceInventoryArrayAccess(method, className, fieldName, 4, maxStack, maxLocal);
    }

    public static MethodNode replaceInventoryArrayAccess(MethodNode method, String className, String fieldName, int todelete, int maxStack, int maxLocal) {
        InsnList newList = new InsnList();
        ListIterator it = method.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)it.next();
            if (nextNode instanceof FieldInsnNode && nextNode.getNext() instanceof FieldInsnNode && ((FieldInsnNode)nextNode).owner.equals(className) && ((FieldInsnNode)nextNode).name.equals(fieldName) && ((FieldInsnNode)nextNode.getNext()).owner.equals(BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer")) && ((FieldInsnNode)nextNode.getNext()).name.equals(BattlegearTranslator.getMapedFieldName("field_70462_a", "mainInventory"))) {
                for (int i = 0; i < todelete; ++i) {
                    nextNode = (AbstractInsnNode)it.next();
                }
                nextNode = (AbstractInsnNode)it.next();
                while (it.hasNext() && nextNode.getOpcode() != 83) {
                    newList.add(nextNode);
                    nextNode = (AbstractInsnNode)it.next();
                }
                newList.add((AbstractInsnNode)new MethodInsnNode(184, UTILITY_CLASS, "setPlayerCurrentItem", "(L" + BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer") + ";L" + BattlegearTranslator.getMapedClassName("item.ItemStack") + ";)V"));
                continue;
            }
            newList.add(nextNode);
        }
        method.instructions = newList;
        method.maxStack = maxStack;
        method.maxLocals = maxLocal;
        return method;
    }

    public void sendPatchLog(String method) {
        this.logger.log(Level.INFO, "\tPatching method " + method + " in " + this.unobfClass);
    }

    public static MethodNode generateSetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(1, methodName, "(" + fieldType + ")V", null, null);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        int opCode = fieldType.equals("I") || fieldType.equals("Z") ? 21 : (fieldType.equals("L") ? 22 : (fieldType.equals("F") ? 23 : (fieldType.equals("D") ? 24 : 25)));
        mn.visitVarInsn(opCode, 1);
        mn.visitFieldInsn(181, className, fieldName, fieldType);
        mn.visitInsn(177);
        mn.visitMaxs(2, 2);
        mn.visitEnd();
        return mn;
    }

    public static MethodNode generateGetter(String className, String methodName, String fieldName, String fieldType) {
        MethodNode mn = new MethodNode(1, methodName, "()" + fieldType, null, null);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, className, fieldName, fieldType);
        int opCode = fieldType.equals("I") || fieldType.equals("Z") ? 172 : (fieldType.equals("L") ? 173 : (fieldType.equals("F") ? 174 : (fieldType.equals("D") ? 175 : 176)));
        mn.visitInsn(opCode);
        mn.visitMaxs(1, 1);
        mn.visitEnd();
        return mn;
    }
}

