/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.bettercrashes.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import vfyjxf.bettercrashes.BetterCrashes;

public class CrashUtils {
    public static void outputReport(CrashReport report) {
        try {
            if (report.func_71497_f() == null) {
                String reportName = "crash-";
                reportName = reportName + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                reportName = reportName + (Minecraft.func_71410_x().func_152345_ab() ? "-client" : "-server");
                reportName = reportName + ".txt";
                File reportsDir = CrashUtils.isClient() ? new File(Minecraft.func_71410_x().field_71412_D, "crash-reports") : new File("crash-reports");
                File reportFile = new File(reportsDir, reportName);
                report.func_147149_a(reportFile);
            }
        }
        catch (Throwable e) {
            BetterCrashes.logger.fatal("Failed saving report", e);
        }
        BetterCrashes.logger.fatal("Minecraft ran into a problem! " + (report.func_71497_f() != null ? "Report saved to: " + report.func_71497_f() : "Crash report could not be saved.") + "\n" + report.func_71502_e());
    }

    private static boolean isClient() {
        try {
            return Minecraft.func_71410_x() != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static void openCrashReport(CrashReport crashReport) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            BetterCrashes.logger.error("Desktop is not supported");
            return;
        }
        File report = crashReport.func_71497_f();
        if (report != null && report.exists()) {
            Desktop.getDesktop().open(report);
        } else {
            BetterCrashes.logger.error("Crash report was not generated");
        }
    }

    public static void openBrowser(URI uri) {
        if (!Desktop.isDesktopSupported()) {
            BetterCrashes.logger.error("Desktop is not supported");
            return;
        }
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openBrowser(String url) {
        try {
            CrashUtils.openBrowser(new URI(url));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

