/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.imgur;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class ImgurClient
implements AutoCloseable {
    private final CloseableHttpClient client;

    public ImgurClient(String clientId, int requestTimeout) {
        this.client = HttpClients.custom().setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", "Client-ID " + clientId))).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).setSocketTimeout(requestTimeout).build()).build();
    }

    public List<String> fetchGalleryImageIDs(String galleryId, boolean ignoreAds) throws IOException, JsonParseException {
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)new HttpGet("https://api.imgur.com/3/album/" + galleryId));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to fetch gallery image IDs. Server returned " + response.getStatusLine());
            }
            String json = new String(IOUtils.toByteArray((InputStream)response.getEntity().getContent()), StandardCharsets.UTF_8);
            GalleryResponse galleryResponse = (GalleryResponse)new GsonBuilder().create().fromJson(json, GalleryResponse.class);
            if (galleryResponse.data == null || galleryResponse.data.images == null) {
                throw new IOException("Server returned unexpected json format: " + json);
            }
            List<String> list = galleryResponse.data.images.stream().filter(image -> !ignoreAds || !image.is_ad).map(image -> image.id).collect(Collectors.toList());
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] fetchImage(String imageId) {
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)new HttpGet("https://i.imgur.com/" + imageId + ".png"));){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed to fetch image. Server returned " + response.getStatusLine());
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private static class GalleryResponse {
        public GalleryData data;

        private GalleryResponse() {
        }

        private static class GalleryData {
            public List<GalleryImage> images;

            private GalleryData() {
            }

            private static class GalleryImage {
                public String id;
                public boolean is_ad;

                private GalleryImage() {
                }
            }
        }
    }
}

